/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.api.support;

import java.util.IdentityHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.model.api.support.ExpressionUpdaterVisitor;
import org.netbeans.modules.xml.xpath.ext.LocationStep;
import org.netbeans.modules.xml.xpath.ext.XPathCoreFunction;
import org.netbeans.modules.xml.xpath.ext.XPathCoreOperation;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathExpressionPath;
import org.netbeans.modules.xml.xpath.ext.XPathExtensionFunction;
import org.netbeans.modules.xml.xpath.ext.XPathLocationPath;
import org.netbeans.modules.xml.xpath.ext.XPathModelFactory;
import org.netbeans.modules.xml.xpath.ext.XPathNumericLiteral;
import org.netbeans.modules.xml.xpath.ext.XPathOperationOrFuntion;
import org.netbeans.modules.xml.xpath.ext.XPathPredicateExpression;
import org.netbeans.modules.xml.xpath.ext.XPathStringLiteral;
import org.netbeans.modules.xml.xpath.ext.XPathVariableReference;
import org.netbeans.modules.xml.xpath.ext.visitor.XPathModelTracerVisitor;
import org.netbeans.modules.xml.xpath.ext.visitor.XPathVisitor;

class UpdateVaribleVisitor
extends XPathModelTracerVisitor {
    private String myName;
    private String myPartName;
    private String myNewName;
    private ExpressionUpdaterVisitor myUpdater;
    private Map<XPathExpression, XPathExpression> myMap;
    private XPathExpression myExpression;

    UpdateVaribleVisitor(String string, String string2, XPathExpression xPathExpression) {
        this.myName = string;
        this.myNewName = string2;
        this.myMap = new IdentityHashMap<XPathExpression, XPathExpression>();
        this.myExpression = xPathExpression;
        this.myUpdater = new ExpressionUpdaterVisitor(this.myMap, xPathExpression);
    }

    UpdateVaribleVisitor(String string, String string2, String string3, XPathExpression xPathExpression) {
        this(string, string3, xPathExpression);
        assert (string2 != null);
        this.myPartName = string2;
    }

    public void visit(LocationStep locationStep) {
        super.visit(locationStep);
        this.updateExpression((XPathExpression)locationStep);
    }

    public void visit(XPathCoreFunction xPathCoreFunction) {
        this.visitChildren((XPathOperationOrFuntion)xPathCoreFunction);
        this.updateExpression((XPathExpression)xPathCoreFunction);
    }

    public void visit(XPathCoreOperation xPathCoreOperation) {
        this.visitChildren((XPathOperationOrFuntion)xPathCoreOperation);
        this.updateExpression((XPathExpression)xPathCoreOperation);
    }

    public void visit(XPathExpressionPath xPathExpressionPath) {
        super.visit(xPathExpressionPath);
        this.updateExpression((XPathExpression)xPathExpressionPath);
    }

    public void visit(XPathExtensionFunction xPathExtensionFunction) {
        this.visitChildren((XPathOperationOrFuntion)xPathExtensionFunction);
        this.updateExpression((XPathExpression)xPathExtensionFunction);
    }

    public void visit(XPathLocationPath xPathLocationPath) {
        super.visit(xPathLocationPath);
        this.updateExpression((XPathExpression)xPathLocationPath);
    }

    public void visit(XPathVariableReference xPathVariableReference) {
        QName qName = xPathVariableReference.getVariableName();
        if (qName != null) {
            String string = qName.getLocalPart();
            if (string == null) {
                return;
            }
            int n = string.indexOf(".");
            XPathModelFactory xPathModelFactory = this.myExpression.getModel().getFactory();
            if (n < 0) {
                if (string.equals(this.myName) && this.myPartName == null) {
                    XPathVariableReference xPathVariableReference2 = xPathModelFactory.newXPathVariableReference(new QName(this.myNewName));
                    this.myMap.put((XPathExpression)xPathVariableReference, (XPathExpression)xPathVariableReference2);
                }
            } else {
                String string2;
                String string3 = string.substring(0, n);
                String string4 = string2 = n < string.length() - 1 ? string.substring(n + 1) : null;
                if (!string3.equals(this.myName)) {
                    return;
                }
                String string5 = this.myPartName != null ? this.myName + "." + this.myNewName : this.myNewName + "." + string2;
                XPathVariableReference xPathVariableReference3 = xPathModelFactory.newXPathVariableReference(new QName(string5));
                this.myMap.put((XPathExpression)xPathVariableReference, (XPathExpression)xPathVariableReference3);
            }
        }
        this.updateExpression((XPathExpression)xPathVariableReference);
    }

    public void visit(XPathStringLiteral xPathStringLiteral) {
        this.updateExpression((XPathExpression)xPathStringLiteral);
    }

    public void visit(XPathNumericLiteral xPathNumericLiteral) {
        this.updateExpression((XPathExpression)xPathNumericLiteral);
    }

    public void visit(XPathPredicateExpression xPathPredicateExpression) {
        this.updateExpression((XPathExpression)xPathPredicateExpression);
    }

    String getExpressionString() {
        if (this.myExpression == null) {
            return null;
        }
        return this.myExpression.getExpressionString();
    }

    private void updateExpression(XPathExpression xPathExpression) {
        xPathExpression.accept((XPathVisitor)this.myUpdater);
        this.myExpression = this.myUpdater.getExpression();
    }
}

