/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.api.support;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.netbeans.modules.bpel.model.api.ActivityHolder;
import org.netbeans.modules.bpel.model.api.BaseScope;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.CompositeActivity;
import org.netbeans.modules.bpel.model.api.ExtendableActivity;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.Scope;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableContainer;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.VariableDeclarationScope;
import org.netbeans.modules.bpel.model.spi.FindHelper;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisibilityScope {
    private BpelEntity baseModelElement;
    private List<BaseScope> myScopeList;
    private List<VariableDeclarationScope> myVarScopeList;
    private VisibleVariables mVisibleVariables;

    public VisibilityScope(BpelEntity bpelEntity, Lookup lookup) {
        this.baseModelElement = bpelEntity;
    }

    public VisibilityScope(BpelEntity bpelEntity) {
        this.baseModelElement = bpelEntity;
    }

    private void calculateScopeList(BpelEntity bpelEntity) {
        this.myScopeList = new LinkedList<BaseScope>();
        FindHelper findHelper = (FindHelper)Lookup.getDefault().lookup(FindHelper.class);
        Iterator<BaseScope> iterator = findHelper.scopeIterator(bpelEntity);
        while (iterator.hasNext()) {
            BaseScope baseScope = iterator.next();
            this.myScopeList.add(0, baseScope);
        }
        if (bpelEntity instanceof Process && this.myScopeList.isEmpty()) {
            this.myScopeList.add((BaseScope)bpelEntity);
        }
    }

    private void calculateVarScopeList(BpelEntity bpelEntity) {
        this.myVarScopeList = new LinkedList<VariableDeclarationScope>();
        FindHelper findHelper = (FindHelper)Lookup.getDefault().lookup(FindHelper.class);
        Iterator<VariableDeclarationScope> iterator = findHelper.varaibleDeclarationScopes(bpelEntity);
        while (iterator.hasNext()) {
            VariableDeclarationScope variableDeclarationScope = iterator.next();
            this.myVarScopeList.add(0, variableDeclarationScope);
        }
        if (bpelEntity instanceof Process && this.myVarScopeList.isEmpty()) {
            this.myVarScopeList.add((BaseScope)bpelEntity);
        }
    }

    public BpelEntity getBaseModelElement() {
        return this.baseModelElement;
    }

    public List<BaseScope> getScopeChain() {
        if (this.myScopeList == null) {
            this.calculateScopeList(this.baseModelElement);
        }
        return this.myScopeList;
    }

    public BaseScope getClosestScope() {
        List<BaseScope> list = this.getScopeChain();
        assert (!list.isEmpty()) : "The VisibilityScope should never be empty";
        return list.get(list.size() - 1);
    }

    public List<VariableDeclarationScope> getVarScopeChain() {
        if (this.myVarScopeList == null) {
            this.calculateVarScopeList(this.baseModelElement);
        }
        return this.myVarScopeList;
    }

    public VariableDeclarationScope getClosestVarScope() {
        List<VariableDeclarationScope> list = this.getVarScopeChain();
        assert (!list.isEmpty()) : "The VisibilityScope should never be empty";
        return list.get(list.size() - 1);
    }

    public VariableDeclaration lookForVariable(String string) {
        Object var2_2 = null;
        List<VariableDeclarationScope> list = this.getVarScopeChain();
        ListIterator<VariableDeclarationScope> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            VariableDeclarationScope variableDeclarationScope = listIterator.previous();
            List<VariableDeclaration> list2 = Utils.getVarDeclInScope(variableDeclarationScope);
            if (list2 == null) continue;
            for (VariableDeclaration variableDeclaration : list2) {
                if (!variableDeclaration.getVariableName().equals(string)) continue;
                return variableDeclaration;
            }
        }
        return null;
    }

    public synchronized VisibleVariables getVisibleVariables() {
        if (this.mVisibleVariables == null) {
            this.mVisibleVariables = this.calculateVisibleVariables();
        }
        return this.mVisibleVariables;
    }

    private VisibleVariables calculateVisibleVariables() {
        VisibleVariables visibleVariables = new VisibleVariables();
        HashSet<String> hashSet = new HashSet<String>();
        List<VariableDeclarationScope> list = this.getVarScopeChain();
        for (int i = list.size() - 1; i >= 0; --i) {
            VariableDeclarationScope variableDeclarationScope = list.get(i);
            List<VariableDeclaration> list2 = Utils.getVarDeclInScope(variableDeclarationScope);
            for (VariableDeclaration variableDeclaration : list2) {
                String string = variableDeclaration.getVariableName();
                if (hashSet.contains(string)) {
                    visibleVariables.mAllOverridenVariables.add(variableDeclaration);
                    continue;
                }
                hashSet.add(string);
                visibleVariables.mAllVisibleVariables.add(variableDeclaration);
            }
        }
        return visibleVariables;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class VisibleVariables {
        private HashSet<VariableDeclaration> mAllVisibleVariables = new HashSet();
        private HashSet<VariableDeclaration> mAllOverridenVariables = new HashSet();

        public Set<VariableDeclaration> getAllVisibleVariables() {
            return this.mAllVisibleVariables;
        }

        public Set<VariableDeclaration> getAllOverridenVariables() {
            return this.mAllOverridenVariables;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Utils {
        public static List<Scope> getNestedScopes(BpelEntity bpelEntity) {
            ArrayList<Scope> arrayList = new ArrayList<Scope>();
            Utils.addNestedScopes(bpelEntity, arrayList);
            return arrayList;
        }

        public static List<VariableDeclarationScope> getNestedVarScopes(BpelEntity bpelEntity) {
            ArrayList<VariableDeclarationScope> arrayList = new ArrayList<VariableDeclarationScope>();
            Utils.addNestedVarScopes(bpelEntity, arrayList);
            return arrayList;
        }

        private static void addNestedScopes(BpelEntity bpelEntity, List<Scope> list) {
            if (bpelEntity == null || list == null) {
                return;
            }
            if (bpelEntity instanceof Scope) {
                list.add((Scope)bpelEntity);
            } else if (bpelEntity instanceof ActivityHolder) {
                Utils.addNestedScopes(((ActivityHolder)bpelEntity).getActivity(), list);
            } else if (bpelEntity instanceof CompositeActivity) {
                ExtendableActivity[] extendableActivityArray;
                for (ExtendableActivity extendableActivity : extendableActivityArray = ((CompositeActivity)bpelEntity).getActivities()) {
                    Utils.addNestedScopes(extendableActivity, list);
                }
            }
        }

        private static void addNestedVarScopes(BpelEntity bpelEntity, List<VariableDeclarationScope> list) {
            if (bpelEntity == null || list == null) {
                return;
            }
            if (bpelEntity instanceof VariableDeclarationScope) {
                list.add((VariableDeclarationScope)bpelEntity);
            } else if (bpelEntity instanceof ActivityHolder) {
                Utils.addNestedVarScopes(((ActivityHolder)bpelEntity).getActivity(), list);
            } else if (bpelEntity instanceof CompositeActivity) {
                ExtendableActivity[] extendableActivityArray;
                for (ExtendableActivity extendableActivity : extendableActivityArray = ((CompositeActivity)bpelEntity).getActivities()) {
                    Utils.addNestedVarScopes(extendableActivity, list);
                }
            }
        }

        public static List<VariableDeclaration> getVarDeclInScope(VariableDeclarationScope variableDeclarationScope) {
            ArrayList<VariableDeclaration> arrayList;
            block6: {
                block7: {
                    block5: {
                        Variable[] variableArray;
                        arrayList = new ArrayList<VariableDeclaration>();
                        if (!(variableDeclarationScope instanceof BaseScope)) break block5;
                        VariableContainer variableContainer = ((BaseScope)variableDeclarationScope).getVariableContainer();
                        if (variableContainer == null) break block6;
                        for (Variable variable : variableArray = variableContainer.getVariables()) {
                            arrayList.add(variable);
                        }
                        break block6;
                    }
                    if (!(variableDeclarationScope instanceof VariableDeclaration)) break block7;
                    VariableDeclaration variableDeclaration = (VariableDeclaration)((Object)variableDeclarationScope);
                    String string = variableDeclaration.getVariableName();
                    if (string == null || string.length() == 0) break block6;
                    NamedComponentReference<Object> namedComponentReference = null;
                    namedComponentReference = variableDeclaration.getMessageType();
                    if (namedComponentReference == null && (namedComponentReference = variableDeclaration.getType()) == null) {
                        namedComponentReference = variableDeclaration.getElement();
                    }
                    if (namedComponentReference != null) {
                        arrayList.add(variableDeclaration);
                    }
                    break block6;
                }
                if (variableDeclarationScope instanceof VariableContainer) {
                    Variable[] variableArray;
                    VariableContainer variableContainer = (VariableContainer)variableDeclarationScope;
                    for (Variable variable : variableArray = variableContainer.getVariables()) {
                        arrayList.add(variable);
                    }
                }
            }
            return arrayList;
        }

        public static Set<VariableDeclaration> getAllOverridenVariables(VisibilityScope visibilityScope) {
            HashSet<VariableDeclaration> hashSet = new HashSet<VariableDeclaration>();
            HashSet<String> hashSet2 = new HashSet<String>();
            List<VariableDeclarationScope> list = visibilityScope.getVarScopeChain();
            for (int i = list.size() - 1; i >= 0; --i) {
                VariableDeclarationScope variableDeclarationScope = list.get(i);
                List<VariableDeclaration> list2 = Utils.getVarDeclInScope(variableDeclarationScope);
                for (VariableDeclaration variableDeclaration : list2) {
                    String string = variableDeclaration.getVariableName();
                    if (hashSet2.contains(string)) {
                        hashSet.add(variableDeclaration);
                        continue;
                    }
                    hashSet2.add(string);
                }
            }
            return hashSet;
        }
    }
}

