/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.api.support;

import org.netbeans.modules.bpel.model.api.references.SchemaReference;
import org.netbeans.modules.bpel.model.api.support.BpelXPathModelFactory;
import org.netbeans.modules.bpel.model.ext.editor.api.Cast;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.xpath.ext.XPathException;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathModel;
import org.netbeans.modules.xml.xpath.ext.XPathSchemaContextHolder;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.XPathSchemaContext;
import org.netbeans.modules.xml.xpath.ext.spi.XPathCast;
import org.openide.ErrorManager;

public class XPathCastImpl
implements XPathCast {
    private Cast mCast;
    private String myPathText;
    private GlobalType mCastTo;
    private XPathExpression mXPathExpression;

    public static XPathExpression getExpression(Cast cast) {
        String string = cast.getPath();
        XPathModel xPathModel = BpelXPathModelFactory.create(cast);
        XPathExpression xPathExpression = null;
        try {
            xPathExpression = xPathModel.parseExpression(string);
        }
        catch (XPathException xPathException) {
            ErrorManager.getDefault().log(16, "Unresolved XPath: " + string);
        }
        return xPathExpression;
    }

    public static XPathCastImpl convert(Cast cast) {
        SchemaReference<? extends GlobalType> schemaReference = cast.getType();
        if (schemaReference == null) {
            return null;
        }
        GlobalType globalType = (GlobalType)schemaReference.get();
        if (globalType == null) {
            return null;
        }
        String string = cast.getPath();
        if (cast == null || string == null || string.length() == 0) {
            return null;
        }
        XPathCastImpl xPathCastImpl = new XPathCastImpl();
        xPathCastImpl.mCast = cast;
        xPathCastImpl.myPathText = string;
        xPathCastImpl.mCastTo = globalType;
        return xPathCastImpl;
    }

    private XPathCastImpl() {
    }

    public XPathCastImpl(XPathExpression xPathExpression, GlobalType globalType) {
        assert (xPathExpression != null);
        assert (globalType != null);
        this.mXPathExpression = xPathExpression;
        this.mCastTo = globalType;
    }

    public String getPathText() {
        if (this.myPathText == null) {
            assert (this.mXPathExpression != null);
            this.myPathText = this.mXPathExpression.getExpressionString();
        }
        return this.myPathText;
    }

    public GlobalType getType() {
        return this.mCastTo;
    }

    public XPathExpression getPathExpression() {
        if (this.mXPathExpression == null) {
            this.mXPathExpression = XPathCastImpl.getExpression(this.mCast);
        }
        return this.mXPathExpression;
    }

    public String toString() {
        return "(" + this.mCastTo.toString() + ")" + this.mXPathExpression.getExpressionString();
    }

    public XPathSchemaContext getSchemaContext() {
        XPathExpression xPathExpression = this.getPathExpression();
        if (xPathExpression != null && xPathExpression instanceof XPathSchemaContextHolder) {
            XPathSchemaContext xPathSchemaContext = ((XPathSchemaContextHolder)xPathExpression).getSchemaContext();
            return xPathSchemaContext;
        }
        return null;
    }

    public void setSchemaContext(XPathSchemaContext xPathSchemaContext) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

