/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.impl.services;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.bpel.model.api.ForEach;
import org.netbeans.modules.bpel.model.api.FromPart;
import org.netbeans.modules.bpel.model.api.OnEvent;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.model.api.support.Utils;
import org.netbeans.modules.bpel.model.impl.services.ForEachVariableChecker;
import org.netbeans.modules.bpel.model.impl.services.FromPartVariableChecker;
import org.netbeans.modules.bpel.model.impl.services.InnerEventDispatcherAdapter;
import org.netbeans.modules.bpel.model.impl.services.OnEventVariableChecker;
import org.netbeans.modules.bpel.model.impl.services.ScopeInsideOnEventChecker;
import org.netbeans.modules.bpel.model.impl.services.VariableDeclarationChecker;

public class DuplicateVariableDeclarationCheck
extends InnerEventDispatcherAdapter {
    public boolean isApplicable(ChangeEvent changeEvent) {
        if (changeEvent instanceof PropertyUpdateEvent) {
            PropertyUpdateEvent propertyUpdateEvent = (PropertyUpdateEvent)changeEvent;
            if (changeEvent.getParent().getBpelModel().inSync()) {
                return false;
            }
            if (propertyUpdateEvent.getNewValue() == null) {
                return false;
            }
            return changeEvent.getParent() instanceof VariableDeclaration && this.isApplicable((VariableDeclaration)changeEvent.getParent(), propertyUpdateEvent.getName());
        }
        return false;
    }

    public void preDispatch(ChangeEvent changeEvent) throws VetoException {
        assert (changeEvent instanceof PropertyUpdateEvent);
        Object object = ((PropertyUpdateEvent)changeEvent).getNewValue();
        if (object == null) {
            return;
        }
        VariableDeclarationChecker variableDeclarationChecker = (VariableDeclarationChecker)LazyInit.CHECKERS.get(changeEvent.getParent().getElementType());
        if (!variableDeclarationChecker.check((VariableDeclaration)changeEvent.getParent(), object)) {
            throw new VetoException(Utils.getResourceString(variableDeclarationChecker.getError((VariableDeclaration)changeEvent.getParent()), changeEvent.getName()), changeEvent);
        }
    }

    private boolean isApplicable(VariableDeclaration variableDeclaration, String string) {
        VariableDeclarationChecker variableDeclarationChecker = (VariableDeclarationChecker)LazyInit.CHECKERS.get(variableDeclaration.getElementType());
        return variableDeclarationChecker != null && variableDeclarationChecker.isApplicable(variableDeclaration, string);
    }

    private static class LazyInit {
        private static final Map<Class<? extends VariableDeclaration>, VariableDeclarationChecker> CHECKERS = new HashMap<Class<? extends VariableDeclaration>, VariableDeclarationChecker>();

        private LazyInit() {
        }

        static {
            CHECKERS.put(ForEach.class, new ForEachVariableChecker());
            CHECKERS.put(OnEvent.class, new OnEventVariableChecker());
            CHECKERS.put(FromPart.class, new FromPartVariableChecker());
            CHECKERS.put(Variable.class, new ScopeInsideOnEventChecker());
        }
    }
}

