/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.impl.services;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.CorrelationSet;
import org.netbeans.modules.bpel.model.api.Link;
import org.netbeans.modules.bpel.model.api.MessageExchange;
import org.netbeans.modules.bpel.model.api.NamedElement;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.model.api.support.Utils;
import org.netbeans.modules.bpel.model.impl.services.CorrelationSetErrorBuilder;
import org.netbeans.modules.bpel.model.impl.services.ErrorMessageBuilder;
import org.netbeans.modules.bpel.model.impl.services.InnerEventDispatcherAdapter;
import org.netbeans.modules.bpel.model.impl.services.LinkErrorBuilder;
import org.netbeans.modules.bpel.model.impl.services.MessageExchangeErrorBuilder;
import org.netbeans.modules.bpel.model.impl.services.PartnerLinkErrorBuilder;
import org.netbeans.modules.bpel.model.impl.services.VariableErrorBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueNameCheck
extends InnerEventDispatcherAdapter {
    @Override
    public boolean isApplicable(ChangeEvent changeEvent) {
        if (changeEvent instanceof PropertyUpdateEvent) {
            PropertyUpdateEvent propertyUpdateEvent = (PropertyUpdateEvent)changeEvent;
            if (changeEvent.getParent().getBpelModel().inSync()) {
                return false;
            }
            String string = propertyUpdateEvent.getName();
            if (((PropertyUpdateEvent)changeEvent).getNewValue() == null) {
                return false;
            }
            return string.equals("name") && (changeEvent.getParent() instanceof Variable || changeEvent.getParent() instanceof CorrelationSet || changeEvent.getParent() instanceof PartnerLink || changeEvent.getParent() instanceof MessageExchange || changeEvent.getParent() instanceof Link);
        }
        return false;
    }

    @Override
    public void preDispatch(ChangeEvent changeEvent) throws VetoException {
        BpelContainer bpelContainer = changeEvent.getParent().getParent();
        if (bpelContainer != null) {
            for (BpelEntity bpelEntity : bpelContainer.getChildren(changeEvent.getParent().getElementType())) {
                if (!(bpelEntity instanceof NamedElement) || bpelEntity.equals(changeEvent.getParent())) continue;
                NamedElement namedElement = (NamedElement)((Object)bpelEntity);
                if (!((PropertyUpdateEvent)changeEvent).getNewValue().equals(namedElement.getName())) continue;
                String string = Utils.getResourceString(this.getError(bpelEntity.getElementType()), namedElement.getName());
                throw new VetoException(string, changeEvent);
            }
        }
    }

    private String getError(Class<? extends BpelEntity> clazz) {
        return ((ErrorMessageBuilder)LazyInit.ERROR_BUILDERS.get(clazz)).getError();
    }

    private static class LazyInit {
        private static final Map<Class<? extends BpelEntity>, ErrorMessageBuilder> ERROR_BUILDERS = new HashMap<Class<? extends BpelEntity>, ErrorMessageBuilder>();

        private LazyInit() {
        }

        static {
            ERROR_BUILDERS.put(Variable.class, new VariableErrorBuilder());
            ERROR_BUILDERS.put(CorrelationSet.class, new CorrelationSetErrorBuilder());
            ERROR_BUILDERS.put(PartnerLink.class, new PartnerLinkErrorBuilder());
            ERROR_BUILDERS.put(MessageExchange.class, new MessageExchangeErrorBuilder());
            ERROR_BUILDERS.put(Link.class, new LinkErrorBuilder());
        }
    }
}

