/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.cache.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.modelimpl.cache.impl.AbstractCacheIndex;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;

final class ProjectIndex
extends AbstractCacheIndex
implements Serializable {
    private static final long serialVersionUID = -7790789617759717723L;

    ProjectIndex() {
    }

    public Entry getFileEntry(CsmFile csmFile) {
        Entry entry = (Entry)super.get(csmFile);
        return entry;
    }

    public Entry putFile(CsmFile csmFile) {
        Entry entry = (Entry)super.put(csmFile);
        return entry;
    }

    public void invalidateFile(String string) {
        Entry entry = (Entry)super.get(string);
        if (entry != null) {
            entry.setLastModified(0L);
        }
    }

    protected void loadData(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        if (n >= 1) {
            super.loadData(objectInputStream);
        }
    }

    protected void saveData(ObjectOutputStream objectOutputStream) throws IOException {
        int n = 1;
        objectOutputStream.writeInt(n);
        super.saveData(objectOutputStream);
    }

    protected CharSequence getIndexKey(Object object) {
        CharSequence charSequence;
        if (object instanceof String) {
            charSequence = (String)object;
        } else {
            CsmFile csmFile = (CsmFile)object;
            charSequence = csmFile.getAbsolutePath();
        }
        return FilePathCache.getString((CharSequence)charSequence);
    }

    protected CharSequence getBaseCacheName(Object object) {
        CsmFile csmFile = (CsmFile)object;
        CharSequence charSequence = csmFile.getName();
        return charSequence;
    }

    protected Object createValue(CharSequence charSequence, Object object) {
        return new Entry(charSequence, 0L);
    }

    protected boolean isEqual(Object object, CharSequence charSequence) {
        return ((Entry)object).getCacheFileName().equals(charSequence);
    }

    static final class Entry
    implements Serializable {
        private static final long serialVersionUID = -7790789617759717723L;
        private transient CharSequence cacheFileName;
        private transient long lastModified;

        private Entry(CharSequence charSequence, long l) {
            this.setCacheFileName(charSequence);
            this.setLastModified(l);
        }

        public CharSequence getCacheFileName() {
            return this.cacheFileName;
        }

        public void setCacheFileName(CharSequence charSequence) {
            this.cacheFileName = charSequence;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(long l) {
            this.lastModified = l;
        }

        public String toString() {
            String string = "[" + this.cacheFileName + ";" + this.lastModified + "]";
            return string;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(this.cacheFileName);
            objectOutputStream.writeLong(this.lastModified);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.cacheFileName = (String)objectInputStream.readObject();
            this.lastModified = objectInputStream.readLong();
        }
    }
}

