/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.CastUtils;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.core.ResolverFactory;
import org.netbeans.modules.cnd.modelimpl.csm.core.Unresolved;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionImplEx<T>
extends FunctionImpl<T> {
    private CharSequence qualifiedName;
    private boolean qualifiedNameIsFake = false;
    private final CharSequence[] classOrNspNames;

    public FunctionImplEx(AST aST, CsmFile csmFile, CsmScope csmScope) throws AstRendererException {
        this(aST, csmFile, csmScope, true);
    }

    protected FunctionImplEx(AST aST, CsmFile csmFile, CsmScope csmScope, boolean bl) throws AstRendererException {
        super(aST, csmFile, csmScope, false);
        CharSequence[] charSequenceArray = this.classOrNspNames = CastUtils.isCast(aST) ? CastUtils.getClassOrNspNames(aST) : FunctionImplEx.initClassOrNspNames(aST);
        if (bl) {
            this.registerInProject();
        }
    }

    protected CsmObject findOwner(Resolver resolver) {
        CharSequence[] charSequenceArray = this.classOrNspNames;
        if (charSequenceArray != null) {
            CsmObject csmObject = ResolverFactory.createResolver(this, resolver).resolve(charSequenceArray, 3);
            if (csmObject instanceof CsmClass) {
                if (!(csmObject instanceof Unresolved.UnresolvedClass)) {
                    return (CsmClass)csmObject;
                }
            } else if (csmObject instanceof CsmNamespace) {
                return (CsmNamespace)csmObject;
            }
        }
        return null;
    }

    public static String[] initClassOrNspNames(AST aST) {
        AST aST2 = AstUtil.findMethodName(aST);
        if (aST2 == null) {
            return null;
        }
        int n = aST2.getNumberOfChildren();
        if (n >= 1) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (AST aST3 = aST2.getFirstChild(); aST3 != null; aST3 = aST3.getNextSibling()) {
                if (aST3.getType() != 204 || aST3.getNextSibling() == null) continue;
                arrayList.add(aST3.getText());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return null;
    }

    @Override
    public CharSequence getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = QualifiedNameCache.getManager().getString((CharSequence)this.findQualifiedName());
        }
        return this.qualifiedName;
    }

    protected String findQualifiedName() {
        CsmObject csmObject = this.findOwner(null);
        if (csmObject instanceof CsmQualifiedNamedElement) {
            this.qualifiedNameIsFake = false;
            return ((Object)((CsmQualifiedNamedElement)csmObject).getQualifiedName()).toString() + this.getScopeSuffix() + "::" + this.getQualifiedNamePostfix();
        }
        this.qualifiedNameIsFake = true;
        CharSequence[] charSequenceArray = this.classOrNspNames;
        CsmNamespaceDefinition csmNamespaceDefinition = this.findNamespaceDefinition();
        StringBuilder stringBuilder = new StringBuilder();
        if (csmNamespaceDefinition != null) {
            stringBuilder.append(csmNamespaceDefinition.getQualifiedName());
        }
        if (charSequenceArray != null) {
            for (int i = 0; i < charSequenceArray.length; ++i) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("::");
                }
                stringBuilder.append(charSequenceArray[i]);
            }
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("unknown>");
        }
        stringBuilder.append(this.getScopeSuffix());
        stringBuilder.append("::");
        stringBuilder.append(this.getQualifiedNamePostfix());
        return stringBuilder.toString();
    }

    @Override
    protected void registerInProject() {
        super.registerInProject();
        if (this.qualifiedNameIsFake) {
            ((FileImpl)this.getContainingFile()).onFakeRegisration(this);
        }
    }

    public void fixFakeRegistration() {
        CharSequence charSequence = QualifiedNameCache.getManager().getString((CharSequence)this.findQualifiedName());
        if (!charSequence.equals(this.qualifiedName)) {
            ProjectBase projectBase = ((FileImpl)this.getContainingFile()).getProjectImpl();
            projectBase.unregisterDeclaration((CsmDeclaration)this);
            this.cleanUID();
            this.qualifiedName = charSequence;
            projectBase.registerDeclaration(this);
        }
    }

    private CsmNamespaceDefinition findNamespaceDefinition() {
        return this.findNamespaceDefinition(this.getContainingFile().getDeclarations());
    }

    private CsmNamespaceDefinition findNamespaceDefinition(Collection collection) {
        CsmOffsetableDeclaration csmOffsetableDeclaration;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && (csmOffsetableDeclaration = (CsmOffsetableDeclaration)iterator.next()).getStartOffset() <= this.getStartOffset()) {
            if (csmOffsetableDeclaration.getKind() != CsmDeclaration.Kind.NAMESPACE_DEFINITION || this.getEndOffset() >= csmOffsetableDeclaration.getEndOffset()) continue;
            CsmNamespaceDefinition csmNamespaceDefinition = (CsmNamespaceDefinition)csmOffsetableDeclaration;
            CsmNamespaceDefinition csmNamespaceDefinition2 = this.findNamespaceDefinition(csmNamespaceDefinition.getDeclarations());
            return csmNamespaceDefinition2 == null ? csmNamespaceDefinition : csmNamespaceDefinition2;
        }
        return null;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        PersistentUtils.writeUTF(this.qualifiedName, dataOutput);
        dataOutput.writeBoolean(this.qualifiedNameIsFake);
        PersistentUtils.writeStrings(this.classOrNspNames, dataOutput);
    }

    public FunctionImplEx(DataInput dataInput) throws IOException {
        super(dataInput);
        String string = PersistentUtils.readUTF(dataInput);
        this.qualifiedName = string == null ? null : QualifiedNameCache.getManager().getString((CharSequence)string);
        this.qualifiedNameIsFake = dataInput.readBoolean();
        this.classOrNspNames = PersistentUtils.readStrings(dataInput, NameCache.getManager());
    }
}

