/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.RawNamable;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceAliasImpl
extends OffsetableDeclarationBase<CsmNamespaceAlias>
implements CsmNamespaceAlias,
RawNamable {
    private final CharSequence alias;
    private final CharSequence namespace;
    private final CharSequence[] rawName;
    private CsmUID<CsmNamespace> referencedNamespaceUID = null;

    public NamespaceAliasImpl(AST aST, CsmFile csmFile) {
        super(aST, csmFile);
        AST aST2;
        this.rawName = NamespaceAliasImpl.createRawName(aST);
        this.alias = QualifiedNameCache.getManager().getString((CharSequence)aST.getText());
        for (aST2 = aST.getFirstChild(); aST2 != null && aST2.getType() != 131; aST2 = aST2.getNextSibling()) {
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (aST2 == null) {
            if (FileImpl.reportErrors) {
                int n = aST.getLine();
                int n2 = aST.getColumn();
                AST aST3 = aST.getFirstChild();
                if (aST3 != null) {
                    n = aST3.getLine();
                    n2 = aST3.getColumn();
                }
                System.err.println("Corrupted AST for namespace alias in " + csmFile.getAbsolutePath() + ' ' + n + ":" + n2);
            }
            this.namespace = CharSequenceKey.empty();
        } else {
            for (aST2 = aST2.getNextSibling(); aST2 != null; aST2 = aST2.getNextSibling()) {
                stringBuilder.append(aST2.getText());
            }
            this.namespace = QualifiedNameCache.getManager().getString((CharSequence)stringBuilder.toString());
        }
    }

    public CsmNamespace getReferencedNamespace() {
        return ((ProjectBase)this.getContainingFile().getProject()).findNamespace(this.namespace, true);
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.NAMESPACE_ALIAS;
    }

    public CharSequence getAlias() {
        return this.alias;
    }

    public CharSequence getName() {
        return this.getAlias();
    }

    public CharSequence getQualifiedName() {
        return this.getName();
    }

    private static String[] createRawName(AST aST) {
        AST aST2;
        for (aST2 = aST.getFirstChild(); aST2 != null && aST2.getType() != 131; aST2 = aST2.getNextSibling()) {
        }
        if (aST2 != null && (aST2 = aST2.getNextSibling()) != null && aST2.getType() == 282) {
            return AstUtil.getRawName(aST2.getFirstChild());
        }
        return new String[0];
    }

    @Override
    public CharSequence[] getRawName() {
        return this.rawName;
    }

    @Override
    public String toString() {
        return "" + this.getKind() + ' ' + this.alias + '=' + this.namespace;
    }

    public CsmScope getScope() {
        return null;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.alias != null);
        dataOutput.writeUTF(((Object)this.alias).toString());
        assert (this.namespace != null);
        dataOutput.writeUTF(((Object)this.namespace).toString());
        PersistentUtils.writeStrings(this.rawName, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.referencedNamespaceUID, dataOutput);
    }

    public NamespaceAliasImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.alias = QualifiedNameCache.getManager().getString((CharSequence)dataInput.readUTF());
        assert (this.alias != null);
        this.namespace = QualifiedNameCache.getManager().getString((CharSequence)dataInput.readUTF());
        assert (this.namespace != null);
        this.rawName = PersistentUtils.readStrings(dataInput, NameCache.getManager());
        this.referencedNamespaceUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
    }
}

