/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmIdentifiable;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedefImpl
extends OffsetableDeclarationBase<CsmTypedef>
implements CsmTypedef,
Disposable,
CsmScopeElement {
    private final CharSequence name;
    private final CsmType type;
    private boolean typeUnnamed = false;
    private CsmObject containerRef;
    private CsmUID<CsmIdentifiable> containerUID;

    public TypedefImpl(AST aST, CsmFile csmFile, CsmObject csmObject, CsmType csmType, String string) {
        super(aST, csmFile);
        if (csmObject instanceof CsmIdentifiable) {
            this.containerUID = UIDCsmConverter.identifiableToUID((CsmIdentifiable)csmObject);
            assert (this.containerUID != null || csmObject == null);
            this.containerRef = null;
        } else {
            this.containerRef = csmObject;
        }
        this.type = csmType == null ? this.createType(aST) : csmType;
        this.name = QualifiedNameCache.getManager().getString((CharSequence)string);
    }

    public boolean isTypeUnnamed() {
        return this.typeUnnamed;
    }

    public void setTypeUnnamed() {
        this.typeUnnamed = true;
    }

    public CsmScope getScope() {
        CsmObject csmObject = this._getContainer();
        if (csmObject instanceof CsmNamespace) {
            return (CsmNamespace)csmObject;
        }
        if (csmObject instanceof CsmClass) {
            return (CsmClass)csmObject;
        }
        return this.getContainingFile();
    }

    @Override
    public void dispose() {
        CsmScope csmScope;
        super.dispose();
        this.onDispose();
        if (this.type != null && this.type instanceof Disposable) {
            ((Disposable)this.type).dispose();
        }
        if ((csmScope = this.getScope()) instanceof MutableDeclarationsContainer) {
            ((MutableDeclarationsContainer)csmScope).removeDeclaration(this);
        }
        FileImpl fileImpl = (FileImpl)this.getContainingFile();
        fileImpl.getProjectImpl().unregisterDeclaration((CsmDeclaration)this);
    }

    private void onDispose() {
        if (TraceFlags.RESTORE_CONTAINER_FROM_UID) {
            this.containerRef = UIDCsmConverter.UIDtoIdentifiable(this.containerUID);
            assert (this.containerRef != null || this.containerUID == null) : "null object for UID " + this.containerUID;
        }
    }

    public CharSequence getQualifiedName() {
        CharSequence charSequence;
        CsmObject csmObject = this._getContainer();
        if (CsmKindUtilities.isClass((CsmObject)csmObject)) {
            return CharSequenceKey.create((CharSequence)(((CsmClass)csmObject).getQualifiedName() + "::" + this.getQualifiedNamePostfix()));
        }
        if (CsmKindUtilities.isNamespace((CsmObject)csmObject) && (charSequence = ((CsmNamespace)csmObject).getQualifiedName()) != null && charSequence.length() > 0) {
            return CharSequenceKey.create((CharSequence)(((Object)charSequence).toString() + "::" + this.getQualifiedNamePostfix()));
        }
        return this.getName();
    }

    public CharSequence getName() {
        return this.name;
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.TYPEDEF;
    }

    private final CsmType createType(AST aST) {
        AST aST2 = null;
        int n = 0;
        AST aST3 = null;
        for (AST aST4 = aST.getFirstChild(); aST4 != null; aST4 = aST4.getNextSibling()) {
            switch (aST4.getType()) {
                case 253: 
                case 254: {
                    aST3 = aST4;
                    break;
                }
                case 74: {
                    AST aST5 = aST4.getNextSibling();
                    if (aST5 == null || aST5.getType() != 282) break;
                    aST3 = aST5;
                }
            }
            if (aST3 != null) break;
        }
        if (aST3 != null) {
            return TypeFactory.createType(aST3, this.getContainingFile(), aST2, n);
        }
        return null;
    }

    public CsmType getType() {
        return this.type;
    }

    private CsmObject _getContainer() {
        CsmObject csmObject = this.containerRef;
        if (csmObject == null) {
            csmObject = UIDCsmConverter.UIDtoIdentifiable(this.containerUID);
            assert (csmObject != null || this.containerUID == null) : "null object for UID " + this.containerUID;
        }
        return csmObject;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.name != null);
        dataOutput.writeUTF(((Object)this.name).toString());
        dataOutput.writeBoolean(this.typeUnnamed);
        assert (this.type != null);
        PersistentUtils.writeType(this.type, dataOutput);
        assert (this.containerUID != null);
        UIDObjectFactory.getDefaultFactory().writeUID(this.containerUID, dataOutput);
    }

    public TypedefImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = QualifiedNameCache.getManager().getString((CharSequence)dataInput.readUTF());
        assert (this.name != null);
        this.typeUnnamed = dataInput.readBoolean();
        this.type = PersistentUtils.readType(dataInput);
        assert (this.type != null);
        this.containerUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        assert (this.containerUID != null);
        this.containerRef = null;
    }
}

