/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectImpl;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeepReparsingUtils {
    private DeepReparsingUtils() {
    }

    public static void reparseOnEdit(FileImpl fileImpl, ProjectBase projectBase) {
        DeepReparsingUtils.reparseOnEdit(fileImpl, projectBase, true);
    }

    public static void reparseOnEdit(FileImpl fileImpl, ProjectBase projectBase, boolean bl) {
        Set<CsmFile> set = projectBase.getGraph().getTopParentFiles(fileImpl);
        if (set.size() > 0) {
            Set<CsmFile> set2 = projectBase.getGraph().getCoherenceFiles(fileImpl);
            for (CsmFile csmFile : set2) {
                if (set.contains(csmFile)) continue;
                DeepReparsingUtils.invalidateFileAndPreprocState(projectBase, csmFile);
            }
            if (bl) {
                DeepReparsingUtils.addToReparse(projectBase, set, new HashSet<CsmFile>(0), false);
            }
        } else if (bl) {
            ParserQueue.instance().add(fileImpl, projectBase.getPreprocHandler(fileImpl.getBuffer().getFile()).getState(), ParserQueue.Position.HEAD);
        }
    }

    public static void reparseOnPropertyChanged(NativeFileItem nativeFileItem, ProjectBase projectBase) {
        FileImpl fileImpl = projectBase.getFile(nativeFileItem.getFile());
        if (fileImpl == null) {
            return;
        }
        if (TraceFlags.USE_DEEP_REPARSING) {
            Set<CsmFile> set = projectBase.getGraph().getTopParentFiles(fileImpl);
            Set<CsmFile> set2 = projectBase.getGraph().getIncludedFiles(fileImpl);
            for (CsmFile csmFile : set2) {
                if (set.contains(csmFile)) continue;
                DeepReparsingUtils.invalidateFileAndPreprocState(projectBase, csmFile);
            }
            DeepReparsingUtils.addToReparse(projectBase, nativeFileItem, fileImpl);
            set.remove(fileImpl);
            DeepReparsingUtils.addToReparse(projectBase, set, new HashSet<CsmFile>(0), false);
        } else {
            DeepReparsingUtils.addToReparse(projectBase, nativeFileItem, fileImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reparseOnPropertyChanged(List<NativeFileItem> list, ProjectImpl projectImpl) {
        try {
            ParserQueue.instance().onStartAddingProjectFiles(projectImpl);
            if (TraceFlags.USE_DEEP_REPARSING) {
                FileImpl fileImpl;
                HashMap<FileImpl, NativeFileItem> hashMap = new HashMap<FileImpl, NativeFileItem>();
                HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
                HashSet<CsmFile> hashSet2 = new HashSet<CsmFile>();
                for (NativeFileItem nativeFileItem : list) {
                    if (!projectImpl.acceptNativeItem(nativeFileItem) || (fileImpl = projectImpl.getFile(nativeFileItem.getFile())) == null) continue;
                    hashMap.put(fileImpl, nativeFileItem);
                    hashSet.addAll(projectImpl.getGraph().getTopParentFiles(fileImpl));
                    hashSet2.addAll(projectImpl.getGraph().getIncludedFiles(fileImpl));
                }
                for (CsmFile csmFile : hashSet2) {
                    if (hashSet.contains(csmFile)) continue;
                    DeepReparsingUtils.invalidateFileAndPreprocState(projectImpl, csmFile);
                }
                for (CsmFile csmFile : hashSet) {
                    if (csmFile.getProject() != projectImpl) continue;
                    fileImpl = (FileImpl)csmFile;
                    if (hashMap.containsKey(fileImpl)) {
                        NativeFileItem nativeFileItem = (NativeFileItem)hashMap.get(fileImpl);
                        DeepReparsingUtils.addToReparse((ProjectBase)projectImpl, nativeFileItem, fileImpl);
                        continue;
                    }
                    DeepReparsingUtils.addToReparse((ProjectBase)projectImpl, fileImpl, true);
                }
            } else {
                for (NativeFileItem nativeFileItem : list) {
                    FileImpl fileImpl = projectImpl.getFile(nativeFileItem.getFile());
                    if (fileImpl == null) continue;
                    DeepReparsingUtils.addToReparse((ProjectBase)projectImpl, nativeFileItem, fileImpl);
                }
            }
        }
        catch (Exception exception) {
            DiagnosticExceptoins.register(exception);
        }
        finally {
            ParserQueue.instance().onEndAddingProjectFiles(projectImpl);
        }
    }

    public static void reparseOnAdded(NativeFileItem nativeFileItem, ProjectBase projectBase) {
        if (!TraceFlags.USE_DEEP_REPARSING) {
            return;
        }
        String string = nativeFileItem.getFile().getName();
        HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
        block0: for (CsmFile object : projectBase.getSourceFiles()) {
            for (CsmInclude csmInclude : object.getIncludes()) {
                if (!((Object)csmInclude.getIncludeName()).toString().endsWith(string)) continue;
                hashSet.add(object);
                continue block0;
            }
        }
        if (hashSet.size() > 0) {
            HashSet hashSet2 = new HashSet();
            HashSet<CsmFile> hashSet3 = new HashSet<CsmFile>();
            for (CsmFile csmFile : hashSet) {
                hashSet2.addAll(projectBase.getGraph().getTopParentFiles(csmFile));
                hashSet3.addAll(projectBase.getGraph().getIncludedFiles(csmFile));
            }
            DeepReparsingUtils.addToReparse(projectBase, hashSet2, hashSet3, true);
        }
    }

    static void reparseOnAdded(List<NativeFileItem> list, ProjectBase projectBase) {
        if (!TraceFlags.USE_DEEP_REPARSING) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (NativeFileItem object2 : list) {
            hashSet.add(object2.getFile().getName());
        }
        HashSet hashSet2 = new HashSet();
        for (CsmFile csmFile : projectBase.getSourceFiles()) {
            DeepReparsingUtils.findResolved(hashSet, hashSet2, csmFile);
        }
        for (CsmFile csmFile : projectBase.getHeaderFiles()) {
            DeepReparsingUtils.findResolved(hashSet, hashSet2, csmFile);
        }
        if (hashSet2.size() > 0) {
            HashSet<CsmFile> hashSet3 = new HashSet<CsmFile>();
            HashSet<CsmFile> hashSet4 = new HashSet<CsmFile>();
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                CsmFile csmFile = (CsmFile)iterator.next();
                hashSet3.addAll(projectBase.getGraph().getTopParentFiles(csmFile));
                hashSet4.addAll(projectBase.getGraph().getIncludedFiles(csmFile));
            }
            DeepReparsingUtils.addToReparse(projectBase, hashSet3, hashSet4, true);
        }
    }

    private static void findResolved(Set<String> set, Set<CsmFile> set2, CsmFile csmFile) {
        for (CsmInclude csmInclude : csmFile.getIncludes()) {
            String string = ((Object)csmInclude.getIncludeName()).toString();
            int n = Math.max(string.lastIndexOf(92), string.lastIndexOf(47));
            if (n > 0) {
                string = string.substring(n);
            }
            if (!set.contains(string)) continue;
            set2.add(csmFile);
            break;
        }
    }

    public static void reparseOnRemoved(FileImpl fileImpl, ProjectBase projectBase) {
        if (!TraceFlags.USE_DEEP_REPARSING) {
            return;
        }
        Set<CsmFile> set = projectBase.getGraph().getTopParentFiles(fileImpl);
        Set<CsmFile> set2 = projectBase.getGraph().getCoherenceFiles(fileImpl);
        projectBase.getGraph().removeFile(fileImpl);
        set.remove(fileImpl);
        set2.remove(fileImpl);
        DeepReparsingUtils.addToReparse(projectBase, set, set2, false);
    }

    static void reparseOnRemoved(List<FileImpl> list, ProjectBase projectBase) {
        if (!TraceFlags.USE_DEEP_REPARSING) {
            return;
        }
        HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
        HashSet<CsmFile> hashSet2 = new HashSet<CsmFile>();
        for (FileImpl fileImpl : list) {
            hashSet.addAll(projectBase.getGraph().getTopParentFiles(fileImpl));
            hashSet2.addAll(projectBase.getGraph().getCoherenceFiles(fileImpl));
            projectBase.getGraph().removeFile(fileImpl);
            hashSet.remove(fileImpl);
            hashSet2.remove(fileImpl);
        }
        DeepReparsingUtils.addToReparse(projectBase, hashSet, hashSet2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToReparse(ProjectBase projectBase, Set<CsmFile> set, Set<CsmFile> set2, boolean bl) {
        for (CsmFile object : set2) {
            if (set.contains(object)) continue;
            DeepReparsingUtils.invalidateFileAndPreprocState(projectBase, object);
        }
        boolean bl2 = false;
        try {
            if (set.size() > 5) {
                ParserQueue.instance().onStartAddingProjectFiles(projectBase);
                bl2 = true;
            }
            for (CsmFile csmFile : set) {
                if (csmFile.getProject() != projectBase) continue;
                FileImpl fileImpl = (FileImpl)csmFile;
                DeepReparsingUtils.addToReparse(projectBase, fileImpl, bl);
            }
        }
        catch (Exception exception) {
            DiagnosticExceptoins.register(exception);
        }
        finally {
            if (bl2) {
                ParserQueue.instance().onEndAddingProjectFiles(projectBase);
            }
        }
    }

    private static void addToReparse(ProjectBase projectBase, FileImpl fileImpl, boolean bl) {
        fileImpl.stateChanged(bl);
        ParserQueue.instance().add(fileImpl, projectBase.getPreprocHandler(fileImpl.getBuffer().getFile()).getState(), ParserQueue.Position.HEAD);
        if (TraceFlags.USE_DEEP_REPARSING_TRACE) {
            System.out.println("Add file to reparse " + fileImpl.getAbsolutePath());
        }
    }

    private static void addToReparse(ProjectBase projectBase, NativeFileItem nativeFileItem, FileImpl fileImpl) {
        fileImpl.stateChanged(true);
        APTPreprocHandler.State state = projectBase.setChangedFileState(nativeFileItem);
        if (TraceFlags.USE_DEEP_REPARSING_TRACE) {
            System.out.println("Add file to reparse " + fileImpl.getAbsolutePath());
        }
        ParserQueue.instance().add(fileImpl, state, ParserQueue.Position.HEAD);
    }

    private static void invalidateFileAndPreprocState(ProjectBase projectBase, CsmFile csmFile) {
        if (csmFile.getProject() == projectBase) {
            FileImpl fileImpl = (FileImpl)csmFile;
            projectBase.invalidatePreprocState(fileImpl.getBuffer().getFile());
            fileImpl.stateChanged(false);
            if (TraceFlags.USE_DEEP_REPARSING_TRACE) {
                System.out.println("Invalidate file to reparse " + csmFile.getAbsolutePath());
            }
        }
    }
}

