/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import org.netbeans.modules.cnd.api.model.CsmIdentifiable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

public final class PersistentKey {
    private static final byte PROXY = 0;
    private static final byte UID = 1;
    private static final byte DECLARATION = 2;
    private Object key;
    private CsmProject project;
    private byte kind;

    private PersistentKey(CsmIdentifiable csmIdentifiable) {
        this.key = csmIdentifiable;
        this.kind = 0;
    }

    private PersistentKey(CsmUID csmUID) {
        this.key = csmUID;
        this.kind = 1;
    }

    private PersistentKey(CharSequence charSequence, CsmProject csmProject, byte by) {
        this.key = charSequence;
        this.project = csmProject;
        this.kind = by;
    }

    public static PersistentKey createKey(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        CharSequence charSequence = csmOffsetableDeclaration.getName();
        CharSequence charSequence2 = csmOffsetableDeclaration.getUniqueName();
        CsmProject csmProject = csmOffsetableDeclaration.getContainingFile().getProject();
        if (charSequence.length() > 0 && ((Object)charSequence2).toString().indexOf("::::") < 0 && csmProject != null) {
            return new PersistentKey(charSequence2, csmProject, 2);
        }
        return new PersistentKey(csmOffsetableDeclaration.getUID());
    }

    public CsmIdentifiable getObject() {
        switch (this.kind) {
            case 1: {
                return (CsmIdentifiable)((CsmUID)this.key).getObject();
            }
            case 0: {
                return (CsmIdentifiable)this.key;
            }
            case 2: {
                return this.project.findDeclaration((CharSequence)this.key);
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof PersistentKey) {
            PersistentKey persistentKey = (PersistentKey)object;
            if (this.kind != persistentKey.kind) {
                return false;
            }
            switch (this.kind) {
                case 0: 
                case 1: {
                    return this.key.equals(persistentKey.key);
                }
                case 2: {
                    if (this.project.equals(persistentKey.project)) {
                        return CharSequenceKey.Comparator.compare((CharSequence)this.key, (CharSequence)persistentKey.key) == 0;
                    }
                    return false;
                }
            }
        }
        return super.equals(object);
    }

    public int hashCode() {
        switch (this.kind) {
            case 0: 
            case 1: {
                return this.key.hashCode();
            }
            case 2: {
                return this.project.hashCode() ^ this.key.hashCode();
            }
        }
        return super.hashCode();
    }
}

