/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.util.WeakList;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressSupport {
    private static ProgressSupport instance = new ProgressSupport();
    private WeakList<CsmProgressListener> progressListeners = new WeakList();

    private ProgressSupport() {
    }

    static ProgressSupport instance() {
        return instance;
    }

    void addProgressListener(CsmProgressListener csmProgressListener) {
        this.progressListeners.add(csmProgressListener);
    }

    void removeProgressListener(CsmProgressListener csmProgressListener) {
        this.progressListeners.remove(csmProgressListener);
    }

    private Iterable<? extends CsmProgressListener> getProgressListeners() {
        Collection collection = Lookup.getDefault().lookupAll(CsmProgressListener.class);
        return collection.isEmpty() ? this.progressListeners : this.progressListeners.join(collection);
    }

    void fireFileInvalidated(FileImpl fileImpl) {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: fireFileInvalidated " + fileImpl.getAbsolutePath());
        }
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.fileInvalidated((CsmFile)fileImpl);
            }
            catch (Exception exception) {
                DiagnosticExceptoins.register(exception);
            }
        }
    }

    void fireFileParsingStarted(FileImpl fileImpl) {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: fireFileParsingStarted " + fileImpl.getAbsolutePath());
        }
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.fileParsingStarted((CsmFile)fileImpl);
            }
            catch (Exception exception) {
                DiagnosticExceptoins.register(exception);
            }
        }
    }

    void fireFileParsingFinished(FileImpl fileImpl) {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: fireFileParsingFinished " + fileImpl.getAbsolutePath());
        }
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.fileParsingFinished((CsmFile)fileImpl);
            }
            catch (Exception exception) {
                DiagnosticExceptoins.register(exception);
            }
        }
    }

    void fireProjectParsingStarted(ProjectBase projectBase) {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: fireProjectParsingStarted " + projectBase.getName());
        }
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.projectParsingStarted((CsmProject)projectBase);
            }
            catch (Exception exception) {
                DiagnosticExceptoins.register(exception);
            }
        }
    }

    void fireProjectParsingFinished(ProjectBase projectBase) {
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.projectParsingFinished((CsmProject)projectBase);
            }
            catch (Exception exception) {
                DiagnosticExceptoins.register(exception);
            }
        }
    }

    void fireProjectLoaded(ProjectBase projectBase) {
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.projectLoaded((CsmProject)projectBase);
            }
            catch (Exception exception) {
                DiagnosticExceptoins.register(exception);
            }
        }
    }

    void fireIdle() {
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.parserIdle();
            }
            catch (Exception exception) {
                DiagnosticExceptoins.register(exception);
            }
        }
    }

    void fireProjectFilesCounted(ProjectBase projectBase, int n) {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: fireProjectFilesCounted " + projectBase.getName() + ' ' + n);
        }
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.projectFilesCounted((CsmProject)projectBase, n);
            }
            catch (Exception exception) {
                DiagnosticExceptoins.register(exception);
            }
        }
    }
}

