/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUsingDirective;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.services.CsmUsingResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileElementsCollector {
    private final CsmFile destFile;
    private int startOffset;
    private int destOffset;
    private final CsmProject onlyInProject;
    private final ProjectBase project;
    private LinkedHashSet<CsmNamespace> directVisibleNamespaces = new LinkedHashSet();
    private LinkedHashSet<CsmUsingDirective> usingNamespaces = new LinkedHashSet();
    private LinkedHashSet<CsmNamespaceAlias> namespaceAliases = new LinkedHashSet();
    private LinkedHashSet<CsmUsingDeclaration> usingDeclarations = new LinkedHashSet();
    private Collection<CsmDeclaration> visibleUsedDeclarations = null;
    private Collection<CsmNamespace> visibleNamespaces = null;
    private boolean mapsGathered = false;

    public FileElementsCollector(CsmFile csmFile, int n, CsmProject csmProject) {
        this.destFile = csmFile;
        this.project = (ProjectBase)csmFile.getProject();
        this.destOffset = n;
        this.startOffset = 0;
        this.onlyInProject = csmProject;
    }

    public void incrementOffset(int n) {
        if (this.mapsGathered) {
            this.startOffset = this.destOffset;
        }
        this.destOffset = n;
        if (this.startOffset < this.destOffset) {
            this.mapsGathered = false;
            this.visibleUsedDeclarations = null;
            this.visibleNamespaces = null;
        } else if (this.startOffset > this.destOffset) {
            throw new IllegalArgumentException("Start offset " + this.startOffset + " > destination offset " + this.destOffset);
        }
    }

    public Collection<CsmUsingDeclaration> getUsingDeclarations() {
        this.initMaps();
        return Collections.unmodifiableCollection(this.usingDeclarations);
    }

    public Collection<CsmUsingDirective> getUsingDirectives() {
        this.initMaps();
        return Collections.unmodifiableCollection(this.usingNamespaces);
    }

    public Collection<CsmNamespaceAlias> getNamespaceAliases() {
        this.initMaps();
        return Collections.unmodifiableCollection(this.namespaceAliases);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmDeclaration> getUsedDeclarations() {
        this.initMaps();
        LinkedHashSet<CsmUsingDeclaration> linkedHashSet = this.usingDeclarations;
        synchronized (linkedHashSet) {
            if (this.visibleUsedDeclarations == null) {
                this.visibleUsedDeclarations = CsmUsingResolver.extractDeclarations(this.usingDeclarations);
            }
        }
        return Collections.unmodifiableCollection(this.visibleUsedDeclarations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmNamespace> getVisibleNamespaces() {
        this.initMaps();
        LinkedHashSet<CsmUsingDirective> linkedHashSet = this.usingNamespaces;
        synchronized (linkedHashSet) {
            if (this.visibleNamespaces == null) {
                this.visibleNamespaces = CsmUsingResolver.extractNamespaces(this.usingNamespaces);
                this.visibleNamespaces.addAll(this.directVisibleNamespaces);
            }
        }
        return Collections.unmodifiableCollection(this.visibleNamespaces);
    }

    private synchronized void initMaps() {
        if (this.mapsGathered) {
            return;
        }
        this.mapsGathered = true;
        this.gatherFileMaps(this.destFile);
    }

    protected void gatherFileMaps(CsmFile csmFile) {
        this.gatherFileMaps(new HashSet<CsmFile>(), csmFile, this.startOffset, this.destOffset);
    }

    protected void gatherFileMaps(Set<CsmFile> set, CsmFile csmFile, int n, int n2) {
        if (set.contains(csmFile)) {
            return;
        }
        set.add(csmFile);
        CsmSelect.CsmFilter csmFilter = CsmSelect.getDefault().getFilterBuilder().createOffsetFilter(n, n2);
        Iterator iterator = CsmSelect.getDefault().getIncludes(csmFile, csmFilter);
        while (iterator.hasNext()) {
            CsmFile csmFile2;
            CsmInclude csmInclude = (CsmInclude)iterator.next();
            if (csmInclude.getStartOffset() < n || csmInclude.getEndOffset() >= n2 || (csmFile2 = csmInclude.getIncludeFile()) == null || this.onlyInProject != null && csmFile2.getProject() != this.onlyInProject) continue;
            this.gatherFileMaps(set, csmFile2, 0, Integer.MAX_VALUE);
        }
        this.gatherDeclarationsMaps(CsmSelect.getDefault().getDeclarations(csmFile, csmFilter), n, n2);
    }

    protected void gatherDeclarationsMaps(Iterable iterable, int n, int n2) {
        this.gatherDeclarationsMaps(iterable.iterator(), n, n2);
    }

    protected void gatherDeclarationsMaps(Iterator iterator, int n, int n2) {
        while (iterator.hasNext()) {
            CsmOffsetable csmOffsetable = (CsmOffsetable)iterator.next();
            try {
                int n3 = csmOffsetable.getStartOffset();
                int n4 = csmOffsetable.getEndOffset();
                if (n4 < n) continue;
                if (n3 >= n2) break;
                if (CsmKindUtilities.isScopeElement((CsmObject)csmOffsetable)) {
                    this.gatherScopeElementMaps((CsmScopeElement)csmOffsetable, n4, n2);
                    continue;
                }
                if (!FileImpl.reportErrors) continue;
                System.err.println("Expected CsmScopeElement, got " + csmOffsetable);
            }
            catch (NullPointerException nullPointerException) {
                if (!FileImpl.reportErrors) continue;
                System.err.println("Unexpected NULL element in declarations collection");
                DiagnosticExceptoins.register(nullPointerException);
            }
        }
    }

    protected void gatherScopeElementMaps(CsmScopeElement csmScopeElement, int n, int n2) {
        CsmDeclaration.Kind kind;
        CsmDeclaration.Kind kind2 = kind = CsmKindUtilities.isDeclaration((CsmObject)csmScopeElement) ? ((CsmDeclaration)csmScopeElement).getKind() : null;
        if (kind == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
            CsmNamespaceDefinition csmNamespaceDefinition = (CsmNamespaceDefinition)csmScopeElement;
            if (csmNamespaceDefinition.getName().length() == 0) {
                this.directVisibleNamespaces.add(csmNamespaceDefinition.getNamespace());
            }
            if (n2 < n) {
                this.directVisibleNamespaces.remove(csmNamespaceDefinition.getNamespace());
                this.directVisibleNamespaces.add(csmNamespaceDefinition.getNamespace());
                this.gatherDeclarationsMaps(csmNamespaceDefinition.getDeclarations(), 0, n2);
            }
        } else if (kind == CsmDeclaration.Kind.NAMESPACE_ALIAS) {
            CsmNamespaceAlias csmNamespaceAlias = (CsmNamespaceAlias)csmScopeElement;
            this.namespaceAliases.add(csmNamespaceAlias);
        } else if (kind == CsmDeclaration.Kind.USING_DECLARATION) {
            CsmUsingDeclaration csmUsingDeclaration = (CsmUsingDeclaration)csmScopeElement;
            this.usingDeclarations.add(csmUsingDeclaration);
        } else if (kind == CsmDeclaration.Kind.USING_DIRECTIVE) {
            CsmUsingDirective csmUsingDirective = (CsmUsingDirective)csmScopeElement;
            this.usingNamespaces.add(csmUsingDirective);
        } else if (CsmKindUtilities.isDeclarationStatement((CsmObject)csmScopeElement)) {
            CsmDeclarationStatement csmDeclarationStatement = (CsmDeclarationStatement)csmScopeElement;
            if (csmDeclarationStatement.getStartOffset() < n2) {
                this.gatherDeclarationsMaps(((CsmDeclarationStatement)csmScopeElement).getDeclarators(), 0, n2);
            }
        } else if (CsmKindUtilities.isScope((CsmObject)csmScopeElement) && n2 < n) {
            this.gatherDeclarationsMaps(((CsmScope)csmScopeElement).getScopeElements(), 0, n2);
        }
    }
}

