/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUsingDirective;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.services.CsmUsingResolver;
import org.netbeans.modules.cnd.modelimpl.impl.services.FileElementsCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsingResolverImpl
extends CsmUsingResolver
implements CsmProgressListener {
    private Object lock = new Object();
    private Reference<SearchInfo> lastSearch = new SoftReference<Object>(null);
    private final boolean cache = true;

    public UsingResolverImpl() {
        CsmListeners.getDefault().addProgressListener((CsmProgressListener)this);
    }

    public Collection<CsmDeclaration> findUsedDeclarations(CsmFile csmFile, int n, CsmProject csmProject) {
        return this.getCollector(csmFile, n, csmProject).getUsedDeclarations();
    }

    public Collection<CsmDeclaration> findUsedDeclarations(CsmNamespace csmNamespace) {
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.USING_DECLARATION};
        CsmSelect csmSelect = CsmSelect.getDefault();
        ArrayList<CsmUsingDeclaration> arrayList = new ArrayList<CsmUsingDeclaration>();
        Iterator iterator = csmSelect.getDeclarations(csmNamespace, csmSelect.getFilterBuilder().createKindFilter(kindArray));
        while (iterator.hasNext()) {
            arrayList.add((CsmUsingDeclaration)iterator.next());
        }
        if (!csmNamespace.getProject().isArtificial() && !csmNamespace.isGlobal()) {
            for (CsmProject csmProject : csmNamespace.getProject().getLibraries()) {
                CsmNamespace csmNamespace2 = csmProject.findNamespace(csmNamespace.getQualifiedName());
                if (csmNamespace2 == null) continue;
                Iterator iterator2 = csmSelect.getDeclarations(csmNamespace2, csmSelect.getFilterBuilder().createKindFilter(kindArray));
                while (iterator2.hasNext()) {
                    arrayList.add((CsmUsingDeclaration)iterator2.next());
                }
            }
        }
        return UsingResolverImpl.extractDeclarations(arrayList);
    }

    public Collection<CsmNamespace> findVisibleNamespaces(CsmFile csmFile, int n, CsmProject csmProject) {
        LinkedHashSet<CsmNamespace> linkedHashSet = new LinkedHashSet<CsmNamespace>();
        LinkedList<CsmNamespace> linkedList = new LinkedList<CsmNamespace>(this.getCollector(csmFile, n, csmProject).getVisibleNamespaces());
        this.findVisibleNamespacesBfs(linkedHashSet, linkedList, csmProject);
        return linkedHashSet;
    }

    private void findVisibleNamespacesBfs(Set<CsmNamespace> set, Queue<CsmNamespace> queue, CsmProject csmProject) {
        while (!queue.isEmpty()) {
            CsmNamespace csmNamespace = queue.poll();
            for (CsmNamespace csmNamespace2 : this.findVisibleNamespaces(csmNamespace)) {
                if (set.contains(csmNamespace2) || queue.contains(csmNamespace2) || csmProject != null && csmProject != csmNamespace2.getProject()) continue;
                queue.add(csmNamespace2);
            }
            set.add(csmNamespace);
        }
    }

    public Collection<CsmUsingDirective> findUsingDirectives(CsmNamespace csmNamespace) {
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.USING_DIRECTIVE};
        CsmSelect csmSelect = CsmSelect.getDefault();
        ArrayList<CsmUsingDirective> arrayList = new ArrayList<CsmUsingDirective>();
        Iterator iterator = csmSelect.getDeclarations(csmNamespace, csmSelect.getFilterBuilder().createKindFilter(kindArray));
        while (iterator.hasNext()) {
            arrayList.add((CsmUsingDirective)iterator.next());
        }
        return arrayList;
    }

    public Collection<CsmNamespaceAlias> findNamespaceAliases(CsmFile csmFile, int n, CsmProject csmProject) {
        return this.getCollector(csmFile, n, csmProject).getNamespaceAliases();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileElementsCollector getCollector(CsmFile csmFile, int n, CsmProject csmProject) {
        Object object = this.lock;
        synchronized (object) {
            SearchInfo searchInfo = this.lastSearch.get();
            if (searchInfo == null || !searchInfo.valid(csmFile, n, csmProject)) {
                FileElementsCollector fileElementsCollector = new FileElementsCollector(csmFile, n, csmProject);
                searchInfo = new SearchInfo(csmFile, n, csmProject, fileElementsCollector);
                this.lastSearch = new SoftReference<SearchInfo>(searchInfo);
            } else {
                searchInfo.offset = n;
                searchInfo.collector.incrementOffset(n);
            }
            assert (searchInfo != null);
            assert (searchInfo.collector != null);
            return searchInfo.collector;
        }
    }

    public void projectParsingStarted(CsmProject csmProject) {
    }

    public void projectFilesCounted(CsmProject csmProject, int n) {
    }

    public void projectParsingFinished(CsmProject csmProject) {
    }

    public void projectParsingCancelled(CsmProject csmProject) {
    }

    public void fileInvalidated(CsmFile csmFile) {
    }

    public void fileParsingStarted(CsmFile csmFile) {
    }

    public void fileParsingFinished(CsmFile csmFile) {
        this.cleanCache();
    }

    public void projectLoaded(CsmProject csmProject) {
    }

    public void parserIdle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCache() {
        Object object = this.lock;
        synchronized (object) {
            this.lastSearch.clear();
        }
    }

    private static final class SearchInfo {
        public final CsmFile file;
        public int offset;
        public final FileElementsCollector collector;
        public final CsmProject onlyInProject;

        public SearchInfo(CsmFile csmFile, int n, CsmProject csmProject, FileElementsCollector fileElementsCollector) {
            this.file = csmFile;
            this.offset = n;
            this.collector = fileElementsCollector;
            this.onlyInProject = csmProject;
        }

        private boolean valid(CsmFile csmFile, int n, CsmProject csmProject) {
            return this.file.equals(csmFile) && this.offset <= n && this.onlyInProject == csmProject;
        }
    }
}

