/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.uid;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.cnd.api.model.CsmBuiltIn;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmTracer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.KeyBasedUID;
import org.netbeans.modules.cnd.modelimpl.uid.UIDManager;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIDUtilities {
    private static AtomicInteger UnnamedID = new AtomicInteger(0);

    private UIDUtilities() {
    }

    public static CsmUID<CsmProject> createProjectUID(ProjectBase projectBase) {
        return UIDManager.instance().getSharedUID(new ProjectUID(projectBase));
    }

    public static CsmUID<CsmFile> createFileUID(FileImpl fileImpl) {
        return UIDManager.instance().getSharedUID(new FileUID(fileImpl));
    }

    public static CsmUID<CsmNamespace> createNamespaceUID(CsmNamespace csmNamespace) {
        return UIDManager.instance().getSharedUID(new NamespaceUID(csmNamespace));
    }

    public static <T extends CsmOffsetableDeclaration> CsmUID<T> createDeclarationUID(T t) {
        assert (!(t instanceof CsmBuiltIn)) : "built-in have own UIDs";
        OffsetableDeclarationUIDBase offsetableDeclarationUIDBase = !UIDUtilities.namedDeclaration(t) ? UIDUtilities.handleUnnamedDeclaration(t) : (t instanceof CsmTypedef ? new TypedefUID<CsmTypedef>((CsmTypedef)t) : (t instanceof CsmClassifier ? new ClassifierUID<T>(t) : new DeclarationUID<T>(t)));
        return UIDManager.instance().getSharedUID(offsetableDeclarationUIDBase);
    }

    private static <T extends CsmOffsetableDeclaration> boolean namedDeclaration(T t) {
        assert (t != null);
        assert (t.getName() != null);
        return t.getName().length() > 0;
    }

    public static CsmUID<CsmMacro> createMacroUID(CsmMacro csmMacro) {
        return UIDManager.instance().getSharedUID(new MacroUID(csmMacro));
    }

    public static CsmUID<CsmInclude> createIncludeUID(CsmInclude csmInclude) {
        return UIDManager.instance().getSharedUID(new IncludeUID(csmInclude));
    }

    public static CsmUID<CsmClass> createUnresolvedClassUID(String string, CsmProject csmProject) {
        return UIDManager.instance().getSharedUID(new UnresolvedClassUID(string, csmProject));
    }

    public static CsmUID<CsmFile> createUnresolvedFileUID(CsmProject csmProject) {
        return UIDManager.instance().getSharedUID(new UnresolvedFileUID(csmProject));
    }

    public static CsmUID<CsmNamespace> createUnresolvedNamespaceUID(CsmProject csmProject) {
        return UIDManager.instance().getSharedUID(new UnresolvedNamespaceUID(csmProject));
    }

    public static CsmDeclaration.Kind getKind(CsmUID<CsmOffsetableDeclaration> csmUID) {
        if (csmUID instanceof KeyBasedUID) {
            Key key = ((KeyBasedUID)csmUID).getKey();
            return KeyUtilities.getKeyKind(key);
        }
        return null;
    }

    public static CharSequence getName(CsmUID<CsmOffsetableDeclaration> csmUID) {
        if (csmUID instanceof KeyBasedUID) {
            Key key = ((KeyBasedUID)csmUID).getKey();
            return KeyUtilities.getKeyName(key);
        }
        return null;
    }

    public static int getStartOffset(CsmUID<CsmOffsetableDeclaration> csmUID) {
        if (csmUID instanceof KeyBasedUID) {
            Key key = ((KeyBasedUID)csmUID).getKey();
            return KeyUtilities.getKeyStartOffset(key);
        }
        return -1;
    }

    public static int getEndOffset(CsmUID<CsmOffsetableDeclaration> csmUID) {
        if (csmUID instanceof KeyBasedUID) {
            Key key = ((KeyBasedUID)csmUID).getKey();
            return KeyUtilities.getKeyEndOffset(key);
        }
        return -1;
    }

    private static CsmUID handleUnnamedDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        if (TraceFlags.TRACE_UNNAMED_DECLARATIONS) {
            System.err.print("\n\ndeclaration with empty name '" + csmOffsetableDeclaration.getUniqueName() + "'");
            new CsmTracer().dumpModel((CsmDeclaration)csmOffsetableDeclaration);
        }
        if (csmOffsetableDeclaration instanceof CsmClassifier) {
            return new UnnamedClassifierUID<CsmOffsetableDeclaration>(csmOffsetableDeclaration, UnnamedID.incrementAndGet());
        }
        return new UnnamedOffsetableDeclarationUID<CsmOffsetableDeclaration>(csmOffsetableDeclaration, UnnamedID.incrementAndGet());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UnresolvedFileUID
    extends UnresolvedUIDBase<CsmFile> {
        public UnresolvedFileUID(CsmProject csmProject) {
            super(csmProject);
        }

        public UnresolvedFileUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        @Override
        public CsmFile getObject() {
            return this.getProject().getUnresolvedFile();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UnresolvedNamespaceUID
    extends UnresolvedUIDBase<CsmNamespace> {
        public UnresolvedNamespaceUID(CsmProject csmProject) {
            super(csmProject);
        }

        public UnresolvedNamespaceUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        @Override
        public CsmNamespace getObject() {
            return this.getProject().getUnresolvedNamespace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UnresolvedClassUID<T>
    extends UnresolvedUIDBase<CsmClass> {
        private String name;

        public UnresolvedClassUID(String string, CsmProject csmProject) {
            super(csmProject);
            this.name = string;
        }

        @Override
        public CsmClass getObject() {
            return this.getProject().getDummyForUnresolved(this.name);
        }

        public UnresolvedClassUID(DataInput dataInput) throws IOException {
            super(dataInput);
            this.name = PersistentUtils.readUTF(dataInput);
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            super.write(dataOutput);
            PersistentUtils.writeUTF(this.name, dataOutput);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class UnresolvedUIDBase<T>
    implements CsmUID<T>,
    SelfPersistent {
        private CsmUID<CsmProject> projectUID;

        public UnresolvedUIDBase(CsmProject csmProject) {
            this.projectUID = csmProject.getUID();
        }

        protected ProjectBase getProject() {
            return (ProjectBase)this.projectUID.getObject();
        }

        UnresolvedUIDBase(DataInput dataInput) throws IOException {
            this.projectUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        }

        public abstract T getObject();

        public void write(DataOutput dataOutput) throws IOException {
            UIDObjectFactory.getDefaultFactory().writeUID(this.projectUID, dataOutput);
        }

        protected String getToStringPrefix() {
            return "<UNRESOLVED UID>";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UnnamedOffsetableDeclarationUID<T extends CsmOffsetableDeclaration>
    extends OffsetableDeclarationUIDBase<T> {
        public UnnamedOffsetableDeclarationUID(T t, int n) {
            super(KeyUtilities.createUnnamedOffsetableDeclarationKey((OffsetableDeclarationBase)t, n));
        }

        UnnamedOffsetableDeclarationUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        @Override
        protected String getToStringPrefix() {
            return "<UNNAMED OFFS-DECL UID>";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UnnamedClassifierUID<T extends CsmOffsetableDeclaration>
    extends OffsetableDeclarationUIDBase<T> {
        public UnnamedClassifierUID(T t, int n) {
            super(KeyUtilities.createUnnamedOffsetableDeclarationKey((OffsetableDeclarationBase)t, n));
        }

        UnnamedClassifierUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        @Override
        protected String getToStringPrefix() {
            return "<UNNAMED CLASSIFIER UID>";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ClassifierUID<T extends CsmOffsetableDeclaration>
    extends OffsetableDeclarationUIDBase<T> {
        public ClassifierUID(T t) {
            super(t);
        }

        ClassifierUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        @Override
        protected String getToStringPrefix() {
            return "ClassifierUID";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DeclarationUID<T extends CsmOffsetableDeclaration>
    extends OffsetableDeclarationUIDBase<T> {
        public DeclarationUID(T t) {
            super(t);
        }

        DeclarationUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        @Override
        protected String getToStringPrefix() {
            return "DeclarationUID";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IncludeUID
    extends KeyBasedUID<CsmInclude> {
        public IncludeUID(CsmInclude csmInclude) {
            super(KeyUtilities.createIncludeKey(csmInclude));
        }

        IncludeUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MacroUID
    extends KeyBasedUID<CsmMacro> {
        public MacroUID(CsmMacro csmMacro) {
            super(KeyUtilities.createMacroKey(csmMacro));
        }

        MacroUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TypedefUID<T extends CsmTypedef>
    extends OffsetableDeclarationUIDBase<T> {
        public TypedefUID(T t) {
            super(t);
        }

        TypedefUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        @Override
        protected String getToStringPrefix() {
            return "TypedefUID";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class OffsetableDeclarationUIDBase<T extends CsmOffsetableDeclaration>
    extends KeyBasedUID<T> {
        public OffsetableDeclarationUIDBase(T t) {
            this(KeyUtilities.createOffsetableDeclarationKey((OffsetableDeclarationBase)t));
        }

        protected OffsetableDeclarationUIDBase(Key key) {
            super(key);
        }

        OffsetableDeclarationUIDBase(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        @Override
        public String toString() {
            String string = this.getToStringPrefix() + ":" + super.toString();
            return string;
        }

        protected String getToStringPrefix() {
            return "UID for OffsDecl";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class FileUID
    extends KeyBasedUID<CsmFile> {
        public FileUID(FileImpl fileImpl) {
            super(KeyUtilities.createFileKey(fileImpl));
        }

        FileUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class NamespaceUID
    extends KeyBasedUID<CsmNamespace> {
        public NamespaceUID(CsmNamespace csmNamespace) {
            super(KeyUtilities.createNamespaceKey(csmNamespace));
        }

        NamespaceUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ProjectUID
    extends KeyBasedUID<CsmProject> {
        public ProjectUID(ProjectBase projectBase) {
            super(KeyUtilities.createProjectKey(projectBase));
        }

        ProjectUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }
    }
}

