/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.parser.Token;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;

public class Keywords {
    public static final Context.Key<Keywords> keywordsKey = new Context.Key();
    private final Log log;
    private final Name.Table names;
    private final Token[] key;
    private int maxKey = 0;
    private Name[] tokenName = new Name[Token.values().length];

    public static Keywords instance(Context context) {
        Keywords instance = context.get(keywordsKey);
        if (instance == null) {
            instance = new Keywords(context);
        }
        return instance;
    }

    protected Keywords(Context context) {
        context.put(keywordsKey, this);
        this.log = Log.instance(context);
        this.names = Name.Table.instance(context);
        for (Token t : Token.values()) {
            if (t.name != null) {
                this.enterKeyword(t.name, t);
                continue;
            }
            this.tokenName[t.ordinal()] = null;
        }
        this.key = new Token[this.maxKey + 1];
        for (int i = 0; i <= this.maxKey; ++i) {
            this.key[i] = Token.IDENTIFIER;
        }
        for (Token t : Token.values()) {
            if (t.name == null) continue;
            this.key[this.tokenName[t.ordinal()].index] = t;
        }
    }

    public Token key(Name name) {
        return name.index > this.maxKey ? Token.IDENTIFIER : this.key[name.index];
    }

    public String token2string(Token token) {
        switch (token) {
            case IDENTIFIER: {
                return Log.getLocalizedString("token.identifier", new Object[0]);
            }
            case CHARLITERAL: {
                return Log.getLocalizedString("token.character", new Object[0]);
            }
            case STRINGLITERAL: {
                return Log.getLocalizedString("token.string", new Object[0]);
            }
            case INTLITERAL: {
                return Log.getLocalizedString("token.integer", new Object[0]);
            }
            case LONGLITERAL: {
                return Log.getLocalizedString("token.long-integer", new Object[0]);
            }
            case FLOATLITERAL: {
                return Log.getLocalizedString("token.float", new Object[0]);
            }
            case DOUBLELITERAL: {
                return Log.getLocalizedString("token.double", new Object[0]);
            }
            case ERROR: {
                return Log.getLocalizedString("token.bad-symbol", new Object[0]);
            }
            case EOF: {
                return Log.getLocalizedString("token.end-of-input", new Object[0]);
            }
            case DOT: 
            case COMMA: 
            case SEMI: 
            case LPAREN: 
            case RPAREN: 
            case LBRACKET: 
            case RBRACKET: 
            case LBRACE: 
            case RBRACE: {
                return "'" + token.name + "'";
            }
        }
        return token.name;
    }

    private void enterKeyword(String s, Token token) {
        Name n;
        this.tokenName[token.ordinal()] = n = this.names.fromString(s);
        if (n.index > this.maxKey) {
            this.maxKey = n.index;
        }
    }
}

