/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticFormatter;
import com.sun.tools.javac.util.JavacFileManager;
import com.sun.tools.javac.util.Messages;
import java.util.Locale;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCDiagnostic
implements Diagnostic<JavaFileObject> {
    private final Messages messages;
    private final DiagnosticType type;
    private final DiagnosticSource source;
    private final DiagnosticPosition position;
    private final int line;
    private final int column;
    private final String key;
    private final Object[] args;
    private boolean mandatory;
    private static DiagnosticFormatter defaultFormatter;
    private static final String messageBundleName = "com.sun.tools.javac.resources.compiler";

    public static JCDiagnostic fragment(String key, Object ... args) {
        return new JCDiagnostic(Messages.getDefaultMessages(), DiagnosticType.FRAGMENT, false, null, null, "compiler." + DiagnosticType.FRAGMENT.key + "." + key, args);
    }

    protected JCDiagnostic(Messages messages, DiagnosticType dt, boolean mandatory, DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
        int n;
        if (source == null && pos != null && pos.getPreferredPosition() != -1) {
            throw new IllegalArgumentException();
        }
        this.messages = messages;
        this.type = dt;
        this.mandatory = mandatory;
        this.source = source;
        this.position = pos;
        this.key = key;
        this.args = args;
        int n2 = n = pos == null ? -1 : pos.getPreferredPosition();
        if (n == -1 || source == null) {
            this.column = -1;
            this.line = -1;
        } else {
            this.line = source.getLineNumber(n);
            this.column = source.getColumnNumber(n);
        }
    }

    public DiagnosticType getType() {
        return this.type;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public JavaFileObject getSource() {
        if (this.source == null) {
            return null;
        }
        return this.source.getFile();
    }

    public String getSourceName() {
        JavaFileObject s = this.getSource();
        return s == null ? null : JavacFileManager.getJavacFileName(s);
    }

    public DiagnosticSource getDiagnosticSource() {
        return this.source;
    }

    protected int getIntStartPosition() {
        return this.position == null ? -1 : this.position.getStartPosition();
    }

    protected int getIntPosition() {
        return this.position == null ? -1 : this.position.getPreferredPosition();
    }

    protected int getIntEndPosition() {
        return this.position == null ? -1 : this.position.getEndPosition(this.source.getEndPosTable());
    }

    @Override
    public long getStartPosition() {
        return this.getIntStartPosition();
    }

    @Override
    public long getPosition() {
        return this.getIntPosition();
    }

    @Override
    public long getEndPosition() {
        return this.getIntEndPosition();
    }

    public JCTree getTree() {
        return this.position == null ? null : this.position.getTree();
    }

    @Override
    public long getLineNumber() {
        return this.line;
    }

    @Override
    public long getColumnNumber() {
        return this.column;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getPrefix() {
        return this.getPrefix(this.type);
    }

    public String getPrefix(DiagnosticType dt) {
        switch (dt) {
            case FRAGMENT: {
                return "";
            }
            case NOTE: {
                return this.getLocalizedString("compiler.note.note", new Object[0]);
            }
            case WARNING: {
                return this.getLocalizedString("compiler.warn.warning", new Object[0]);
            }
            case ERROR: {
                return this.getLocalizedString("compiler.err.error", new Object[0]);
            }
        }
        throw new AssertionError((Object)("Unknown diagnostic type: " + (Object)((Object)dt)));
    }

    public String toString() {
        if (defaultFormatter == null) {
            defaultFormatter = new DiagnosticFormatter();
        }
        return defaultFormatter.format(this);
    }

    private String getLocalizedString(String key, Object ... args) {
        String[] strings = new String[args.length];
        for (int i = 0; i < strings.length; ++i) {
            Object arg = args[i];
            strings[i] = arg == null ? null : (arg instanceof JCDiagnostic ? ((JCDiagnostic)arg).getMessage(null) : arg.toString());
        }
        return this.messages.getLocalizedString(key, strings);
    }

    @Override
    public Diagnostic.Kind getKind() {
        switch (this.type) {
            case NOTE: {
                return Diagnostic.Kind.NOTE;
            }
            case WARNING: {
                return this.mandatory ? Diagnostic.Kind.MANDATORY_WARNING : Diagnostic.Kind.WARNING;
            }
            case ERROR: {
                return Diagnostic.Kind.ERROR;
            }
        }
        return Diagnostic.Kind.OTHER;
    }

    @Override
    public String getCode() {
        return this.key;
    }

    @Override
    public String getMessage(Locale locale) {
        return this.getLocalizedString(this.key, this.args);
    }

    public boolean hasFixedPositions() {
        return this.position.getTree() == null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleDiagnosticPosition
    implements DiagnosticPosition {
        private final int pos;

        public SimpleDiagnosticPosition(int pos) {
            this.pos = pos;
        }

        @Override
        public JCTree getTree() {
            return null;
        }

        @Override
        public int getStartPosition() {
            return this.pos;
        }

        @Override
        public int getPreferredPosition() {
            return this.pos;
        }

        @Override
        public int getEndPosition(Map<JCTree, Integer> endPosTable) {
            return this.pos;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DiagnosticPosition {
        public JCTree getTree();

        public int getStartPosition();

        public int getPreferredPosition();

        public int getEndPosition(Map<JCTree, Integer> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DiagnosticType {
        FRAGMENT("misc"),
        NOTE("note"),
        WARNING("warn"),
        ERROR("err");

        final String key;

        private DiagnosticType(String key) {
            this.key = key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DiagnosticSource {
        public JavaFileObject getFile();

        public CharSequence getName();

        public int getLineNumber(int var1);

        public int getColumnNumber(int var1);

        public Map<JCTree, Integer> getEndPosTable();
    }

    public static class Factory {
        protected static final Context.Key<Factory> diagnosticFactoryKey = new Context.Key();
        final Messages messages;
        final String prefix;

        public static Factory instance(Context context) {
            Factory instance = context.get(diagnosticFactoryKey);
            if (instance == null) {
                instance = new Factory(context);
            }
            return instance;
        }

        protected Factory(Context context) {
            context.put(diagnosticFactoryKey, this);
            this.messages = Messages.instance(context);
            this.prefix = "compiler";
        }

        public Factory(Messages messages, String prefix) {
            this.messages = messages;
            this.prefix = prefix;
        }

        public JCDiagnostic error(DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return new JCDiagnostic(this.messages, DiagnosticType.ERROR, true, source, pos, this.qualify(DiagnosticType.ERROR, key), args);
        }

        public JCDiagnostic mandatoryWarning(DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return new JCDiagnostic(this.messages, DiagnosticType.WARNING, true, source, pos, this.qualify(DiagnosticType.WARNING, key), args);
        }

        public JCDiagnostic warning(DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return new JCDiagnostic(this.messages, DiagnosticType.WARNING, false, source, pos, this.qualify(DiagnosticType.WARNING, key), args);
        }

        public JCDiagnostic mandatoryNote(DiagnosticSource source, String key, Object ... args) {
            return new JCDiagnostic(this.messages, DiagnosticType.NOTE, true, source, null, this.qualify(DiagnosticType.NOTE, key), args);
        }

        public JCDiagnostic note(String key, Object ... args) {
            return this.note(null, null, key, args);
        }

        public JCDiagnostic note(DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return new JCDiagnostic(this.messages, DiagnosticType.NOTE, false, source, pos, this.qualify(DiagnosticType.NOTE, key), args);
        }

        public JCDiagnostic fragment(String key, Object ... args) {
            return new JCDiagnostic(this.messages, DiagnosticType.FRAGMENT, false, null, null, this.qualify(DiagnosticType.FRAGMENT, key), args);
        }

        protected String qualify(DiagnosticType t, String key) {
            return this.prefix + "." + t.key + "." + key;
        }
    }
}

