/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.model.xsltmap;

import java.util.Collection;
import org.netbeans.modules.soa.ui.axinodes.AxiomUtils;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xslt.tmap.model.xsltmap.TransformationDesc;
import org.netbeans.modules.xslt.tmap.model.xsltmap.TransformationUC;
import org.netbeans.modules.xslt.tmap.model.xsltmap.XsltMapModel;
import org.netbeans.modules.xslt.tmap.util.Util;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransformationDesc
implements TransformationDesc {
    private String partnerLink;
    private String roleName;
    private String portType;
    private String operation;
    private String messageType;
    private String file;
    private boolean transformJBI;
    private TransformationUC parentTUC;
    private XsltMapModel model;

    public AbstractTransformationDesc(XsltMapModel xsltMapModel, TransformationUC transformationUC) {
        this.parentTUC = transformationUC;
        this.model = xsltMapModel;
        this.parentTUC.addTransformationDesc(this);
    }

    @Override
    public XsltMapModel getXsltMapModel() {
        return this.model;
    }

    @Override
    public TransformationUC getParent() {
        return this.parentTUC;
    }

    @Override
    public XsltMapModel getModel() {
        return this.model;
    }

    @Override
    public String getPartnerLink() {
        return this.partnerLink;
    }

    @Override
    public void setPartnerLink(String string) {
        this.partnerLink = string;
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    @Override
    public void setRoleName(String string) {
        this.roleName = string;
    }

    @Override
    public String getPortType() {
        return this.portType;
    }

    @Override
    public void setPortType(String string) {
        this.portType = string;
    }

    @Override
    public void setOperation(String string) {
        this.operation = string;
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    @Override
    public String getMessageType() {
        return this.messageType;
    }

    @Override
    public void setMessageType(String string) {
        this.messageType = string;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public void setFile(String string) {
        this.file = string;
    }

    @Override
    public String getTransformJBI() {
        return Boolean.toString(this.transformJBI);
    }

    @Override
    public void setTransformJBI(boolean bl) {
        this.transformJBI = bl;
    }

    @Override
    public void setTransformJBI(String string) {
        this.transformJBI = "true".equals(string);
    }

    @Override
    public boolean isTransformJBI() {
        return this.transformJBI;
    }

    @Override
    public boolean isEqualInputFile(FileObject fileObject) {
        String string = this.getFile();
        return string != null && fileObject != null && string.equals(fileObject.getNameExt());
    }

    @Override
    public AXIModel getSourceAxiModel(FileObject fileObject) {
        assert (fileObject != null);
        AXIModel aXIModel = null;
        SchemaModel schemaModel = this.getSourceSchema(fileObject);
        if (schemaModel != null) {
            aXIModel = AXIModelFactory.getDefault().getModel(schemaModel);
        }
        return aXIModel;
    }

    @Override
    public SchemaModel getSourceSchema(FileObject fileObject) {
        if (this.isTransformJBI()) {
            return this.getJBISourceSchema();
        }
        assert (fileObject != null);
        SchemaModel schemaModel = null;
        Operation operation = Util.findWsdlOperation(fileObject, (TransformationDesc)this);
        if (operation != null) {
            Input input = operation.getInput();
            NamedComponentReference namedComponentReference = input.getMessage();
            if (namedComponentReference == null) {
                return null;
            }
            schemaModel = this.getMessageSchemaModel(operation.getModel(), (NamedComponentReference<Message>)namedComponentReference);
        }
        return schemaModel;
    }

    @Override
    public ReferenceableSchemaComponent getSourceType(FileObject fileObject) {
        if (this.isTransformJBI()) {
            return null;
        }
        assert (fileObject != null);
        ReferenceableSchemaComponent referenceableSchemaComponent = null;
        Operation operation = Util.findWsdlOperation(fileObject, (TransformationDesc)this);
        if (operation != null) {
            Input input = operation.getInput();
            NamedComponentReference namedComponentReference = input.getMessage();
            if (namedComponentReference == null) {
                return null;
            }
            referenceableSchemaComponent = this.getMessageSchemaType(operation.getModel(), (NamedComponentReference<Message>)namedComponentReference);
        }
        return referenceableSchemaComponent;
    }

    @Override
    public AXIComponent getPltSourceAXIType(FileObject fileObject) {
        assert (fileObject != null);
        return this.getAXIComponent(this.getSourceType(fileObject));
    }

    private SchemaModel getJBISourceSchema() {
        return null;
    }

    private SchemaModel getJBITargetSchema() {
        return null;
    }

    private SchemaModel getMessageSchemaModel(WSDLModel wSDLModel, NamedComponentReference<Message> namedComponentReference) {
        NamedComponentReference namedComponentReference2;
        if (wSDLModel == null || namedComponentReference == null) {
            return null;
        }
        SchemaModel schemaModel = null;
        Object var4_4 = null;
        Object var5_5 = null;
        Collection collection = ((Message)namedComponentReference.get()).getParts();
        Part part = null;
        if (collection != null && collection.size() > 0) {
            part = (Part)collection.iterator().next();
        }
        if ((namedComponentReference2 = part.getElement()) == null) {
            namedComponentReference2 = part.getType();
        }
        if (namedComponentReference2 != null && namedComponentReference2.get() != null) {
            schemaModel = ((ReferenceableSchemaComponent)namedComponentReference2.get()).getModel();
        }
        return schemaModel;
    }

    private ReferenceableSchemaComponent getMessageSchemaType(WSDLModel wSDLModel, NamedComponentReference<Message> namedComponentReference) {
        NamedComponentReference namedComponentReference2;
        if (wSDLModel == null || namedComponentReference == null) {
            return null;
        }
        ReferenceableSchemaComponent referenceableSchemaComponent = null;
        Object var4_4 = null;
        Object var5_5 = null;
        Collection collection = ((Message)namedComponentReference.get()).getParts();
        Part part = null;
        if (collection != null && collection.size() > 0) {
            part = (Part)collection.iterator().next();
        }
        if ((namedComponentReference2 = part.getElement()) == null) {
            namedComponentReference2 = part.getType();
        }
        referenceableSchemaComponent = (ReferenceableSchemaComponent)namedComponentReference2.get();
        return referenceableSchemaComponent;
    }

    private boolean equalMessageType(NamedComponentReference<? extends ReferenceableSchemaComponent> namedComponentReference) {
        String string = this.getMessageType();
        if (string == null || namedComponentReference == null) {
            return false;
        }
        return string.equals(namedComponentReference.getRefString());
    }

    @Override
    public ReferenceableSchemaComponent getTargetType(FileObject fileObject) {
        if (this.isTransformJBI()) {
            return null;
        }
        assert (fileObject != null);
        ReferenceableSchemaComponent referenceableSchemaComponent = null;
        Operation operation = Util.findWsdlOperation(fileObject, (TransformationDesc)this);
        if (operation != null) {
            Output output = operation.getOutput();
            NamedComponentReference namedComponentReference = output.getMessage();
            if (namedComponentReference == null) {
                return null;
            }
            referenceableSchemaComponent = this.getMessageSchemaType(operation.getModel(), (NamedComponentReference<Message>)namedComponentReference);
        }
        return referenceableSchemaComponent;
    }

    private AXIComponent getAXIComponent(ReferenceableSchemaComponent referenceableSchemaComponent) {
        if (referenceableSchemaComponent == null) {
            return null;
        }
        AXIComponent aXIComponent = null;
        AXIModel aXIModel = AXIModelFactory.getDefault().getModel(referenceableSchemaComponent.getModel());
        if (aXIModel != null) {
            aXIComponent = AxiomUtils.findGlobalComponent((AXIDocument)aXIModel.getRoot(), null, (SchemaComponent)referenceableSchemaComponent);
        }
        return aXIComponent;
    }

    @Override
    public AXIComponent getPltTargetAXIType(FileObject fileObject) {
        assert (fileObject != null);
        return this.getAXIComponent(this.getTargetType(fileObject));
    }

    @Override
    public SchemaModel getTargetSchema(FileObject fileObject) {
        Output output;
        if (this.isTransformJBI()) {
            return this.getJBITargetSchema();
        }
        assert (fileObject != null);
        SchemaModel schemaModel = null;
        Operation operation = Util.findWsdlOperation(fileObject, (TransformationDesc)this);
        if (operation != null && (output = operation.getOutput()) != null) {
            NamedComponentReference namedComponentReference = output.getMessage();
            if (namedComponentReference == null) {
                return null;
            }
            schemaModel = this.getMessageSchemaModel(operation.getModel(), (NamedComponentReference<Message>)namedComponentReference);
        }
        return schemaModel;
    }

    @Override
    public AXIModel getTargetAxiModel(FileObject fileObject) {
        assert (fileObject != null);
        AXIModel aXIModel = null;
        SchemaModel schemaModel = this.getTargetSchema(fileObject);
        if (schemaModel != null) {
            aXIModel = AXIModelFactory.getDefault().getModel(schemaModel);
        }
        return aXIModel;
    }
}

