/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.navigator;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.netbeans.modules.xslt.tmap.TMapDataObject;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.navigator.TMapLogicalPanel;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.awt.UndoRedo;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;

public class TMapLogicalNavigatorPanel
implements NavigatorPanel {
    private AtomicReference<UndoRedo.Manager> myUndoRedoRef = new AtomicReference();
    private JComponent myComponent;
    private Lookup.Result<DataObject> myContext;
    private TMapModel myModel;
    private static String NAV_PANEL_NAME = NbBundle.getMessage(TMapLogicalNavigatorPanel.class, (String)"LBL_TMAP_LOGICAL_VIEW");
    private final LookupListener mySelectionListener = new LookupListener(){

        public void resultChanged(LookupEvent lookupEvent) {
            TMapLogicalNavigatorPanel.this.setNewContent();
        }
    };

    public static String getUName() {
        return NAV_PANEL_NAME;
    }

    public String getDisplayName() {
        return NAV_PANEL_NAME;
    }

    public String getDisplayHint() {
        return NbBundle.getMessage(TMapLogicalNavigatorPanel.class, (String)"LBL_TMAP_LOGICAL_VIEW_TOOLTIP");
    }

    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.myComponent = new TMapLogicalPanel();
        }
        return this.myComponent;
    }

    public void panelActivated(Lookup lookup) {
        this.myContext = lookup.lookup(new Lookup.Template(DataObject.class));
        assert (this.myContext != null);
        TMapDataObject tMapDataObject = this.getTMapDataObject();
        this.myContext.addLookupListener(this.mySelectionListener);
        this.mySelectionListener.resultChanged(null);
    }

    public void panelDeactivated() {
        if (this.myContext != null) {
            this.myContext.removeLookupListener(this.mySelectionListener);
            this.myContext = null;
        }
    }

    public Lookup getLookup() {
        return null;
    }

    private TMapDataObject getTMapDataObject() {
        DataObject dataObject;
        TMapDataObject tMapDataObject = null;
        Collection collection = this.myContext.allInstances();
        if (collection != null && collection.size() == 1 && (dataObject = (DataObject)collection.iterator().next()).getClass() == TMapDataObject.class) {
            tMapDataObject = (TMapDataObject)dataObject;
        }
        return tMapDataObject;
    }

    private TMapModel getModel(DataObject dataObject) {
        assert (dataObject != null);
        Lookup lookup = dataObject.getLookup();
        return lookup != null ? (TMapModel)lookup.lookup(TMapModel.class) : null;
    }

    private void setNewContent() {
        TMapDataObject tMapDataObject = this.getTMapDataObject();
        TMapModel tMapModel = null;
        if (tMapDataObject != null) {
            tMapModel = this.getModel((DataObject)tMapDataObject);
        }
        if (tMapModel != null && this.myModel != tMapModel) {
            this.myModel = tMapModel;
            ((TMapLogicalPanel)this.getComponent()).navigate(tMapDataObject.getLookup(), this.myModel);
        }
    }
}

