/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.netbeans.modules.xslt.tmap.model.api.TMapComponent;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.navigator.TMapNavigatorController;
import org.netbeans.modules.xslt.tmap.nodes.TMapComponentNode;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class LogicalTreeHandler
implements PropertyChangeListener,
ComponentListener {
    private static final long serialVersionUID = 1L;
    private TMapModel myModel;
    private Lookup myContextLookup;
    private BeanTreeView myBeanTreeView;
    private ExplorerManager myExplorerManager;

    public LogicalTreeHandler(ExplorerManager explorerManager, TMapModel tMapModel, Lookup lookup) {
        this.myModel = tMapModel;
        this.myExplorerManager = explorerManager;
        this.myExplorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.myContextLookup = lookup;
        this.myBeanTreeView = this.createBeanTreeView();
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        this.myModel.addComponentListener(this);
    }

    private BeanTreeView createBeanTreeView() {
        BeanTreeView beanTreeView = new BeanTreeView();
        beanTreeView.setRootVisible(true);
        beanTreeView.setEnabled(true);
        beanTreeView.setSelectionMode(1);
        beanTreeView.setDefaultActionAllowed(true);
        return beanTreeView;
    }

    public void removeListeners() {
        if (this.myExplorerManager != null) {
            this.myExplorerManager.removePropertyChangeListener((PropertyChangeListener)this);
        }
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        if (this.myModel != null) {
            this.myModel.removeComponentListener(this);
        }
        this.myModel = null;
        this.myExplorerManager = null;
    }

    public BeanTreeView getBeanTreeView() {
        return this.myBeanTreeView;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        TopComponent topComponent = TMapNavigatorController.getNavigatorTC();
        if (string.equals("activated")) {
            if (TopComponent.getRegistry().getActivated() == topComponent) {
                // empty if block
            }
        } else {
            if (string.equals("activatedNodes")) {
                if (TopComponent.getRegistry().getActivated() != topComponent) {
                    this.doTreeNodeSelectionByActiveNode();
                }
                return;
            }
            if (string.equals("selectedNodes")) {
                if (topComponent == null) {
                    return;
                }
                topComponent.setActivatedNodes((Node[])propertyChangeEvent.getNewValue());
            } else if (string.equals("rootContext")) {
                this.doTreeNodeSelectionByActiveNode();
            } else if (string.equals("opened")) {
                TMapNavigatorController.activateLogicalPanel();
            } else if (string.equals("currentNodes")) {
                TMapNavigatorController.activateLogicalPanel();
            }
        }
    }

    public void valueChanged(ComponentEvent componentEvent) {
    }

    public void childrenAdded(ComponentEvent componentEvent) {
    }

    public void childrenDeleted(ComponentEvent componentEvent) {
    }

    protected void doTreeNodeSelectionByActiveNode() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray == null || nodeArray.length == 0) {
            return;
        }
        for (Node node : nodeArray) {
            if (!(node instanceof TMapComponentNode)) continue;
            this.doTreeNodeSelection((TMapComponentNode)node);
            break;
        }
    }

    private void doTreeNodeSelection(TMapComponentNode tMapComponentNode) {
        try {
            Node node = this.findTMapNode(this.myExplorerManager.getRootContext(), tMapComponentNode.getComponentRef());
            if (node == null) {
                return;
            }
            this.myExplorerManager.setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify((Throwable)propertyVetoException);
        }
    }

    private Node findTMapNode(Node node, TMapComponent tMapComponent) {
        if (node == null || tMapComponent == null || !(node instanceof TMapComponentNode)) {
            return null;
        }
        if (tMapComponent.equals(((TMapComponentNode)node).getComponentRef())) {
            return (TMapComponentNode)node;
        }
        Children children = node.getChildren();
        if (children == null || children.equals(Children.LEAF)) {
            return null;
        }
        Node[] nodeArray = children.getNodes();
        if (nodeArray == null || nodeArray.length < 1) {
            return null;
        }
        for (Node node2 : nodeArray) {
            Node node3 = this.findTMapNode(node2, tMapComponent);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }
}

