/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.util;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.model.api.TransformMap;
import org.netbeans.modules.xslt.tmap.model.api.events.VetoException;
import org.netbeans.modules.xslt.tmap.model.impl.InvalidNamespaceException;
import org.netbeans.modules.xslt.tmap.nodes.properties.ResolverUtility;
import org.netbeans.modules.xslt.tmap.util.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class ImportRegistrationHelper {
    private final TMapModel myModel;
    private static final Logger LOGGER = Logger.getLogger(ImportRegistrationHelper.class.getName());

    public ImportRegistrationHelper(TMapModel tMapModel) {
        this.myModel = tMapModel;
    }

    public TMapModel getModel() {
        return this.myModel;
    }

    public void addImport(WSDLModel wSDLModel) {
        if (wSDLModel == null) {
            return;
        }
        this.addImport(this.createImport(wSDLModel));
        Definitions definitions = wSDLModel.getDefinitions();
        if (definitions == null) {
            return;
        }
        Collection collection = definitions.getImports();
        if (collection == null) {
            return;
        }
        for (Import import_ : collection) {
            try {
                WSDLModel wSDLModel2 = import_.getImportedWSDLModel();
                if (wSDLModel2 == null || wSDLModel2.equals(import_.getModel()) || ResolverUtility.isModelImported((Model)wSDLModel2, this.myModel)) continue;
                this.addImport(wSDLModel2);
            }
            catch (CatalogModelException catalogModelException) {
                LOGGER.log(Level.INFO, "occured CatalogModelException", catalogModelException);
            }
        }
    }

    public void addImport(org.netbeans.modules.xslt.tmap.model.api.Import import_) {
        if (import_ == null) {
            return;
        }
        TransformMap transformMap = this.myModel.getTransformMap();
        if (transformMap == null) {
            return;
        }
        if (!this.isImported(import_)) {
            transformMap.addImport(import_);
        }
    }

    public org.netbeans.modules.xslt.tmap.model.api.Import createImport(WSDLModel wSDLModel) {
        FileObject fileObject = SoaUtil.getFileObjectByModel((Model)wSDLModel);
        if (fileObject != null) {
            return this.createImport(fileObject);
        }
        return null;
    }

    public org.netbeans.modules.xslt.tmap.model.api.Import createImport(FileObject fileObject) {
        if (fileObject != null) {
            return this.createImport(Util.getNewModelNamespace(fileObject), Util.getNewModelLocation((Model)this.myModel, fileObject));
        }
        return null;
    }

    public org.netbeans.modules.xslt.tmap.model.api.Import createImport(String string, String string2) {
        Object object;
        TransformMap transformMap = this.myModel.getTransformMap();
        if (transformMap != null) {
            try {
                object = transformMap.getNamespaceContext();
                object.addNamespace(string);
            }
            catch (InvalidNamespaceException invalidNamespaceException) {
                LOGGER.log(Level.SEVERE, null, invalidNamespaceException);
            }
        }
        object = this.myModel.getFactory().createImport();
        if (string != null) {
            try {
                object.setNamespace(string);
            }
            catch (VetoException vetoException) {
                LOGGER.log(Level.INFO, null, vetoException);
            }
        }
        if (string2 != null) {
            try {
                string2 = ResolverUtility.encodeLocation(string2);
                object.setLocation(string2);
            }
            catch (VetoException vetoException) {
                ErrorManager.getDefault().notify(1, (Throwable)vetoException);
            }
        }
        return object;
    }

    private boolean isImported(org.netbeans.modules.xslt.tmap.model.api.Import import_) {
        TransformMap transformMap = this.myModel.getTransformMap();
        if (transformMap == null) {
            return false;
        }
        List<org.netbeans.modules.xslt.tmap.model.api.Import> list = transformMap.getImports();
        if (list == null) {
            return false;
        }
        String string = import_.getNamespace();
        String string2 = ResolverUtility.decodeLocation(import_.getLocation());
        for (org.netbeans.modules.xslt.tmap.model.api.Import import_2 : list) {
            if (string != null && !string.equals(import_2.getNamespace()) || string2 != null && !string2.equals(ResolverUtility.decodeLocation(import_2.getLocation()))) continue;
            return true;
        }
        return false;
    }
}

