/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.e2e.schema;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.e2e.api.schema.Element;
import org.netbeans.modules.e2e.api.schema.RepeatableSchemaConstruct;
import org.netbeans.modules.e2e.api.schema.SchemaConstruct;
import org.netbeans.modules.e2e.api.schema.SchemaException;
import org.netbeans.modules.e2e.api.schema.SchemaHolder;
import org.netbeans.modules.e2e.api.schema.Type;
import org.netbeans.modules.e2e.api.wsdl.wsdl2java.WSDL2Java;
import org.netbeans.modules.e2e.schema.SchemaConstants;
import org.netbeans.modules.e2e.schema.SchemaHolderImpl;
import org.netbeans.modules.e2e.wsdl.WSDLConstants;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaParser
extends DefaultHandler {
    private Stack<String> state = new Stack();
    private Stack<SchemaConstruct> schemaConstructs = new Stack();
    private SchemaHolder schemaHolder;
    private String targetNamespace;
    private boolean elementFormDefault = false;
    private Stack<String> targetNamespaceStack = new Stack();
    private Map<String, String> prefixMapping = new HashMap<String, String>();
    private Locator locator;
    private String schemaURI;
    private static final String SCHEMA = "schema";
    private static final String ELEMENT = "element";
    private static final String COMPLEX_TYPE = "complexType";
    private static final String COMPLEX_CONTENT = "complexContent";
    private static final String EXTENSION = "extension";
    private static final String SEQUENCE = "sequence";
    private static final String SIMPLE_TYPE = "simpleType";
    private static final String RESTRICTION = "restriction";
    private static final String ENUMERATION = "enumeration";
    private boolean parseWSDLTags = true;
    private List<WSDL2Java.ValidationResult> validationResults;

    public SchemaParser() {
        this.schemaHolder = new SchemaHolderImpl();
        this.validationResults = new ArrayList<WSDL2Java.ValidationResult>();
        this.addPrimitiveTypes();
    }

    public SchemaParser(boolean bl) {
        this();
        this.parseWSDLTags = bl;
        this.state.push(WSDLConstants.TYPES.getLocalPart());
    }

    private void addPrimitiveTypes() {
        Type type = new Type(SchemaConstants.TYPE_STRING, 3);
        type.setJavaTypeName("String");
        this.schemaHolder.addSchemaType(type);
        Type type2 = new Type(SchemaConstants.TYPE_INT, 3);
        type2.setJavaTypeName("int");
        this.schemaHolder.addSchemaType(type2);
        Type type3 = new Type(SchemaConstants.TYPE_SHORT, 3);
        type3.setJavaTypeName("short");
        this.schemaHolder.addSchemaType(type3);
        Type type4 = new Type(SchemaConstants.TYPE_LONG, 3);
        type4.setJavaTypeName("long");
        this.schemaHolder.addSchemaType(type4);
        Type type5 = new Type(SchemaConstants.TYPE_BOOLEAN, 3);
        type5.setJavaTypeName("boolean");
        this.schemaHolder.addSchemaType(type5);
        Type type6 = new Type(SchemaConstants.TYPE_FLOAT, 3);
        type6.setJavaTypeName("float");
        this.schemaHolder.addSchemaType(type6);
        Type type7 = new Type(SchemaConstants.TYPE_DOUBLE, 3);
        type7.setJavaTypeName("double");
        this.schemaHolder.addSchemaType(type7);
        Type type8 = new Type(SchemaConstants.TYPE_BYTE, 3);
        type8.setJavaTypeName("byte");
        this.schemaHolder.addSchemaType(type8);
        Type type9 = new Type(SchemaConstants.TYPE_BASE64_BINARY, 3);
        type9.setJavaTypeName("byte[]");
        this.schemaHolder.addSchemaType(type9);
        Type type10 = new Type(SchemaConstants.TYPE_HEX_BINARY, 3);
        type10.setJavaTypeName("byte[]");
        this.schemaHolder.addSchemaType(type10);
        Type type11 = new Type(SchemaConstants.TYPE_QNAME, 3);
        type11.setJavaTypeName("javax.xml.namespace.QName");
        this.schemaHolder.addSchemaType(type11);
    }

    public SchemaHolder getSchemaHolder() {
        return this.schemaHolder;
    }

    public List<WSDL2Java.ValidationResult> getValidationResults() {
        return Collections.unmodifiableList(this.validationResults);
    }

    public void parse(InputStream inputStream) throws SchemaException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() instanceof SchemaException) {
                throw new SchemaException(sAXException.getCause());
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void parseLocation(String string, String string2) throws SchemaException {
        this.targetNamespace = string2;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            this.schemaURI = string;
            sAXParser.parse(string, (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() instanceof SchemaException) {
                this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "Error during parsing of the schema file."));
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "Schema " + string + " cannot be located."));
        }
        catch (ConnectException connectException) {
            this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "Connection problem. Cannot download schema from " + string + " location."));
        }
        catch (IOException iOException) {
            this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "Connection problem. Cannot download schema from " + string + " location."));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, illegalArgumentException.getLocalizedMessage()));
        }
        catch (Exception exception) {
            this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, exception.getLocalizedMessage()));
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.prefixMapping.put(string, string2);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        QName qName = new QName(string, string2);
        if (string.equals("http://schemas.xmlsoap.org/wsdl/")) {
            if (WSDLConstants.DEFINITIONS.getLocalPart().equals(string2)) {
                this.state.push(WSDLConstants.DEFINITIONS.getLocalPart());
                return;
            }
            if (WSDLConstants.TYPES.getLocalPart().equals(string2)) {
                this.state.push(WSDLConstants.TYPES.getLocalPart());
                return;
            }
        }
        if (string.equals(SchemaConstants.SCHEMA_URI) && this.state.size() > 0) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            if (string2.equals("import")) {
                object5 = attributes.getValue("namespace");
                object4 = attributes.getValue("schemaLocation");
                if (object4 == null) {
                    return;
                }
                object3 = new SchemaParser(false);
                try {
                    object2 = new URI(this.schemaURI);
                    object = ((URI)object2).resolve((String)object4);
                    ((SchemaParser)object3).parseLocation(object.toString(), (String)object5);
                }
                catch (SchemaException schemaException) {
                    schemaException.printStackTrace();
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRISyntaxException.printStackTrace();
                }
                this.schemaHolder.importSchema(((SchemaParser)object3).getSchemaHolder());
                this.validationResults.addAll(((SchemaParser)object3).getValidationResults());
            }
            if (string2.equalsIgnoreCase(SchemaConstants.SCHEMA.getLocalPart())) {
                this.state.push(SCHEMA);
                this.targetNamespace = this.targetNamespaceStack.push(attributes.getValue("targetNamespace") != null ? attributes.getValue("targetNamespace") : this.targetNamespace);
                if ("qualified".equals(attributes.getValue("elementFormDefault"))) {
                    this.elementFormDefault = true;
                }
                return;
            }
            if (string2.equalsIgnoreCase(SchemaConstants.ELEMENT.getLocalPart())) {
                this.state.push(ELEMENT);
                object5 = null;
                if (attributes.getValue("ref") != null) {
                    this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "Reference in element is not supported by this version of stub compiler."));
                } else {
                    object5 = this.schemaConstructs.isEmpty() || this.elementFormDefault ? new QName(this.targetNamespace, attributes.getValue("name")) : new QName("", attributes.getValue("name"));
                }
                object4 = new Element((QName)object5);
                if (this.schemaConstructs.isEmpty() || this.elementFormDefault) {
                    ((SchemaConstruct)object4).setTargetNamespace(this.targetNamespace);
                }
                this.parseSchemaConstruct((RepeatableSchemaConstruct)object4, attributes);
                object3 = attributes.getValue("nillable");
                if (object3 != null && "true".equals(object3)) {
                    ((Element)object4).setNillable(true);
                }
                if ((object2 = attributes.getValue("type")) != null) {
                    object = this.parseQName((String)object2);
                    Type type = this.schemaHolder.getSchemaType((QName)object);
                    if (type == null) {
                        type = new Type((QName)object);
                        this.schemaHolder.addSchemaType(type);
                    }
                    ((Element)object4).setType(type);
                }
                if (!this.schemaConstructs.isEmpty()) {
                    object = this.schemaConstructs.peek().getConstructType();
                    if (SchemaConstruct.ConstructType.TYPE.equals((Object)this.schemaConstructs.peek().getConstructType())) {
                        ((Type)this.schemaConstructs.peek()).addSubconstruct((SchemaConstruct)object4);
                    }
                }
                this.schemaHolder.addSchemaElement((Element)object4);
                this.schemaConstructs.push((SchemaConstruct)object4);
                return;
            }
            if (string2.equalsIgnoreCase(SchemaConstants.COMPLEX_TYPE.getLocalPart())) {
                this.state.push(COMPLEX_TYPE);
                object5 = attributes.getValue("name");
                object4 = null;
                object3 = null;
                if (object5 != null) {
                    object4 = new QName(this.targetNamespace, (String)object5);
                    object3 = this.schemaHolder.getSchemaType((QName)object4);
                    if (object3 == null) {
                        object3 = new Type((QName)object4);
                        this.schemaHolder.addSchemaType((Type)object3);
                    } else {
                        ((Type)object3).setFlavor((short)1);
                    }
                }
                if (object3 == null) {
                    object3 = new Type();
                    ((Type)object3).setFlavor((short)1);
                }
                if (!this.schemaConstructs.isEmpty() && SchemaConstruct.ConstructType.ELEMENT.equals((Object)this.schemaConstructs.peek().getConstructType())) {
                    object2 = (Element)this.schemaConstructs.peek();
                    ((Element)object2).setType((Type)object3);
                } else {
                    this.schemaHolder.addSchemaType((Type)object3);
                }
                this.schemaConstructs.push((SchemaConstruct)object3);
                return;
            }
            if (string2.equalsIgnoreCase(SchemaConstants.SEQUENCE.getLocalPart())) {
                this.state.push(SEQUENCE);
                object5 = this.schemaConstructs.peek();
                if (object5 instanceof Type) {
                    object4 = (Type)object5;
                    ((Type)object4).setFlavor((short)1);
                }
                return;
            }
            if (string2.equalsIgnoreCase(SchemaConstants.COMPLEX_CONTENT.getLocalPart()) && this.state.peek().equals(COMPLEX_TYPE)) {
                this.state.push(COMPLEX_CONTENT);
            }
            if (string2.equalsIgnoreCase(SchemaConstants.EXTENSION.getLocalPart()) && this.state.peek().equals(COMPLEX_CONTENT)) {
                this.state.push(EXTENSION);
                object5 = attributes.getValue("base");
                object4 = null;
                object3 = null;
                if (object5 != null) {
                    object4 = this.parseQName((String)object5);
                    object3 = this.schemaHolder.getSchemaType((QName)object4);
                    if (object3 == null) {
                        object3 = new Type((QName)object4);
                        this.schemaHolder.addSchemaType((Type)object3);
                    }
                    object2 = this.schemaConstructs.peek();
                    ((SchemaConstruct)object2).setParent((SchemaConstruct)object3);
                }
                return;
            }
            if (string2.equals(SchemaConstants.SIMPLE_TYPE.getLocalPart())) {
                object5 = attributes.getValue("name");
                if (object5 == null) {
                    object5 = "";
                }
                this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "Simple type is not supported by JSR-172 - " + (String)object5));
            }
            if (string2.equalsIgnoreCase(SchemaConstants.ALL.getLocalPart()) && this.state.peek().equals(COMPLEX_TYPE)) {
                this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "'all' element in complex-type element is not supported by JSR-172."));
            }
            if (string2.equalsIgnoreCase(SchemaConstants.CHOICE.getLocalPart()) && this.state.peek().equals(COMPLEX_TYPE)) {
                this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "'choice' element in complex-type element is not supported by JSR-172."));
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string.equals("http://schemas.xmlsoap.org/wsdl/")) {
            if (WSDLConstants.DEFINITIONS.getLocalPart().equals(string2)) {
                this.state.pop();
                return;
            }
            if (WSDLConstants.TYPES.getLocalPart().equals(string2)) {
                this.state.pop();
                return;
            }
        }
        if (string.equalsIgnoreCase(SchemaConstants.SCHEMA_URI) && this.state.size() > 0) {
            if (SchemaConstants.ELEMENT.getLocalPart().equals(string2)) {
                this.schemaConstructs.pop();
                if (!ELEMENT.equals(this.state.pop())) {
                    throw new SAXException("", new SchemaException("Invalid end tag for 'element'."));
                }
                if (!SCHEMA.equals(this.state.peek()) && !SEQUENCE.equals(this.state.peek())) {
                    throw new SAXException("", new SchemaException("Invalid super tag for 'element'."));
                }
            }
            if (SchemaConstants.COMPLEX_TYPE.getLocalPart().equals(string2)) {
                this.schemaConstructs.pop();
                if (!COMPLEX_TYPE.equals(this.state.pop())) {
                    throw new SAXException("", new SchemaException("Invalid end tag for 'complexType'."));
                }
            }
            if (SchemaConstants.SEQUENCE.getLocalPart().equals(string2)) {
                if (!SEQUENCE.equals(this.state.pop())) {
                    throw new SAXException("", new SchemaException("Invalid end tag for 'sequence'."));
                }
                if (!COMPLEX_TYPE.equals(this.state.peek()) && !EXTENSION.equals(this.state.peek())) {
                    throw new SAXException("", new SchemaException("Invalid 'sequence' tag position."));
                }
            }
            if (SchemaConstants.EXTENSION.getLocalPart().equals(string2)) {
                this.state.pop();
            }
            if (SchemaConstants.COMPLEX_CONTENT.getLocalPart().equals(string2)) {
                this.state.pop();
            }
        }
    }

    private void parseSchemaConstruct(RepeatableSchemaConstruct repeatableSchemaConstruct, Attributes attributes) {
        String string = attributes.getValue("minOccurs");
        if (string != null) {
            int n = Integer.parseInt(string);
            repeatableSchemaConstruct.setMinOccurs(n);
        } else {
            repeatableSchemaConstruct.setMinOccurs(1);
        }
        String string2 = attributes.getValue("maxOccurs");
        if (string2 != null) {
            if ("unbounded".equals(string2)) {
                repeatableSchemaConstruct.setMaxOccurs(Integer.MAX_VALUE);
            } else {
                int n = Integer.parseInt(string2);
                repeatableSchemaConstruct.setMaxOccurs(n);
            }
        } else {
            repeatableSchemaConstruct.setMaxOccurs(1);
        }
    }

    private QName parseQName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = this.prefixMapping.get(string2);
            return new QName(string3, string.substring(n + 1), string2);
        }
        return new QName(this.targetNamespaceStack.peek(), string);
    }
}

