/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.DownloadPlugin;
import org.netbeans.modules.subversion.client.MissingClientPanel;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.options.SvnOptionsController;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class MissingClient
implements ActionListener,
HyperlinkListener {
    private final MissingClientPanel panel = new MissingClientPanel();

    public MissingClient() {
        this.panel.browseButton.addActionListener(this);
        this.panel.executablePathTextField.setText(SvnModuleConfig.getDefault().getExecutableBinaryPath());
        this.panel.textPane.addHyperlinkListener(this);
        this.panel.downloadRadioButton.addActionListener(this);
        this.panel.cliRadioButton.addActionListener(this);
        if (Utilities.isWindows()) {
            this.panel.downloadRadioButton.setSelected(true);
        } else {
            this.panel.cliRadioButton.setSelected(true);
            this.panel.downloadRadioButton.setEnabled(false);
            this.panel.forceGlobalCheckBox.setEnabled(false);
        }
        this.radioSwitch();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void show() {
        JButton jButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_OK"));
        JButton jButton2 = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_Cancel"));
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)this.panel, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CommandFailed_Title"), 2, 0, new Object[]{jButton, jButton2}, (Object)jButton);
        if (DialogDisplayer.getDefault().notify(notifyDescriptor) == jButton) {
            if (this.panel.downloadRadioButton.isSelected()) {
                this.onDownload();
            } else {
                SvnModuleConfig.getDefault().setExecutableBinaryPath(this.panel.executablePathTextField.getText());
                SvnClientFactory.reset();
            }
        }
    }

    private void onBrowseClick() {
        File file = this.getExecutableFile();
        AccessibleJFileChooser accessibleJFileChooser = new AccessibleJFileChooser(NbBundle.getMessage(SvnOptionsController.class, (String)"ACSD_BrowseFolder"), file);
        accessibleJFileChooser.setDialogTitle(NbBundle.getMessage(SvnOptionsController.class, (String)"Browse_title"));
        accessibleJFileChooser.setMultiSelectionEnabled(false);
        accessibleJFileChooser.setFileSelectionMode(1);
        accessibleJFileChooser.showDialog(this.panel, NbBundle.getMessage(SvnOptionsController.class, (String)"OK_Button"));
        File file2 = accessibleJFileChooser.getSelectedFile();
        if (file2 != null) {
            this.panel.executablePathTextField.setText(file2.getAbsolutePath());
        }
    }

    private File getExecutableFile() {
        String string = this.panel.executablePathTextField.getText();
        return FileUtil.normalizeFile((File)new File(string));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.panel.browseButton) {
            this.onBrowseClick();
        } else if (actionEvent.getSource() == this.panel.downloadRadioButton || actionEvent.getSource() == this.panel.cliRadioButton) {
            this.radioSwitch();
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        URL uRL = hyperlinkEvent.getURL();
        assert (uRL != null);
        HtmlBrowser.URLDisplayer uRLDisplayer = HtmlBrowser.URLDisplayer.getDefault();
        assert (uRLDisplayer != null) : "HtmlBrowser.URLDisplayer found.";
        if (uRLDisplayer != null) {
            uRLDisplayer.showURL(uRL);
        } else {
            Subversion.LOG.info("No URLDisplayer found.");
        }
    }

    private void onDownload() {
        DownloadPlugin downloadPlugin = new DownloadPlugin();
        downloadPlugin.show();
        UpdateElement updateElement = downloadPlugin.getUpdateElement();
        if (updateElement != null) {
            this.install(updateElement);
        }
    }

    private void install(final UpdateElement updateElement) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    InstallCancellable installCancellable = new InstallCancellable();
                    OperationContainer operationContainer = OperationContainer.createForInstall();
                    operationContainer.add(updateElement);
                    InstallSupport.Validator validator = ((InstallSupport)operationContainer.getSupport()).doDownload(ProgressHandleFactory.createHandle((String)(NbBundle.getMessage(MissingClient.class, (String)"LBL_Downloading") + updateElement.getDisplayName()), (Cancellable)installCancellable), ((MissingClient)MissingClient.this).panel.forceGlobalCheckBox.isSelected());
                    if (installCancellable.cancelled) {
                        return;
                    }
                    InstallSupport.Installer installer = ((InstallSupport)operationContainer.getSupport()).doValidate(validator, ProgressHandleFactory.createHandle((String)(NbBundle.getMessage(MissingClient.class, (String)"LBL_Validating") + updateElement.getDisplayName()), (Cancellable)installCancellable));
                    if (installCancellable.cancelled) {
                        return;
                    }
                    OperationSupport.Restarter restarter = ((InstallSupport)operationContainer.getSupport()).doInstall(installer, ProgressHandleFactory.createHandle((String)(NbBundle.getMessage(MissingClient.class, (String)"LBL_Installing") + updateElement.getDisplayName()), (Cancellable)installCancellable));
                    if (restarter != null) {
                        JButton jButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_Restart"));
                        JButton jButton2 = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_Cancel"));
                        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(MissingClient.class, (String)"MSG_NeedsRestart"), NbBundle.getMessage(MissingClient.class, (String)"LBL_DownloadJavahl"), 2, 3, new Object[]{jButton, jButton2}, (Object)jButton);
                        if (DialogDisplayer.getDefault().notify(notifyDescriptor) == jButton) {
                            ((InstallSupport)operationContainer.getSupport()).doRestart(restarter, ProgressHandleFactory.createHandle((String)NbBundle.getMessage(MissingClient.class, (String)"LBL_Restarting")));
                        }
                    }
                }
                catch (OperationException operationException) {
                    Subversion.LOG.log(Level.SEVERE, null, operationException);
                    SvnClientExceptionHandler.notifyException((Exception)((Object)new SVNClientException((Throwable)operationException)), true, true);
                }
            }
        });
    }

    private void radioSwitch() {
        boolean bl = this.panel.cliRadioButton.isSelected();
        this.panel.browseButton.setEnabled(bl);
        this.panel.executablePathTextField.setEnabled(bl);
    }

    private class InstallCancellable
    implements Cancellable {
        private boolean cancelled;

        private InstallCancellable() {
        }

        public boolean cancel() {
            this.cancelled = true;
            return true;
        }
    }
}

