/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.subversion.client.cli.SvnCommand;

public class PropertySetCommand
extends SvnCommand {
    private final PropType type;
    private final File file;
    private final String propName;
    private final String propValue;
    private final File propFile;
    private final boolean recursivelly;

    public PropertySetCommand(String string, String string2, File file, boolean bl) {
        this.file = file;
        this.propName = string;
        this.propValue = string2;
        this.recursivelly = bl;
        this.propFile = null;
        this.type = PropType.string;
    }

    public PropertySetCommand(String string, File file, File file2, boolean bl) {
        this.file = file2;
        this.propName = string;
        this.propFile = file;
        this.recursivelly = bl;
        this.propValue = null;
        this.type = PropType.file;
    }

    protected int getCommand() {
        return 14;
    }

    protected boolean notifyOutput() {
        return false;
    }

    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("propset");
        if (this.recursivelly) {
            arguments.add("-R");
        }
        switch (this.type) {
            case string: {
                arguments.add(this.propName);
                arguments.add(this.propValue);
                arguments.add(this.file);
                break;
            }
            case file: {
                arguments.add(this.propName);
                arguments.add("-F");
                arguments.add(this.propFile);
                arguments.add(this.file);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal proptype: " + (Object)((Object)this.type));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PropType {
        string,
        file;

    }
}

