/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.browser;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.browser.Browser;
import org.netbeans.modules.subversion.ui.browser.BrowserAction;
import org.netbeans.modules.subversion.ui.search.SvnSearch;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RepositoryPaths
implements ActionListener,
DocumentListener {
    private static final RepositoryFile[] EMPTY_REPOSITORY_FILES = new RepositoryFile[0];
    private RepositoryFile repositoryFile;
    private JTextComponent repositoryPathTextField;
    private JTextComponent revisionTextField;
    private JButton browseButton;
    private JButton searchRevisionButton;
    private int browserMode;
    private BrowserAction[] browserActions;
    private String browserPurpose;
    private String browserHelpID;
    private String searchHelpID;
    private boolean valid = false;
    public static final String PROP_VALID = "valid";
    private List<PropertyChangeListener> listeners;
    private PropertyChangeSupport propertyChangeSupport;

    public RepositoryPaths(RepositoryFile repositoryFile, JTextComponent jTextComponent, JButton jButton, JTextField jTextField, JButton jButton2) {
        assert (repositoryFile != null);
        assert (jTextComponent != null && jButton != null || jTextField != null && jButton2 != null);
        this.repositoryFile = repositoryFile;
        if (jTextComponent != null) {
            this.repositoryPathTextField = jTextComponent;
            jTextComponent.getDocument().addDocumentListener(this);
            this.browseButton = jButton;
            if (jButton != null) {
                jButton.addActionListener(this);
            }
        }
        if (jTextField != null) {
            this.revisionTextField = jTextField;
            jTextField.getDocument().addDocumentListener(this);
            this.searchRevisionButton = jButton2;
            if (jButton2 != null) {
                jButton2.addActionListener(this);
            }
        }
    }

    public void setupBehavior(String string, int n, String string2, String string3) {
        this.browserMode = n;
        this.browserPurpose = string;
        this.browserHelpID = string2;
        this.searchHelpID = string3;
    }

    public void setupBehavior(String string, int n, BrowserAction[] browserActionArray, String string2, String string3) {
        this.setupBehavior(string, n, string2, string3);
        this.browserActions = browserActionArray;
        this.browserPurpose = string;
    }

    public RepositoryFile[] getRepositoryFiles() throws MalformedURLException, NumberFormatException {
        return this.getRepositoryFiles(null);
    }

    public RepositoryFile[] getRepositoryFiles(String string) throws MalformedURLException, NumberFormatException {
        SVNRevision sVNRevision = this.getRevision();
        if (this.repositoryPathTextField == null) {
            RepositoryFile repositoryFile = new RepositoryFile(this.repositoryFile.getRepositoryUrl(), this.repositoryFile.getFileUrl(), sVNRevision);
            return new RepositoryFile[]{repositoryFile};
        }
        if (this.getRepositoryString().equals("")) {
            if (string != null && !string.trim().equals("")) {
                return new RepositoryFile[]{new RepositoryFile(this.getRepositoryUrl(), string, sVNRevision)};
            }
            return EMPTY_REPOSITORY_FILES;
        }
        if (sVNRevision == null) {
            return EMPTY_REPOSITORY_FILES;
        }
        String[] stringArray = this.getRepositoryString().split(",");
        RepositoryFile[] repositoryFileArray = new RepositoryFile[stringArray.length];
        SVNUrl sVNUrl = this.getRepositoryUrl();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            String string3 = this.getRepositoryUrl().toString();
            if (string2.startsWith("file://") || string2.startsWith("http://") || string2.startsWith("https://") || string2.startsWith("svn://") || string2.startsWith("svn+ssh://")) {
                if (string2.startsWith(string3)) {
                    repositoryFileArray[i] = new RepositoryFile(sVNUrl, string2.substring(string3.length()), sVNRevision);
                    continue;
                }
                throw new MalformedURLException(NbBundle.getMessage(RepositoryPaths.class, (String)"MSG_RepositoryPath_WrongStart", (Object)string2, (Object)string3));
            }
            repositoryFileArray[i] = new RepositoryFile(sVNUrl, string2, sVNRevision);
        }
        return repositoryFileArray;
    }

    private void browseRepository() {
        RepositoryFile[] repositoryFileArray;
        SVNRevision sVNRevision = this.getRevision();
        try {
            repositoryFileArray = this.getRepositoryFiles();
        }
        catch (MalformedURLException malformedURLException) {
            Subversion.LOG.log(Level.SEVERE, null, malformedURLException);
            return;
        }
        RepositoryFile repositoryFile = new RepositoryFile(this.getRepositoryUrl(), sVNRevision);
        Browser browser = new Browser(this.browserPurpose, this.browserMode, repositoryFile, repositoryFileArray, this.browserActions, this.browserHelpID);
        RepositoryFile[] repositoryFileArray2 = browser.getRepositoryFiles();
        if (repositoryFileArray2.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < repositoryFileArray2.length; ++i) {
                stringBuffer.append(repositoryFileArray2[i].getPath());
                if (i >= repositoryFileArray2.length - 1) continue;
                stringBuffer.append(", ");
            }
            this.setRepositoryTextField(stringBuffer.toString());
        }
    }

    private void searchRepository() {
        SvnSearch svnSearch;
        DialogDescriptor dialogDescriptor;
        SVNRevision sVNRevision = this.getRevision();
        try {
            dialogDescriptor = this.getRepositoryFiles();
            svnSearch = ((RepositoryFile[])dialogDescriptor).length > 0 ? new SvnSearch((RepositoryFile[])dialogDescriptor) : new SvnSearch(this.repositoryFile);
        }
        catch (MalformedURLException malformedURLException) {
            Subversion.LOG.log(Level.SEVERE, null, malformedURLException);
            return;
        }
        dialogDescriptor = new DialogDescriptor((Object)svnSearch.getSearchPanel(), ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/browser/Bundle").getString("CTL_RepositoryPath_SearchRevisions"));
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx(this.searchHelpID));
        dialogDescriptor.setValid(false);
        svnSearch.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                dialogDescriptor.setValid(svnSearch.getSelectedRevision() != null);
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            sVNRevision = svnSearch.getSelectedRevision();
            if (sVNRevision != null) {
                if (sVNRevision.equals((Object)SVNRevision.HEAD)) {
                    this.setRevisionTextField("");
                } else {
                    this.setRevisionTextField(sVNRevision.toString());
                }
            }
        } else {
            svnSearch.cancel();
        }
    }

    public SVNRevision getRevision() {
        if (this.revisionTextField == null) {
            return SVNRevision.HEAD;
        }
        String string = this.getRevisionString();
        if (string.equals("")) {
            return SVNRevision.HEAD;
        }
        return SvnUtils.getSVNRevision(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.browseButton) {
            this.browseRepository();
        } else if (actionEvent.getSource() == this.searchRevisionButton) {
            this.searchRepository();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.validateUserInput();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.validateUserInput();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.validateUserInput();
    }

    private void validateUserInput() {
        boolean bl = this.valid;
        boolean bl2 = true;
        RepositoryFile[] repositoryFileArray = null;
        try {
            repositoryFileArray = this.getRepositoryFiles();
        }
        catch (NumberFormatException numberFormatException) {
            bl2 = false;
        }
        catch (MalformedURLException malformedURLException) {
            bl2 = false;
        }
        if (this.browseButton != null) {
            this.browseButton.setEnabled(bl2);
        }
        if (this.searchRevisionButton != null) {
            this.searchRevisionButton.setEnabled(bl2);
        }
        if (bl2 && !this.acceptEmptyUrl() && this.repositoryPathTextField != null && this.getRepositoryString().equals("")) {
            bl2 = false;
        }
        if (bl2 && !this.acceptEmptyRevision() && this.revisionTextField != null && this.getRevisionString().equals("")) {
            bl2 = false;
        }
        this.valid = bl2;
        this.fireValidPropertyChanged(bl, bl2);
    }

    private void fireValidPropertyChanged(boolean bl, boolean bl2) {
        this.getChangeSupport().firePropertyChange(new PropertyChangeEvent(this, PROP_VALID, new Boolean(bl), new Boolean(bl2)));
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getChangeSupport().addPropertyChangeListener(propertyChangeListener);
        this.validateUserInput();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getChangeSupport().removePropertyChangeListener(propertyChangeListener);
    }

    private PropertyChangeSupport getChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    protected boolean acceptEmptyUrl() {
        return false;
    }

    protected boolean acceptEmptyRevision() {
        return true;
    }

    public SVNUrl getRepositoryUrl() {
        return this.repositoryFile.getRepositoryUrl();
    }

    public void setRepositoryFile(RepositoryFile repositoryFile) {
        this.repositoryFile = repositoryFile;
    }

    public void setRepositoryTextField(String string) {
        this.repositoryPathTextField.setText(string);
    }

    public void setRevisionTextField(String string) {
        this.revisionTextField.setText(string);
    }

    protected String getRepositoryString() {
        return this.repositoryPathTextField.getText().trim();
    }

    protected String getRevisionString() {
        return this.revisionTextField.getText().trim();
    }
}

