/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.checkout;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.checkout.CheckoutAction;
import org.netbeans.modules.subversion.ui.checkout.CheckoutCompletedPanel;
import org.netbeans.modules.subversion.ui.checkout.ProjectUtilities;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CheckoutCompleted
implements ActionListener {
    private final File workingFolder;
    private final boolean openProject;
    private String[] checkedOutFolders;
    private CheckoutCompletedPanel panel;
    private Dialog dialog;
    private Project projectToBeOpened;

    public CheckoutCompleted(File file, String[] stringArray, boolean bl) {
        this.openProject = bl;
        this.checkedOutFolders = stringArray;
        this.workingFolder = file;
    }

    public void scanForProjects(SvnProgressSupport svnProgressSupport) {
        Object[] objectArray;
        String string;
        List<Object> list = new LinkedList();
        File file = FileUtil.normalizeFile((File)this.workingFolder);
        SvnUtils.refreshParents(file);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            for (int i = 0; i < this.checkedOutFolders.length; ++i) {
                if (svnProgressSupport != null && svnProgressSupport.isCanceled()) {
                    return;
                }
                string = this.checkedOutFolders[i];
                if (".".equals(string)) {
                    list = ProjectUtilities.scanForProjects(fileObject);
                    break;
                }
                objectArray = fileObject.getFileObject(string);
                if (objectArray == null) continue;
                list.addAll(ProjectUtilities.scanForProjects((FileObject)objectArray));
            }
        }
        this.panel = new CheckoutCompletedPanel();
        this.panel.openButton.addActionListener(this);
        this.panel.createButton.addActionListener(this);
        this.panel.closeButton.addActionListener(this);
        this.panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.panel.againCheckBox.setVisible(!this.openProject);
        String string2 = NbBundle.getMessage(CheckoutAction.class, (String)"BK3008");
        string = new DialogDescriptor((Object)this.panel, string2);
        string.setModal(true);
        this.panel.remove(this.panel.openButton);
        this.panel.remove(this.panel.createButton);
        this.panel.remove(this.panel.closeButton);
        objectArray = null;
        if (list.size() > 1) {
            String string3 = NbBundle.getMessage(CheckoutAction.class, (String)"BK3009", (Object)new Integer(list.size()));
            this.panel.jLabel1.setText(string3);
            objectArray = new Object[]{this.panel.openButton, this.panel.closeButton};
        } else if (list.size() == 1) {
            Project project;
            this.projectToBeOpened = project = (Project)list.iterator().next();
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
            String string4 = projectInformation.getDisplayName();
            String string5 = NbBundle.getMessage(CheckoutAction.class, (String)"BK3011", (Object)string4);
            this.panel.jLabel1.setText(string5);
            this.panel.openButton.setText(NbBundle.getMessage(CheckoutAction.class, (String)"BK3012"));
            objectArray = new Object[]{this.panel.openButton, this.panel.closeButton};
        } else {
            String string6 = NbBundle.getMessage(CheckoutAction.class, (String)"BK3010");
            this.panel.jLabel1.setText(string6);
            objectArray = new Object[]{this.panel.createButton, this.panel.closeButton};
        }
        string.setMessageType(1);
        string.setOptions(objectArray);
        string.setClosingOptions(objectArray);
        string.setHelpCtx(new HelpCtx(CheckoutCompletedPanel.class));
        this.dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)string);
        this.dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CheckoutAction.class, (String)"ACSD_CheckoutCompleted_Dialog"));
        if (svnProgressSupport != null && svnProgressSupport.isCanceled()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CheckoutCompleted.this.dialog.setVisible(true);
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.dialog.setVisible(false);
        if (this.panel.openButton.equals(object)) {
            if (this.projectToBeOpened == null) {
                JFileChooser jFileChooser = ProjectChooser.projectChooser();
                jFileChooser.setCurrentDirectory(this.workingFolder);
                jFileChooser.setMultiSelectionEnabled(true);
                jFileChooser.showOpenDialog(this.dialog);
                File[] fileArray = jFileChooser.getSelectedFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    File file = fileArray[i];
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    if (fileObject == null) continue;
                    try {
                        Project project = ProjectManager.getDefault().findProject(fileObject);
                        if (project == null) continue;
                        this.openProject(project);
                        continue;
                    }
                    catch (IOException iOException) {
                        Subversion.LOG.log(Level.SEVERE, NbBundle.getMessage(CheckoutAction.class, (String)"BK1014", (Object)fileObject), iOException);
                    }
                }
            } else {
                if (this.projectToBeOpened == null) {
                    return;
                }
                this.openProject(this.projectToBeOpened);
            }
        } else if (this.panel.createButton.equals(object)) {
            ProjectUtilities.newProjectWizard(this.workingFolder);
        }
    }

    private void openProject(Project project) {
        Project[] projectArray = new Project[]{project};
        OpenProjects.getDefault().open(projectArray, false);
        OpenProjects.getDefault().setMainProject(project);
        ProjectUtilities.selectAndExpandProject(project);
    }
}

