/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.commit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.commit.CommitOptions;
import org.netbeans.modules.subversion.ui.commit.CommitPanel;
import org.netbeans.modules.subversion.ui.commit.CommitTable;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.DialogBoundsPreserver;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.SVNBaseDir;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitAction
extends ContextAction {
    static final String RECENT_COMMIT_MESSAGES = "recentCommitMessage";

    @Override
    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_Commit";
    }

    @Override
    protected boolean enable(Node[] nodeArray) {
        if (CommitAction.isDeepRefresh()) {
            return true;
        }
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        File[] fileArray = fileStatusCache.listFiles(this.getContext(nodeArray), 6612);
        return fileArray.length > 0;
    }

    public static void commit(String string, Context context) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        if (CommitAction.isDeepRefresh()) {
            CommitAction.commitAllChanges(string, context);
        } else {
            CommitAction.commitKnownChanges(string, context);
        }
    }

    private static boolean isDeepRefresh() {
        String string = System.getProperty("netbeans.subversion.commit.deepStatusRefresh");
        return string != null && !string.trim().equals("");
    }

    public static void commitKnownChanges(String string, Context context) {
        List<File> list = CommitAction.getFiles(context);
        if (list.size() == 0) {
            return;
        }
        CommitPanel commitPanel = new CommitPanel();
        CommitTable commitTable = new CommitTable(commitPanel.filesLabel, CommitTable.COMMIT_COLUMNS, new String[]{"path"});
        commitPanel.setCommitTable(commitTable);
        commitTable.setNodes(CommitAction.getFileNodes(list));
        JButton jButton = new JButton();
        if (CommitAction.showCommitDialog(commitPanel, commitTable, jButton, string, context) == jButton) {
            CommitAction.startCommitTask(commitPanel, commitTable, context);
        }
    }

    public static void commitAllChanges(String string, Context context) {
        CommitPanel commitPanel = new CommitPanel();
        CommitTable commitTable = new CommitTable(commitPanel.filesLabel, CommitTable.COMMIT_COLUMNS, new String[]{"path"});
        commitPanel.setCommitTable(commitTable);
        JButton jButton = new JButton();
        SVNUrl sVNUrl = null;
        try {
            sVNUrl = CommitAction.getSvnUrl(context);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
        }
        SvnProgressSupport svnProgressSupport = CommitAction.getPrepareSupport(context, commitTable, jButton, commitPanel);
        RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
        svnProgressSupport.start(requestProcessor, sVNUrl, NbBundle.getMessage(CommitAction.class, (String)"BK1009"));
        if (CommitAction.showCommitDialog(commitPanel, commitTable, jButton, string, context) == jButton) {
            CommitAction.startCommitTask(commitPanel, commitTable, context);
        } else {
            svnProgressSupport.cancel();
        }
    }

    private static List<File> getFiles(Context context) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = context.getFiles();
        if (fileArray.length == 0) {
            return arrayList;
        }
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        List<File> list = context.getRoots();
        HashSet<File> hashSet = new HashSet<File>();
        for (File fileArray2 : fileArray) {
            hashSet.add(fileArray2);
        }
        for (File file : list) {
            hashSet.add(file);
        }
        fileArray = hashSet.toArray(new File[hashSet.size()]);
        File[][] fileArray3 = Utils.splitFlatOthers((File[])fileArray);
        for (int i = 0; i < fileArray3.length; ++i) {
            int n;
            int n2;
            fileArray = fileArray3[i];
            int n3 = n2 = i == 1 ? 1 : 0;
            if (n2 != 0) {
                File[] fileArray2 = fileStatusCache.listFiles(context, 6612);
                for (n = 0; n < fileArray2.length; ++n) {
                    for (int j = 0; j < fileArray.length; ++j) {
                        if (!SvnUtils.isParentOrEqual(fileArray[j], fileArray2[n]) || arrayList.contains(fileArray2[n])) continue;
                        arrayList.add(fileArray2[n]);
                    }
                }
                continue;
            }
            File[] fileArray4 = SvnUtils.flatten(fileArray, 6612);
            for (n = 0; n < fileArray4.length; ++n) {
                if (arrayList.contains(fileArray4[n])) continue;
                arrayList.add(fileArray4[n]);
            }
        }
        return arrayList;
    }

    private static SvnFileNode[] getFileNodes(List<File> list) {
        ArrayList<SvnFileNode> arrayList = new ArrayList<SvnFileNode>(list.size());
        for (File file : list) {
            SvnFileNode svnFileNode = new SvnFileNode(file);
            arrayList.add(svnFileNode);
        }
        SvnFileNode[] svnFileNodeArray = arrayList.toArray(new SvnFileNode[list.size()]);
        return svnFileNodeArray;
    }

    private static Object showCommitDialog(final CommitPanel commitPanel, final CommitTable commitTable, final JButton jButton, String string, Context context) {
        JComponent jComponent = commitTable.getComponent();
        commitPanel.filesPanel.setLayout(new BorderLayout());
        commitPanel.filesPanel.add((Component)jComponent, "Center");
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Commit"));
        jButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommitAction.class, (String)"ACSN_Commit_Action_Commit"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitAction.class, (String)"ACSD_Commit_Action_Commit"));
        JButton jButton2 = new JButton(NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Cancel"));
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Cancel"));
        jButton2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommitAction.class, (String)"ACSN_Commit_Action_Cancel"));
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitAction.class, (String)"ACSD_Commit_Action_Cancel"));
        jButton2.setDefaultCapable(false);
        jButton.setEnabled(false);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)commitPanel, NbBundle.getMessage(CommitAction.class, (String)"CTL_CommitDialog_Title", (Object)string), true, new Object[]{jButton, jButton2}, (Object)jButton, 0, new HelpCtx(CommitAction.class), null);
        commitPanel.addVersioningListener(new VersioningListener(){

            public void versioningEvent(VersioningEvent versioningEvent) {
                CommitAction.refreshCommitDialog(commitPanel, commitTable, jButton);
            }
        });
        commitTable.getTableModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                CommitAction.refreshCommitDialog(commitPanel, commitTable, jButton);
            }
        });
        jButton.setEnabled(CommitAction.containsCommitable(commitTable));
        commitPanel.putClientProperty("contentTitle", string);
        commitPanel.putClientProperty("DialogDescriptor", dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.addWindowListener((WindowListener)new DialogBoundsPreserver(SvnModuleConfig.getDefault().getPreferences(), "svn.commit.dialog"));
        dialog.pack();
        dialog.setVisible(true);
        return dialogDescriptor.getValue();
    }

    private static void startCommitTask(CommitPanel commitPanel, CommitTable commitTable, final Context context) {
        final Map<SvnFileNode, CommitOptions> map = commitTable.getCommitFiles();
        final String string = commitPanel.messageTextArea.getText();
        Utils.insert((Preferences)SvnModuleConfig.getDefault().getPreferences(), (String)RECENT_COMMIT_MESSAGES, (String)string, (int)20);
        SVNUrl sVNUrl = null;
        try {
            sVNUrl = CommitAction.getSvnUrl(context);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
        }
        RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
        SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

            public void perform() {
                CommitAction.performCommit(string, map, context, this);
            }
        };
        svnProgressSupport.start(requestProcessor, sVNUrl, NbBundle.getMessage(CommitAction.class, (String)"LBL_Commit_Progress"));
    }

    private static SvnProgressSupport getPrepareSupport(final Context context, final CommitTable commitTable, final JButton jButton, final CommitPanel commitPanel) {
        SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform() {
                ArrayList<File> arrayList;
                block14: {
                    File[] fileArray;
                    block13: {
                        fileArray = context.getFiles();
                        if (fileArray.length != 0) break block13;
                        jButton.setEnabled(CommitAction.containsCommitable(commitTable));
                        commitPanel.addVersioningListener(new VersioningListener(){

                            public void versioningEvent(VersioningEvent versioningEvent) {
                                CommitAction.refreshCommitDialog(commitPanel, commitTable, jButton);
                            }
                        });
                        commitTable.getTableModel().addTableModelListener(new TableModelListener(){

                            public void tableChanged(TableModelEvent tableModelEvent) {
                                CommitAction.refreshCommitDialog(commitPanel, commitTable, jButton);
                            }
                        });
                        return;
                    }
                    List<File> list = context.getRoots();
                    HashSet<File> hashSet = new HashSet<File>();
                    for (File file : fileArray) {
                        hashSet.add(file);
                    }
                    for (File file : list) {
                        hashSet.add(file);
                    }
                    fileArray = hashSet.toArray(new File[hashSet.size()]);
                    FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
                    for (File file : fileArray) {
                        fileStatusCache.refreshRecursively(file);
                    }
                    File[] fileArray2 = Utils.splitFlatOthers((File[])fileArray);
                    arrayList = new ArrayList<File>();
                    for (int i = 0; i < fileArray2.length; ++i) {
                        int n;
                        File[] fileArray3;
                        boolean bl;
                        fileArray = fileArray2[i];
                        boolean bl2 = bl = i == 1;
                        if (bl) {
                            fileArray3 = fileStatusCache.listFiles(context, 6612);
                            for (n = 0; n < fileArray3.length; ++n) {
                                for (int j = 0; j < fileArray.length; ++j) {
                                    if (!SvnUtils.isParentOrEqual(fileArray[j], fileArray3[n]) || arrayList.contains(fileArray3[n])) continue;
                                    arrayList.add(fileArray3[n]);
                                }
                            }
                            continue;
                        }
                        fileArray3 = SvnUtils.flatten(fileArray, 6612);
                        for (n = 0; n < fileArray3.length; ++n) {
                            if (arrayList.contains(fileArray3[n])) continue;
                            arrayList.add(fileArray3[n]);
                        }
                    }
                    if (arrayList.size() != 0) break block14;
                    jButton.setEnabled(CommitAction.containsCommitable(commitTable));
                    commitPanel.addVersioningListener(new /* invalid duplicate definition of identical inner class */);
                    commitTable.getTableModel().addTableModelListener(new /* invalid duplicate definition of identical inner class */);
                    return;
                }
                try {
                    ArrayList<SvnFileNode> arrayList2 = new ArrayList<SvnFileNode>(arrayList.size());
                    for (File file : arrayList) {
                        SvnFileNode svnFileNode = new SvnFileNode(file);
                        arrayList2.add(svnFileNode);
                    }
                    SvnFileNode[] svnFileNodeArray = arrayList2.toArray(new SvnFileNode[arrayList.size()]);
                    commitTable.setNodes(svnFileNodeArray);
                }
                catch (Throwable throwable) {
                    jButton.setEnabled(CommitAction.containsCommitable(commitTable));
                    commitPanel.addVersioningListener(new /* invalid duplicate definition of identical inner class */);
                    commitTable.getTableModel().addTableModelListener(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                jButton.setEnabled(CommitAction.containsCommitable(commitTable));
                commitPanel.addVersioningListener(new /* invalid duplicate definition of identical inner class */);
                commitTable.getTableModel().addTableModelListener(new /* invalid duplicate definition of identical inner class */);
            }
        };
        return svnProgressSupport;
    }

    private static boolean containsCommitable(CommitTable commitTable) {
        Map<SvnFileNode, CommitOptions> map = commitTable.getCommitFiles();
        for (CommitOptions commitOptions : map.values()) {
            if (commitOptions == CommitOptions.EXCLUDE) continue;
            return true;
        }
        return false;
    }

    private static void refreshCommitDialog(CommitPanel commitPanel, CommitTable commitTable, JButton jButton) {
        String string;
        Object object;
        SvnFileNode svnFileNode2;
        ResourceBundle resourceBundle = NbBundle.getBundle(CommitAction.class);
        Map<SvnFileNode, CommitOptions> map = commitTable.getCommitFiles();
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        boolean bl2 = jButton.isEnabled();
        for (SvnFileNode svnFileNode2 : map.keySet()) {
            object = map.get(svnFileNode2);
            if (object == CommitOptions.EXCLUDE) continue;
            hashSet.add(SvnUtils.getCopy(svnFileNode2.getFile()));
            int n = svnFileNode2.getInformation().getStatus();
            if ((n & 0x6A0) == 0 && n != 64) continue;
            bl2 = false;
            string = n == 64 ? resourceBundle.getString("MSG_CommitForm_ErrorConflicts") : resourceBundle.getString("MSG_CommitForm_ErrorRemoteChanges");
            commitPanel.setErrorLabel("<html><font color=\"#002080\">" + string + "</font></html>");
            bl = true;
        }
        if (hashSet.size() > 1) {
            commitTable.setColumns(new String[]{"name", "branch", "status", "action", "path"});
        } else {
            commitTable.setColumns(new String[]{"name", "status", "action", "path"});
        }
        String string2 = (String)commitPanel.getClientProperty("contentTitle");
        svnFileNode2 = (DialogDescriptor)commitPanel.getClientProperty("DialogDescriptor");
        if (hashSet.size() <= 1) {
            String string3;
            String string4 = string3 = hashSet.size() == 0 ? null : (String)hashSet.iterator().next();
            if (string3 == null) {
                svnFileNode2.setTitle(MessageFormat.format(resourceBundle.getString("CTL_CommitDialog_Title"), string2));
                object = "";
            } else {
                svnFileNode2.setTitle(MessageFormat.format(resourceBundle.getString("CTL_CommitDialog_Title_Branch"), string2, string3));
                string = MessageFormat.format(resourceBundle.getString("MSG_CommitForm_InfoBranch"), string3);
                object = "<html><font color=\"#002080\">" + string + "</font></html>";
            }
        } else {
            svnFileNode2.setTitle(MessageFormat.format(resourceBundle.getString("CTL_CommitDialog_Title_Branches"), string2));
            String string5 = resourceBundle.getString("MSG_CommitForm_ErrorMultipleBranches");
            object = "<html><font color=\"#CC0000\">" + string5 + "</font></html>";
        }
        if (!bl) {
            commitPanel.setErrorLabel((String)object);
            bl2 = true;
        }
        jButton.setEnabled(bl2 && CommitAction.containsCommitable(commitTable));
    }

    @Override
    protected void performContextAction(Node[] nodeArray) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context context = this.getContext(nodeArray);
        CommitAction.commit(this.getContextDisplayName(nodeArray), context);
    }

    public static void performCommit(String string, Map<SvnFileNode, CommitOptions> map, Context context, SvnProgressSupport svnProgressSupport) {
        CommitAction.performCommit(string, map, context, svnProgressSupport, false);
    }

    public static void performCommit(String string, Map<SvnFileNode, CommitOptions> map, Context context, SvnProgressSupport svnProgressSupport, boolean bl) {
        try {
            File[] fileArray;
            List<File> list;
            List list2;
            Object object;
            Object object2;
            SvnClient svnClient;
            try {
                svnClient = Subversion.getInstance().getClient(context, svnProgressSupport);
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                return;
            }
            svnProgressSupport.setDisplayName(NbBundle.getMessage(CommitAction.class, (String)"LBL_Commit_Progress"));
            ArrayList<SvnFileNode> arrayList = new ArrayList<SvnFileNode>();
            ArrayList<File> arrayList2 = new ArrayList<File>();
            LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
            HashSet<File> hashSet = new HashSet<File>();
            Iterator<SvnFileNode> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                if (svnProgressSupport.isCanceled()) {
                    return;
                }
                object2 = iterator.next();
                object = map.get(object2);
                if (CommitOptions.ADD_BINARY == object) {
                    list2 = CommitAction.listUnmanagedParents((SvnFileNode)object2);
                    list = list2.iterator();
                    while (list.hasNext()) {
                        if (svnProgressSupport.isCanceled()) {
                            return;
                        }
                        fileArray = list.next();
                        arrayList.add(new SvnFileNode((File)fileArray));
                        linkedHashSet.add((File)fileArray);
                    }
                    if (svnProgressSupport.isCanceled()) {
                        return;
                    }
                    hashSet.add(((SvnFileNode)object2).getFile());
                    arrayList.add((SvnFileNode)object2);
                    linkedHashSet.add(((SvnFileNode)object2).getFile());
                    continue;
                }
                if (CommitOptions.ADD_TEXT == object || CommitOptions.ADD_DIRECTORY == object) {
                    list2 = CommitAction.listUnmanagedParents((SvnFileNode)object2);
                    list = list2.iterator();
                    while (list.hasNext()) {
                        if (svnProgressSupport.isCanceled()) {
                            return;
                        }
                        fileArray = (File)list.next();
                        arrayList.add(new SvnFileNode((File)fileArray));
                        linkedHashSet.add((File)fileArray);
                    }
                    if (svnProgressSupport.isCanceled()) {
                        return;
                    }
                    arrayList.add((SvnFileNode)object2);
                    linkedHashSet.add(((SvnFileNode)object2).getFile());
                    continue;
                }
                if (CommitOptions.COMMIT_REMOVE == object) {
                    arrayList2.add(((SvnFileNode)object2).getFile());
                    linkedHashSet.add(((SvnFileNode)object2).getFile());
                    continue;
                }
                if (CommitOptions.COMMIT != object) continue;
                linkedHashSet.add(((SvnFileNode)object2).getFile());
            }
            CommitAction.performAdds(svnClient, svnProgressSupport, arrayList);
            if (svnProgressSupport.isCanceled()) {
                return;
            }
            object2 = CommitAction.getManagedTrees(svnClient, svnProgressSupport, linkedHashSet, hashSet);
            if (svnProgressSupport.isCanceled()) {
                return;
            }
            object = object2.iterator();
            while (object.hasNext()) {
                list2 = (List)object.next();
                list = CommitAction.getRecursiveCommits(list2, arrayList2);
                if (list.size() > 0) {
                    list2.removeAll(CommitAction.getAllChildren(list, list2));
                    fileArray = list.toArray(new File[list.size()]);
                    svnClient.commit(fileArray, string, true);
                    if (svnProgressSupport.isCanceled()) {
                        return;
                    }
                }
                if (list2.size() > 0) {
                    fileArray = list2.toArray(new File[list2.size()]);
                    svnClient.commit(fileArray, string, false);
                    if (svnProgressSupport.isCanceled()) {
                        return;
                    }
                }
                fileArray = Subversion.getInstance().getStatusCache();
                if (bl) {
                    int n;
                    File[] fileArray2 = context.getRootFiles();
                    for (n = 0; n < fileArray2.length; ++n) {
                        svnClient.update(fileArray2[n], SVNRevision.HEAD, false);
                    }
                    for (n = 0; n < fileArray2.length; ++n) {
                        fileArray.refresh(fileArray2[n], FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                    }
                }
                CommitAction.refreshFiles((FileStatusCache)fileArray, list2);
                if (svnProgressSupport.isCanceled()) {
                    return;
                }
                CommitAction.refreshFiles((FileStatusCache)fileArray, list);
                if (!svnProgressSupport.isCanceled()) continue;
                return;
            }
        }
        catch (SVNClientException sVNClientException) {
            svnProgressSupport.annotate(sVNClientException);
        }
    }

    private static List<List<File>> getManagedTrees(SvnClient svnClient, SvnProgressSupport svnProgressSupport, Set<File> set, Set<File> set2) throws SVNClientException {
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        ArrayList<List<File>> arrayList = new ArrayList<List<File>>();
        for (File file : set) {
            Object object;
            if (set2.contains(file)) {
                object = svnClient.propertyGet(file, "svn:mime-type");
                if (object != null) {
                    String string = object.getValue();
                    if (string == null || string.startsWith("text/")) {
                        svnClient.propertySet(file, "svn:mime-type", "application/octet-stream", false);
                    }
                } else {
                    svnClient.propertySet(file, "svn:mime-type", "application/octet-stream", false);
                }
            }
            if (svnProgressSupport.isCanceled()) {
                return null;
            }
            object = null;
            for (List list : arrayList) {
                FileInformation fileInformation;
                File file2 = (File)list.get(0);
                File file3 = SVNBaseDir.getRootDir((File[])new File[]{file, file2});
                if (file3 != null && ((fileInformation = fileStatusCache.getStatus(file3)).getStatus() & 0xFFFFFFFE) != 0) {
                    object = list;
                    break;
                }
                if (!svnProgressSupport.isCanceled()) continue;
                return null;
            }
            if (object == null) {
                object = new ArrayList();
                arrayList.add((List<File>)object);
            }
            object.add(file);
        }
        return arrayList;
    }

    private static void performAdds(SvnClient svnClient, SvnProgressSupport svnProgressSupport, List<SvnFileNode> list) throws SVNClientException {
        Object object;
        Serializable serializable;
        Object object2;
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        ArrayList<Serializable> arrayList2 = new ArrayList<Serializable>();
        Iterator<SvnFileNode> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (svnProgressSupport.isCanceled()) {
                return;
            }
            object2 = iterator.next();
            serializable = ((SvnFileNode)object2).getFile();
            if (((File)serializable).isDirectory()) {
                arrayList2.add(serializable);
                continue;
            }
            if (!((File)serializable).isFile()) continue;
            arrayList.add(serializable);
        }
        if (svnProgressSupport.isCanceled()) {
            return;
        }
        object2 = arrayList2.iterator();
        serializable = new ArrayList();
        while (object2.hasNext()) {
            object = (File)object2.next();
            if (serializable.contains(object)) continue;
            serializable.add(object);
        }
        if (serializable.size() > 0) {
            object = serializable.iterator();
            while (object.hasNext()) {
                File file = (File)object.next();
                svnClient.addFile(file);
            }
        }
        if (svnProgressSupport.isCanceled()) {
            return;
        }
        if (arrayList.size() > 0) {
            for (File file : arrayList) {
                svnClient.addFile(file);
            }
        }
    }

    private static List<File> getRecursiveCommits(List<File> list, List<File> list2) {
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        ArrayList<File> arrayList = new ArrayList<File>();
        boolean bl = false;
        for (File file : list) {
            if (!file.isDirectory() || list2.contains(file) || fileStatusCache.getStatus(file).getEntry(file).isCopied()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            arrayList.addAll(arrayList);
            arrayList.addAll(list);
        } else {
            for (File file : list) {
                if (!file.isDirectory() || !list2.contains(file) && !fileStatusCache.getStatus(file).getEntry(file).isCopied()) continue;
                arrayList.add(file);
            }
        }
        return arrayList;
    }

    private static List<File> getAllChildren(List<File> list, List<File> list2) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (list.size() > 0) {
            Iterator<File> iterator = list2.iterator();
            while (iterator.hasNext()) {
                File file;
                for (File file2 = file = iterator.next(); file2 != null; file2 = file2.getParentFile()) {
                    if (!list.contains(file2)) continue;
                    arrayList.add(file);
                }
            }
        }
        return arrayList;
    }

    private static void refreshFiles(FileStatusCache fileStatusCache, List<File> list) {
        for (File file : list) {
            fileStatusCache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
        }
    }

    private static List<File> listUnmanagedParents(SvnFileNode svnFileNode) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = svnFileNode.getFile();
        File file2 = file.getParentFile();
        while (!new File(file2, SvnUtils.SVN_ENTRIES_DIR).canRead()) {
            arrayList.add(0, file2);
            if ((file2 = file2.getParentFile()) != null) continue;
        }
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (File file3 : arrayList) {
            arrayList2.add(file3);
        }
        return arrayList2;
    }
}

