/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.relocate;

import java.awt.Dialog;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.relocate.RelocatePanel;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RelocateAction
extends ContextAction {
    protected boolean enable(Node[] nodeArray) {
        Context context = this.getContext(nodeArray);
        File[] fileArray = context.getRootFiles();
        if (fileArray == null || fileArray.length != 1) {
            return false;
        }
        File file = fileArray[0];
        return file != null && file.isDirectory();
    }

    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    private String getCurrentURL(File file) {
        try {
            SVNUrl sVNUrl = SvnUtils.getRepositoryRootUrl(file);
            return sVNUrl.toString();
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return "";
        }
    }

    private String getWorkingCopy(File file) {
        String string = file.getAbsolutePath();
        return string;
    }

    public void validate(RelocatePanel relocatePanel, JButton jButton) {
        try {
            new SVNUrl(relocatePanel.getNewURL().getText());
            jButton.setEnabled(true);
        }
        catch (MalformedURLException malformedURLException) {
            jButton.setEnabled(false);
        }
    }

    protected String getBaseName(Node[] nodeArray) {
        return "CTL_Relocate_Title";
    }

    protected void performContextAction(Node[] nodeArray) {
        SVNUrl sVNUrl;
        ResourceBundle resourceBundle = NbBundle.getBundle(RelocateAction.class);
        Context context = this.getContext(nodeArray);
        File[] fileArray = context.getRootFiles();
        if (fileArray == null) {
            return;
        }
        final RelocatePanel relocatePanel = new RelocatePanel();
        relocatePanel.getCurrentURL().setText(this.getCurrentURL(fileArray[0]));
        relocatePanel.getWorkingCopy().setText(this.getWorkingCopy(fileArray[0]));
        final JButton jButton = new JButton(resourceBundle.getString("CTL_Relocate_Action_Name"));
        jButton.setEnabled(false);
        jButton.setToolTipText(resourceBundle.getString("TT_Relocate_Action"));
        relocatePanel.getNewURL().getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                RelocateAction.this.validate(relocatePanel, jButton);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                RelocateAction.this.validate(relocatePanel, jButton);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                RelocateAction.this.validate(relocatePanel, jButton);
            }
        });
        JButton jButton2 = new JButton(resourceBundle.getString("CTL_Relocate_Action_Cancel"));
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RelocateAction.class, (String)"ACSD_Relocate_Action_Cancel"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)relocatePanel, resourceBundle.getString("CTL_Relocate_Dialog_Title"), true, new Object[]{jButton, jButton2}, (Object)jButton, 0, null, null);
        dialogDescriptor.setClosingOptions(null);
        dialogDescriptor.setHelpCtx(new HelpCtx(RelocateAction.class));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_Relocate"));
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != jButton) {
            return;
        }
        final String string = relocatePanel.getNewURL().getText();
        try {
            sVNUrl = SvnUtils.getRepositoryRootUrl(fileArray[0]);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        final String string2 = fileArray[0].getAbsolutePath();
        RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
        SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){
            SvnClient client = null;

            protected void perform() {
                try {
                    this.client = Subversion.getInstance().getClient(sVNUrl);
                    this.client.relocate(sVNUrl.toString(), string, string2, true);
                }
                catch (SVNClientException sVNClientException) {
                    this.annotate(sVNClientException);
                }
            }
        };
        svnProgressSupport.start(requestProcessor, sVNUrl, resourceBundle.getString("LBL_Relocate_Progress"));
    }
}

