/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards;

import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.subversion.Subversion;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;

public abstract class AbstractStep
implements WizardDescriptor.ValidatingPanel {
    private List<ChangeListener> listeners = new LinkedList<ChangeListener>();
    private boolean valid;
    private JComponent panel;
    private volatile boolean underConstruction;
    private WizardMessage errorMessage;
    private boolean applyStandaloneLayout;
    private boolean isInfo;

    public void applyStandaloneLayout() {
        this.applyStandaloneLayout = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Component getComponent() {
        if (this.panel == null) {
            try {
                this.underConstruction = true;
                this.panel = this.createComponent();
                HelpCtx.setHelpIDString((JComponent)this.panel, (String)this.getClass().getName());
                if (!this.applyStandaloneLayout) {
                    JTextArea jTextArea = new JTextArea();
                    jTextArea.setColumns(60);
                    jTextArea.setRows(25);
                    this.panel.setPreferredSize(jTextArea.getPreferredSize());
                }
            }
            catch (RuntimeException runtimeException) {
                Subversion.LOG.log(Level.SEVERE, null, runtimeException);
            }
            finally {
                assert (this.panel != null);
                this.underConstruction = false;
                this.fireChange();
            }
        }
        return this.panel;
    }

    protected abstract JComponent createComponent();

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(Object object) {
    }

    public void storeSettings(Object object) {
    }

    protected final void valid() {
        this.setValid(true, null);
    }

    protected final void valid(WizardMessage wizardMessage) {
        this.setValid(true, wizardMessage);
    }

    protected final void invalid(WizardMessage wizardMessage) {
        this.setValid(false, wizardMessage);
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final WizardMessage getErrorMessage() {
        return this.errorMessage;
    }

    public final void validate() throws WizardValidationException {
        this.validateBeforeNext();
        if (!this.isValid() || this.errorMessage != null) {
            throw new WizardValidationException(this.panel, this.errorMessage.getMessage(), this.errorMessage.getMessage());
        }
    }

    protected abstract void validateBeforeNext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(changeListener);
        }
    }

    private void setValid(boolean bl, WizardMessage wizardMessage) {
        boolean bl2 = this.valid != bl;
        boolean bl3 = wizardMessage != null && this.errorMessage == null || wizardMessage == null && this.errorMessage != null || wizardMessage != null && this.errorMessage != null && !wizardMessage.getMessage().equals(this.errorMessage.getMessage());
        this.valid = bl;
        this.errorMessage = wizardMessage;
        if (bl2 |= bl3) {
            this.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> arrayList;
        if (this.underConstruction) {
            return;
        }
        Object object = this.listeners;
        synchronized (object) {
            arrayList = new ArrayList<ChangeListener>(this.listeners);
        }
        object = arrayList.iterator();
        ChangeEvent changeEvent = new ChangeEvent(this);
        while (object.hasNext()) {
            ChangeListener changeListener = (ChangeListener)object.next();
            changeListener.stateChanged(changeEvent);
        }
    }

    public class WizardMessage {
        private final boolean info;
        private final String msg;

        public WizardMessage(String string, boolean bl) {
            this.info = bl;
            this.msg = string;
        }

        public boolean isInfo() {
            return this.info;
        }

        public String getMessage() {
            return this.msg;
        }
    }
}

