/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.Timer;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.util.CsmTracer;
import org.netbeans.modules.cnd.classview.ClassViewModel;
import org.netbeans.modules.cnd.classview.Diagnostic;
import org.netbeans.modules.cnd.classview.ProjectsKeyArray;
import org.netbeans.modules.cnd.classview.RootNode;
import org.netbeans.modules.cnd.classview.resources.I18n;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class ClassView
extends JComponent
implements ExplorerManager.Provider,
Accessible {
    protected BeanTreeView view;
    private ClassViewModel model;
    private ViewMouseListener mouseListener = new ViewMouseListener();
    private ExplorerManager manager;
    private static final boolean TRACE_MODEL_CHANGE_EVENTS = Boolean.getBoolean("cnd.classview.trace.events");
    private Timer userActivity = null;
    private static final int USER_MOUSE_ACTIVITY_DELAY = 2000;

    public ClassView() {
        this.setLayout(new BorderLayout());
        this.manager = new ExplorerManager();
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        this.setupRootContext(this.createEmptyRoot());
    }

    void selectInClasses(final CsmOffsetableDeclaration csmOffsetableDeclaration) {
        CsmModelAccessor.getModel().enqueue(new Runnable(){

            public void run() {
                Node node;
                ClassViewModel classViewModel = ClassView.this.getModel();
                if (classViewModel != null && (node = classViewModel.findDeclaration(csmOffsetableDeclaration)) != null) {
                    try {
                        ClassView.this.setUserActivity();
                        ClassView.this.getExplorerManager().setSelectedNodes(new Node[]{node});
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        Exceptions.printStackTrace((Throwable)propertyVetoException);
                    }
                }
            }
        }, (CharSequence)"Class View: select in classes");
    }

    private void init() {
        this.view = new BeanTreeView();
        this.view.setRootVisible(false);
        this.view.setDragSource(true);
        this.add((Component)this.view, "Center");
        this.setToolTipText(I18n.getMessage("ClassViewTitle"));
        this.setName(I18n.getMessage("ClassViewTooltip"));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }

                public String getAccessibleName() {
                    if (this.accessibleName != null) {
                        return this.accessibleName;
                    }
                    return ClassView.this.getName();
                }

                public String getToolTipText() {
                    return ClassView.this.getToolTipText();
                }
            };
        }
        return this.accessibleContext;
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.view.requestFocusInWindow();
    }

    public void requestFocus() {
        super.requestFocus();
        this.view.requestFocus();
    }

    private void addRemoveViewListeners(boolean bl) {
        JViewport jViewport;
        Object object;
        Component[] componentArray = this.view.getComponents();
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                object = componentArray[i];
                if (!(object instanceof JScrollBar)) continue;
                if (bl) {
                    ((Component)object).addMouseListener(this.mouseListener);
                    ((Component)object).addMouseMotionListener(this.mouseListener);
                    continue;
                }
                ((Component)object).removeMouseListener(this.mouseListener);
                ((Component)object).removeMouseMotionListener(this.mouseListener);
            }
        }
        if ((object = (jViewport = this.view.getViewport()).getComponents()) != null && ((Component[])object).length > 0) {
            if (bl) {
                object[0].addMouseListener(this.mouseListener);
                ((Component)object[0]).addMouseMotionListener(this.mouseListener);
            } else {
                object[0].removeMouseListener(this.mouseListener);
                ((Component)object[0]).removeMouseMotionListener(this.mouseListener);
            }
        }
    }

    private void setUserActivity() {
        if (this.userActivity == null) {
            this.userActivity = new Timer(2000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClassView.this.stopViewModify();
                }
            });
        }
        this.userActivity.restart();
        ClassViewModel classViewModel = this.getModel();
        if (classViewModel != null && !classViewModel.isUserActivity()) {
            classViewModel.setUserActivity(true);
        }
    }

    private void stopViewModify() {
        ClassViewModel classViewModel = this.getModel();
        if (classViewModel != null) {
            classViewModel.setUserActivity(false);
        }
        if (this.userActivity != null) {
            this.userActivity.stop();
        }
    }

    void startup() {
        if (Diagnostic.DEBUG) {
            Diagnostic.trace("ClassesV: startup()");
        }
        ClassViewModel classViewModel = this.getModel();
        this.setModel(new ClassViewModel());
        if (classViewModel != null) {
            classViewModel.dispose();
        }
        this.init();
        this.addRemoveViewListeners(true);
        if (CsmModelAccessor.getModel().projects().isEmpty()) {
            this.setupRootContext(this.createEmptyRoot());
        } else {
            this.setupRootContext((Node)this.getModel().getRoot());
        }
    }

    void shutdown() {
        if (Diagnostic.DEBUG) {
            Diagnostic.trace("ClassesV: shutdown()");
        }
        this.addRemoveViewListeners(false);
        ClassViewModel classViewModel = this.getModel();
        if (classViewModel != null) {
            classViewModel.dispose();
            this.setModel(null);
        }
        this.stopViewModify();
        this.remove((Component)this.view);
        this.view = null;
        this.userActivity = null;
        this.mouseListener = null;
        this.setupRootContext(this.createEmptyRoot());
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    void projectOpened(CsmProject csmProject) {
        ClassViewModel classViewModel;
        if (Diagnostic.DEBUG) {
            Diagnostic.trace("ClassesV: projectOpened() " + csmProject);
        }
        if ((classViewModel = this.getModel()) != null) {
            classViewModel.openProject(csmProject);
            this.setupRootContext((Node)classViewModel.getRoot());
        }
    }

    void projectClosed(CsmProject csmProject) {
        ClassViewModel classViewModel;
        if (Diagnostic.DEBUG) {
            Diagnostic.trace("ClassesV: projectClosed() " + csmProject);
        }
        if ((classViewModel = this.getModel()) != null && !this.getExplorerManager().getRootContext().isLeaf()) {
            classViewModel.closeProject(csmProject);
            RootNode rootNode = classViewModel.getRoot();
            Children children = rootNode.getChildren();
            if (children instanceof ProjectsKeyArray && ((ProjectsKeyArray)children).isEmpty()) {
                this.setupRootContext(this.createEmptyRoot());
            } else {
                this.setupRootContext((Node)rootNode);
            }
        }
    }

    void modelChanged(CsmChangeEvent csmChangeEvent) {
        ClassViewModel classViewModel;
        if (TRACE_MODEL_CHANGE_EVENTS) {
            new CsmTracer().dumpModelChangeEvent(csmChangeEvent);
        }
        if ((classViewModel = this.getModel()) != null) {
            classViewModel.scheduleUpdate(csmChangeEvent);
        }
    }

    private Node createEmptyRoot() {
        return Node.EMPTY;
    }

    private void setupRootContext(Node node) {
        if (this.getExplorerManager().getRootContext() != node) {
            try {
                this.getExplorerManager().setSelectedNodes(new Node[0]);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
            if (Diagnostic.DEBUG) {
                Diagnostic.trace("ClassesV: setupRootContext() " + node);
            }
            this.getExplorerManager().setRootContext(node);
        }
    }

    private ClassViewModel getModel() {
        return this.model;
    }

    private void setModel(ClassViewModel classViewModel) {
        this.model = classViewModel;
    }

    private class ViewMouseListener
    implements MouseListener,
    MouseMotionListener {
        private ViewMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            ClassView.this.setUserActivity();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            ClassView.this.setUserActivity();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ClassView.this.setUserActivity();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ClassView.this.setUserActivity();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ClassView.this.setUserActivity();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            ClassView.this.setUserActivity();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            ClassView.this.setUserActivity();
        }
    }
}

