/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmIdentifiable;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

public final class PersistentKey {
    private static final byte PROXY = 1;
    private static final byte UID = 2;
    private static final byte NAMESPACE = 4;
    private static final byte DECLARATION = 8;
    private static final byte PROJECT = 16;
    private static final byte STATE = 32;
    private Object key;
    private CsmProject project;
    private byte kind;

    private PersistentKey(CsmIdentifiable csmIdentifiable, boolean bl) {
        this.key = csmIdentifiable;
        this.kind = 1;
        if (bl) {
            this.kind = (byte)(this.kind | 0x20);
        }
    }

    private PersistentKey(CsmUID csmUID, boolean bl) {
        this.key = csmUID;
        this.kind = (byte)2;
        if (bl) {
            this.kind = (byte)(this.kind | 0x20);
        }
    }

    private PersistentKey(CharSequence charSequence, CsmProject csmProject, byte by, boolean bl) {
        this.key = charSequence;
        this.project = csmProject;
        this.kind = by;
        if (bl) {
            this.kind = (byte)(this.kind | 0x20);
        }
    }

    public static PersistentKey createGlobalNamespaceKey(CsmProject csmProject) {
        return new PersistentKey(CharSequenceKey.empty(), csmProject, 4, false);
    }

    public static PersistentKey createKey(CsmIdentifiable csmIdentifiable) {
        if (csmIdentifiable instanceof CsmNamespace) {
            CsmNamespace csmNamespace = (CsmNamespace)csmIdentifiable;
            CharSequence charSequence = csmNamespace.getQualifiedName();
            CsmProject csmProject = csmNamespace.getProject();
            if (csmProject != null) {
                return new PersistentKey(charSequence, csmProject, 4, false);
            }
        } else if (!(csmIdentifiable instanceof CsmEnumerator)) {
            if (csmIdentifiable instanceof CsmOffsetableDeclaration) {
                CsmProject csmProject;
                CsmOffsetableDeclaration csmOffsetableDeclaration = (CsmOffsetableDeclaration)csmIdentifiable;
                CharSequence charSequence = csmOffsetableDeclaration.getName();
                CharSequence charSequence2 = csmOffsetableDeclaration.getUniqueName();
                CsmScope csmScope = csmOffsetableDeclaration.getScope();
                if (csmScope instanceof CsmCompoundClassifier && charSequence.length() > 0) {
                    csmProject = (CsmCompoundClassifier)csmScope;
                    charSequence = csmProject.getName();
                }
                csmProject = csmOffsetableDeclaration.getContainingFile().getProject();
                if (charSequence.length() > 0 && ((Object)charSequence2).toString().indexOf("::::") < 0 && csmProject != null) {
                    return new PersistentKey(charSequence2, csmProject, 8, PersistentKey.getStateBit(csmIdentifiable));
                }
            } else if (csmIdentifiable instanceof CsmProject) {
                return new PersistentKey(null, (CsmProject)csmIdentifiable, 16, false);
            }
        }
        return new PersistentKey(csmIdentifiable.getUID(), PersistentKey.getStateBit(csmIdentifiable));
    }

    private static boolean getStateBit(CsmIdentifiable csmIdentifiable) {
        if (csmIdentifiable instanceof CsmTypedef) {
            CsmClassifier csmClassifier;
            CsmTypedef csmTypedef = (CsmTypedef)csmIdentifiable;
            if (((CsmTypedef)csmIdentifiable).isTypeUnnamed() && (csmClassifier = csmTypedef.getType().getClassifier()) != null && csmClassifier.getName().length() == 0 && csmClassifier instanceof CsmCompoundClassifier) {
                return true;
            }
        }
        return false;
    }

    public CsmIdentifiable getObject() {
        int n = this.kind & 0x1F;
        switch (n) {
            case 2: {
                return (CsmIdentifiable)((CsmUID)this.key).getObject();
            }
            case 1: {
                return (CsmIdentifiable)this.key;
            }
            case 4: {
                return this.project.findNamespace((CharSequence)this.key);
            }
            case 8: {
                return this.project.findDeclaration((CharSequence)this.key);
            }
            case 16: {
                return this.project;
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof PersistentKey) {
            PersistentKey persistentKey = (PersistentKey)object;
            if (this.kind != persistentKey.kind) {
                return false;
            }
            int n = this.kind & 0x1F;
            switch (n) {
                case 1: 
                case 2: {
                    return this.key.equals(persistentKey.key);
                }
                case 4: 
                case 8: {
                    if (this.project.equals(persistentKey.project)) {
                        return CharSequenceKey.Comparator.compare((CharSequence)this.key, (CharSequence)persistentKey.key) == 0;
                    }
                    return false;
                }
                case 16: {
                    return this.project.equals(persistentKey.project);
                }
            }
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = this.kind & 0x1F;
        int n2 = 0;
        if ((this.kind & 0x20) == 32) {
            n2 = 17;
        }
        switch (n) {
            case 1: 
            case 2: {
                return this.key.hashCode() + n2;
            }
            case 4: 
            case 8: {
                return this.project.hashCode() ^ this.key.hashCode() + n2;
            }
            case 16: {
                return this.project.hashCode() + n2;
            }
        }
        return 0;
    }

    public String toString() {
        int n = this.kind & 0x1F;
        switch (n) {
            case 1: {
                return "Proxy " + this.key.toString();
            }
            case 2: {
                return "UID " + this.key.toString();
            }
            case 4: {
                return "Namespace " + this.key;
            }
            case 8: {
                return "Declaration " + this.key;
            }
            case 16: {
                return "Project " + this.project.getName();
            }
        }
        return super.toString();
    }
}

