/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview.model;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.classview.Diagnostic;
import org.netbeans.modules.cnd.classview.model.BaseNode;
import org.netbeans.modules.cnd.classview.model.NPNode;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class ProjectNode
extends NPNode {
    public static final boolean EXPORT = Boolean.getBoolean("cnd.classview.export");
    private boolean isLibrary;
    private CsmProject project;
    private Node[] loadingNodes = null;

    public ProjectNode(CsmProject csmProject, Children.Array array) {
        super(array);
        this.project = csmProject;
        this.isLibrary = csmProject.isArtificial();
        this.init(csmProject);
    }

    private void init(CsmProject csmProject) {
        this.setName(((Object)csmProject.getName()).toString());
        this.setDisplayName(((Object)csmProject.getName()).toString());
    }

    protected CsmNamespace getNamespace() {
        CsmProject csmProject = this.getProject();
        if (csmProject != null) {
            return csmProject.getGlobalNamespace();
        }
        return null;
    }

    public Image getIcon(int n) {
        return CsmImageLoader.getProjectImage((boolean)this.isLibrary, (boolean)false);
    }

    public Image getOpenedIcon(int n) {
        return CsmImageLoader.getProjectImage((boolean)this.isLibrary, (boolean)true);
    }

    public CsmProject getProject() {
        return this.project;
    }

    public Action getPreferredAction() {
        if (Diagnostic.DEBUG) {
            return new TraverseAction();
        }
        if (EXPORT) {
            return new ExportAction();
        }
        return super.getPreferredAction();
    }

    public Action[] getActions(boolean bl) {
        if (Diagnostic.DEBUG || EXPORT) {
            return new Action[]{new TraverseAction(), new ExportAction()};
        }
        return new Action[0];
    }

    private class ExportAction
    extends AbstractAction {
        public ExportAction() {
            this.putValue("Name", "Export project node.");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ProjectNode.this.dump(System.out);
        }
    }

    private class TraverseAction
    extends AbstractAction {
        private Map<BaseNode, BaseNode> map;

        public TraverseAction() {
            this.putValue("Name", "Measure traverse project node time and memory.");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.map = new HashMap<BaseNode, BaseNode>();
            System.gc();
            long l = System.currentTimeMillis();
            long l2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            String string = "Creating a map.";
            if (Diagnostic.DEBUG) {
                Diagnostic.trace(string);
            } else {
                System.out.println(string);
            }
            ProjectNode.this.traverse(new BaseNode.Callback(){

                public void call(BaseNode baseNode) {
                    TraverseAction.this.map.put(baseNode, baseNode);
                }
            });
            l = System.currentTimeMillis() - l;
            System.gc();
            l2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() - l2;
            string = "A map is created. Used time: " + l + " Used Memory: " + l2 / 1024L + " Kb";
            if (Diagnostic.DEBUG) {
                Diagnostic.trace(string);
            } else {
                System.out.println(string);
            }
            this.map = null;
        }

        public String getName() {
            return (String)this.getValue("Name");
        }
    }
}

