/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.components.svg.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGButtonCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGCheckBoxCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGComboBoxCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGComponentCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGLabelCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGListCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGRadioButtonCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGSliderCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGSpinnerCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGTextFieldCD;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.AbstractElementsContentHandler;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGComponentImageParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SVGFormImageParser
extends SVGComponentImageParser {
    private static final String DIGITS = "_\\d+$";
    private static final String PREFIX = "^";
    private static final Pattern FORM_COMPONENT_ID_BUTTON = Pattern.compile("^button_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_LABEL = Pattern.compile("^label_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_RADIO = Pattern.compile("^radiobutton_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_CHECKBOX = Pattern.compile("^checkbox_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_COMBOBOX = Pattern.compile("^combobox_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_LIST = Pattern.compile("^list_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_SLIDER = Pattern.compile("^slider_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_SPINNER = Pattern.compile("^spinner_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_TEXTFIELD = Pattern.compile("^textfield_\\d+$");

    public static synchronized void parseSVGForm(InputStream inputStream, final DesignComponent designComponent) {
        final SVGFormComponent[] sVGFormComponentArray = SVGFormImageParser.getFormComponents(inputStream);
        if (sVGFormComponentArray != null) {
            designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    HashSet hashSet = new HashSet(designComponent.getComponents());
                    DescriptorRegistry descriptorRegistry = designComponent.getDocument().getDescriptorRegistry();
                    for (DesignComponent designComponent2 : hashSet) {
                        if (!descriptorRegistry.isInHierarchy(SVGComponentCD.TYPEID, designComponent2.getType())) continue;
                        designComponent.getDocument().deleteComponent(designComponent2);
                    }
                    for (SVGFormComponent sVGFormComponent : sVGFormComponentArray) {
                        DesignComponent designComponent3 = sVGFormComponent.createComponent(designComponent);
                        designComponent.addComponent(designComponent3);
                    }
                }
            });
        }
    }

    public void parse(InputStream inputStream, DesignComponent designComponent) {
        SVGFormImageParser.parseSVGForm(inputStream, designComponent);
    }

    private static SVGFormComponent[] getFormComponents(InputStream inputStream) {
        NamedElementsContentHandler namedElementsContentHandler = new NamedElementsContentHandler();
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(namedElementsContentHandler);
            xMLReader.setEntityResolver(namedElementsContentHandler);
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (IOException iOException) {
            Debug.warning((Object[])new Object[]{iOException});
        }
        catch (SAXException sAXException) {
            Debug.warning((Object[])new Object[]{sAXException});
        }
        return namedElementsContentHandler.getFoundElements();
    }

    public static final String[][] getComponentsInformation(InputStream inputStream) {
        SVGFormComponent[] sVGFormComponentArray = SVGFormImageParser.getFormComponents(inputStream);
        String[][] stringArray = new String[sVGFormComponentArray.length][2];
        for (int i = 0; i < sVGFormComponentArray.length; ++i) {
            stringArray[i][1] = sVGFormComponentArray[i].getId();
            stringArray[i][0] = MidpTypes.getSimpleClassName((TypeID)sVGFormComponentArray[i].getTypeID());
        }
        return stringArray;
    }

    private static class NamedElementsContentHandler
    extends AbstractElementsContentHandler {
        private ArrayList<SVGFormComponent> foundElements = new ArrayList();

        public SVGFormComponent[] getFoundElements() {
            return this.foundElements.toArray(new SVGFormComponent[this.foundElements.size()]);
        }

        public final void resetFoundElements() {
            this.foundElements.clear();
        }

        public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4 = attributes.getValue("id");
            if (string4 == null) {
                return;
            }
            if (FORM_COMPONENT_ID_BUTTON.matcher(string4).find()) {
                this.foundElements.add(SVGFormComponent.create(string4, SVGButtonCD.TYPEID));
            } else if (FORM_COMPONENT_ID_CHECKBOX.matcher(string4).find()) {
                this.foundElements.add(SVGFormComponent.create(string4, SVGCheckBoxCD.TYPEID));
            } else if (FORM_COMPONENT_ID_COMBOBOX.matcher(string4).find()) {
                this.foundElements.add(SVGFormComponent.create(string4, SVGComboBoxCD.TYPEID));
            } else if (FORM_COMPONENT_ID_LABEL.matcher(string4).find()) {
                this.foundElements.add(SVGFormComponent.create(string4, SVGLabelCD.TYPEID));
            } else if (FORM_COMPONENT_ID_LIST.matcher(string4).find()) {
                this.foundElements.add(SVGFormComponent.create(string4, SVGListCD.TYPEID));
            } else if (FORM_COMPONENT_ID_RADIO.matcher(string4).find()) {
                this.foundElements.add(SVGFormComponent.create(string4, SVGRadioButtonCD.TYPEID));
            } else if (FORM_COMPONENT_ID_SLIDER.matcher(string4).find()) {
                this.foundElements.add(SVGFormComponent.create(string4, SVGSliderCD.TYPEID));
            } else if (FORM_COMPONENT_ID_SPINNER.matcher(string4).find()) {
                this.foundElements.add(SVGFormComponent.create(string4, SVGSpinnerCD.TYPEID));
            } else if (FORM_COMPONENT_ID_TEXTFIELD.matcher(string4).find()) {
                this.foundElements.add(SVGFormComponent.create(string4, SVGTextFieldCD.TYPEID));
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
        }
    }

    private static abstract class SVGFormComponent {
        private String id;
        private TypeID type;

        private static SVGFormComponent create(String string, final TypeID typeID) {
            return new SVGFormComponent(string, typeID){

                DesignComponent createComponent(DesignComponent designComponent) {
                    DesignComponent designComponent2 = designComponent.getDocument().createComponent(typeID);
                    designComponent2.writeProperty("id", MidpTypes.createStringValue((String)this.getId()));
                    return designComponent2;
                }
            };
        }

        SVGFormComponent(String string, TypeID typeID) {
            this.type = typeID;
            this.id = string;
        }

        abstract DesignComponent createComponent(DesignComponent var1);

        String getId() {
            return this.id;
        }

        TypeID getTypeID() {
            return this.type;
        }
    }
}

