/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.firefox;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.netbeans.modules.web.client.tools.api.FirefoxBrowserUtils;
import org.netbeans.modules.web.client.tools.firefox.Log;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FFExtensionManager {
    private static final long BUTTON_DELAY = 10000L;
    private static final long FIREFOX_CHECK_PERIOD = 700L;
    private static final String PROFILE_LOCK_WINDOWS = "parent.lock";
    private static final String PROFILE_LOCK = "lock";
    private static final String FIREBUG_MIN_VERSION = "1.1.0b12";
    private static final String EXTENSION_CACHE = "extensions.cache";
    private static final String UNINSTALL_KEYWORD = "needs-uninstall";
    private static final String INSTALL_KEYWORD = "needs-install";
    private static final String FIREBUG_EXTENSION_ID = "firebug@software.joehewitt.com";
    private static final String FIREBUG_EXTENSION_PATH = "modules/ext/firebug-1.1.0b12.xpi";
    private static final String FIREFOX_EXTENSION_ID = "netbeans-firefox-extension@netbeans.org";
    private static final String FIREFOX_EXTENSION_PATH = "modules/ext/netbeans-firefox-extension.xpi";
    private static final String CHECKSUM_FILENAME = "netbeans-firefox-extension.jar.MD5";

    public static boolean installFirefoxExtensions(HtmlBrowser.Factory factory) {
        File file;
        File file2 = FirefoxBrowserUtils.getDefaultProfile();
        if (file2 == null) {
            Log.getLogger().severe("Could not find Firefox default profile.  Firefox debugging not available.");
            return false;
        }
        if (!FirefoxBrowserUtils.isSupportedFirefox((HtmlBrowser.Factory)factory, (File)file2)) {
            JButton jButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(FFExtensionManager.class, (String)"OK_BUTTON"));
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(FFExtensionManager.class, (String)"FIREFOX_VERSION_MSG"), NbBundle.getMessage(FFExtensionManager.class, (String)"FIREFOX_VERSION_TITLE"), -1, 0, new Object[]{jButton}, (Object)jButton);
            DialogDisplayer.getDefault().notify(notifyDescriptor);
            return false;
        }
        File file3 = InstalledFileLocator.getDefault().locate(FIREFOX_EXTENSION_PATH, "org.netbeans.modules.web.client.tools.firefox.extension", false);
        if (file3 == null) {
            Log.getLogger().severe("Could not find firefox extension in installation directory");
            return false;
        }
        File file4 = InstalledFileLocator.getDefault().locate(FIREBUG_EXTENSION_PATH, "org.netbeans.modules.web.client.tools.firefox.extension", false);
        if (file3 == null) {
            Log.getLogger().severe("Could not find firebug extension in installation directory");
            return false;
        }
        boolean bl = FFExtensionManager.extensionRequiresInstall(factory, FIREFOX_EXTENSION_ID, null, file3, file2, true);
        boolean bl2 = FFExtensionManager.extensionRequiresInstall(factory, FIREBUG_EXTENSION_ID, FIREBUG_MIN_VERSION, file4, file2, false);
        if (!bl || !bl2) {
            boolean bl3;
            LinkedList<String> linkedList = new LinkedList<String>();
            if (!bl) {
                linkedList.add(FIREFOX_EXTENSION_ID);
            }
            if (!bl2) {
                linkedList.add(FIREBUG_EXTENSION_ID);
            }
            if (!(bl3 = FFExtensionManager.checkExtensionInstall(linkedList, file2))) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(FFExtensionManager.class, (String)"FIREFOX_NOT_RESTARTED_MSG"), 0);
                message.setTitle(NbBundle.getMessage(FFExtensionManager.class, (String)"FIREFOX_NOT_RESTARTED_TITLE"));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return false;
            }
        }
        boolean bl4 = true;
        if (bl || bl2) {
            String string = Utilities.isMac() ? NbBundle.getMessage(FFExtensionManager.class, (String)"INSTALL_EXTENSIONS_MSG_MACOS") : NbBundle.getMessage(FFExtensionManager.class, (String)"INSTALL_EXTENSIONS_MSG");
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, NbBundle.getMessage(FFExtensionManager.class, (String)"INSTALL_EXTENSIONS_TITLE"), 2, 3);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (object != NotifyDescriptor.OK_OPTION) {
                return false;
            }
            if (FFExtensionManager.isFirefoxRunning(file2)) {
                boolean bl5;
                boolean bl6 = bl5 = !FFExtensionManager.displayFirefoxRunningDialog(file2);
                if (bl5) {
                    return false;
                }
            }
        }
        if (bl) {
            bl4 &= FFExtensionManager.installExtension(file2, file3, FIREFOX_EXTENSION_ID);
        }
        if (bl2) {
            bl4 &= FFExtensionManager.installExtension(file2, file4, FIREBUG_EXTENSION_ID);
        }
        if (bl4 && (bl || bl2) && (file = new File(file2, "extensions.rdf")).exists()) {
            file.delete();
        }
        return bl4;
    }

    public static boolean extensionRequiresInstall(HtmlBrowser.Factory factory, String string, String string2, File file, File file2, boolean bl) {
        File file3 = new File(file2, "extensions" + File.separator + string);
        String string3 = FFExtensionManager.getVersion(file3);
        boolean bl2 = FFExtensionManager.checkExtensionCache(string, file3, INSTALL_KEYWORD);
        if (bl2) {
            return false;
        }
        return FFExtensionManager.extensionUpdateRequired(string3, string2) || bl && !FFExtensionManager.checkExtensionChecksum(file, file2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean installExtension(File file, File file2, String string) {
        block13: {
            File file3;
            File file4;
            block14: {
                file4 = new File(file, "extensions" + File.separator + string);
                file3 = null;
                if (file4.exists()) {
                    String string2 = string + "-tmp";
                    do {
                        string2 = string2 + "0";
                    } while ((file3 = new File(file4.getParentFile(), string2)).exists());
                    if (!file4.renameTo(file3)) {
                        Log.getLogger().warning("Could not create backup for existing extension: " + string);
                        FFExtensionManager.rmDir(file4);
                        file3 = null;
                    }
                }
                boolean bl = false;
                try {
                    FFExtensionManager.extractFiles(file2, file4);
                    bl = true;
                    if (file3 == null) break block13;
                    if (!bl) break block14;
                }
                catch (IOException iOException) {
                    boolean bl2;
                    block15: {
                        block16: {
                            try {
                                Log.getLogger().log(Level.SEVERE, "Could not copy extension: " + string, iOException);
                                bl2 = false;
                                if (file3 == null) break block15;
                                if (!bl) break block16;
                            }
                            catch (Throwable throwable) {
                                if (file3 != null) {
                                    if (bl) {
                                        FFExtensionManager.rmDir(file3);
                                    } else {
                                        FFExtensionManager.rmDir(file4);
                                        boolean bl3 = file3.renameTo(file4);
                                        if (!bl3) {
                                            Log.getLogger().warning("Could not restore old extension: " + string);
                                        }
                                    }
                                }
                                throw throwable;
                            }
                            FFExtensionManager.rmDir(file3);
                            break block15;
                        }
                        FFExtensionManager.rmDir(file4);
                        boolean bl4 = file3.renameTo(file4);
                        if (!bl4) {
                            Log.getLogger().warning("Could not restore old extension: " + string);
                        }
                    }
                    return bl2;
                }
                FFExtensionManager.rmDir(file3);
                break block13;
            }
            FFExtensionManager.rmDir(file4);
            boolean bl = file3.renameTo(file4);
            if (!bl) {
                Log.getLogger().warning("Could not restore old extension: " + string);
            }
        }
        return true;
    }

    private static void rmDir(File file) {
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                FFExtensionManager.rmDir(file2);
            }
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractFiles(File file, File file2) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                File file3;
                ZipEntry zipEntry = enumeration.nextElement();
                String string = zipEntry.getName();
                if (zipEntry.isDirectory()) {
                    file3 = new File(file2, string);
                    file3.mkdirs();
                    continue;
                }
                file3 = new File(file2, string);
                if (file3.exists() && file3.isDirectory()) {
                    throw new IOException("Cannot write normal file to existing directory with the same path");
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                try {
                    int n;
                    byte[] byArray = new byte[4096];
                    while ((n = inputStream.read(byArray)) >= 0) {
                        bufferedOutputStream.write(byArray, 0, n);
                    }
                }
                finally {
                    bufferedOutputStream.close();
                    inputStream.close();
                }
            }
        }
        finally {
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean displayFirefoxRunningDialog(final File file) {
        String string = NbBundle.getMessage(FFExtensionManager.class, (String)"FIREFOX_RUNNING_MSG");
        String string2 = NbBundle.getMessage(FFExtensionManager.class, (String)"FIREFOX_RUNNING_TITLE");
        final JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(FFExtensionManager.class, (String)"INSTALL_BUTTON"));
        jButton.setEnabled(false);
        JButton jButton2 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)NbBundle.getMessage(FFExtensionManager.class, (String)"CANCEL_BUTTON"));
        Object[] objectArray = new Object[]{jButton, jButton2};
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)string, string2, true, objectArray, (Object)jButton2, 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[]{jButton2});
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        final boolean[] blArray = new boolean[]{true};
        TimerTask timerTask = new TimerTask(){

            public void run() {
                if (dialog.isVisible() && !FFExtensionManager.isFirefoxRunning(file)) {
                    blArray[0] = false;
                    dialog.setVisible(false);
                    this.cancel();
                }
            }
        };
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                blArray[0] = false;
                dialog.setVisible(false);
            }
        });
        TimerTask timerTask2 = new TimerTask(){

            public void run() {
                jButton.setEnabled(true);
            }
        };
        Timer timer = new Timer();
        timer.schedule(timerTask2, 10000L);
        Timer timer2 = new Timer();
        timer2.schedule(timerTask, 700L, 700L);
        try {
            dialog.setVisible(true);
        }
        finally {
            dialog.dispose();
            timer.cancel();
            timer2.cancel();
        }
        return !blArray[0];
    }

    private static boolean isFirefoxRunning(File file) {
        if (Utilities.isWindows()) {
            return new File(file, PROFILE_LOCK_WINDOWS).exists();
        }
        if (Utilities.isMac()) {
            return false;
        }
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!string.equals(PROFILE_LOCK)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean extensionUpdateRequired(String string, String string2) {
        if (string == null) {
            return true;
        }
        if (string2 == null) {
            return false;
        }
        List<Integer> list = FFExtensionManager.getVersionParts(string);
        List<Integer> list2 = FFExtensionManager.getVersionParts(string2);
        for (int i = 0; i < Math.max(list.size(), list2.size()); ++i) {
            int n;
            int n2 = i >= list.size() ? 0 : list.get(i);
            int n3 = n = i >= list2.size() ? 0 : list2.get(i);
            if (n2 < n) {
                return true;
            }
            if (n2 <= n) continue;
            return false;
        }
        return false;
    }

    private static List<Integer> getVersionParts(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.contains("b")) {
                int n = string2.indexOf("b");
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1, string2.length());
                arrayList.add(new Integer(Integer.valueOf(string3) - 1));
                arrayList.add(Integer.valueOf(string4));
                continue;
            }
            arrayList.add(Integer.valueOf(string2));
        }
        return arrayList;
    }

    /*
     * Exception decompiling
     */
    private static boolean checkExtensionChecksum(File var0, File var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 24[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getVersion(File file) {
        File file2 = new File(file, "install.rdf");
        if (file2.isFile()) {
            Object object;
            Object object2;
            Node node;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = null;
            Document document = null;
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
                document = documentBuilder.parse(file2);
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.WARNING, "Unexpected exception", exception);
                return null;
            }
            Node node2 = null;
            for (node = document.getDocumentElement().getFirstChild(); node2 == null && node != null; node = node.getNextSibling()) {
                object2 = node.getNodeName();
                Object object3 = object2 = object2 == null ? "" : ((String)object2).toLowerCase();
                if (!((String)object2).equals("description") && !((String)object2).equals("rdf:description")) continue;
                Node node3 = node.getAttributes().getNamedItem("about");
                if (node3 == null) {
                    node3 = node.getAttributes().getNamedItem("RDF:about");
                }
                if (node3 == null) continue;
                object = node3.getNodeValue();
                Object object4 = object = object == null ? "" : ((String)object).toLowerCase();
                if (!((String)object).equals("urn:mozilla:install-manifest")) continue;
                node2 = node;
            }
            if (node2 == null) {
                return null;
            }
            node = node2.getAttributes().getNamedItem("em:version");
            if (node != null) {
                return node.getNodeValue();
            }
            object2 = node2.getChildNodes();
            for (int i = 0; i < object2.getLength(); ++i) {
                object = object2.item(i);
                String string = object.getNodeName();
                String string2 = string = string == null ? "" : string.toLowerCase();
                if (!string.equals("em:version")) continue;
                return object.getTextContent();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkExtensionInstall(List<String> list, File file) {
        File file2 = new File(file, EXTENSION_CACHE);
        if (file2.exists() && file2.isFile()) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file2));
                while (bufferedReader.ready() && list.size() > 0) {
                    String[] stringArray;
                    String string = bufferedReader.readLine();
                    if (string == null) continue;
                    for (String string2 : stringArray = string.split("\\s")) {
                        if (!list.contains(string2)) continue;
                        list.remove(string2);
                    }
                }
                boolean bl = list.isEmpty();
                return bl;
            }
            catch (IOException iOException) {
                Log.getLogger().log(Level.WARNING, "Error reading " + file2.getAbsolutePath(), iOException);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        Log.getLogger().log(Level.WARNING, "Unexpected exception", iOException);
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkExtensionCache(String string, File file, String string2) {
        File file2 = new File(file, EXTENSION_CACHE);
        if (file2.exists() && file2.isFile()) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file2));
                boolean bl = false;
                while (bufferedReader.ready() && !bl) {
                    String[] stringArray;
                    String string3 = bufferedReader.readLine();
                    if (string3 == null) continue;
                    for (String string4 : stringArray = string3.split("\\s")) {
                        if (string4.equals(string)) {
                            bl = true;
                            continue;
                        }
                        if (!bl || !string4.equals(string2)) continue;
                        boolean bl2 = true;
                        return bl2;
                    }
                }
            }
            catch (IOException iOException) {
                Log.getLogger().log(Level.WARNING, "Error reading " + file2.getAbsolutePath(), iOException);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        Log.getLogger().log(Level.WARNING, "Unexpected exception", iOException);
                    }
                }
            }
        }
        return false;
    }
}

