/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.modules.j2ee.sun.api.ServerLocationManager;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.ide.j2ee.DeploymentManagerProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomainEditor {
    private static DeploymentManager dm;
    private static String SAMPLE_DATASOURCE;
    private static String SAMPLE_CONNPOOL;
    private static String NBPROFILERNAME;
    private static String CONST_USER;
    private static String CONST_PASSWORD;
    private static String CONST_URL;
    private static String CONST_LOWER_DATABASE_NAME;
    private static String CONST_LOWER_PORT_NUMBER;
    private static String CONST_DATABASE_NAME;
    private static String CONST_PORT_NUMBER;
    private static String CONST_SID;
    private static String CONST_SERVER_NAME;
    private static String CONST_DRIVER_CLASS;
    private static String CONST_NAME;
    private static String CONST_JVM_OPTIONS;
    private static String CONST_DERBY_CONN_ATTRS;
    static final String[] sysDatasources;

    public DomainEditor(DeploymentManager deploymentManager) {
        dm = deploymentManager;
    }

    public String getDomainLocation() {
        DeploymentManagerProperties deploymentManagerProperties = new DeploymentManagerProperties(dm);
        String string = deploymentManagerProperties.getLocation() + "/" + deploymentManagerProperties.getDomainName() + "/config/domain.xml";
        return string;
    }

    public Document getDomainDocument() {
        String string = this.getDomainLocation();
        Document document = this.getDomainDocument(string);
        return document;
    }

    public Document getDomainDocument(String string) {
        Document document = this.loadDomainScriptFile(string);
        return document;
    }

    public boolean addProfilerElements(Document document, String string, String[] stringArray) {
        String string2 = this.getDomainLocation();
        this.removeProfiler(document);
        if (string != null || stringArray != null) {
            NodeList nodeList;
            Node node;
            Element element = document.createElement("profiler");
            element.setAttribute("enabled", "true");
            element.setAttribute(CONST_NAME, NBPROFILERNAME);
            if (string != null) {
                element.setAttribute("native-library-path", string);
            }
            File file = ((SunDeploymentManagerInterface)this.getDeploymentManager()).getPlatformRoot();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    node = document.createElement(CONST_JVM_OPTIONS);
                    Text text = document.createTextNode(this.formatJvmOption(stringArray[i], file));
                    node.appendChild(text);
                    element.appendChild(node);
                }
            }
            if ((nodeList = document.getElementsByTagName("java-config")) == null || nodeList.getLength() == 0) {
                System.err.println("ConfigFilesUtils: cannot find 'java-config' section in domain config file " + string2);
                return false;
            }
            node = nodeList.item(0);
            if (node.getFirstChild() != null) {
                node.insertBefore(element, node.getFirstChild());
            } else {
                node.appendChild(element);
            }
        }
        return this.saveDomainScriptFile(document, string2);
    }

    public boolean removeProfilerElements(Document document) {
        boolean bl = this.removeProfiler(document);
        if (bl) {
            return this.saveDomainScriptFile(document, this.getDomainLocation());
        }
        return true;
    }

    private boolean removeProfiler(Document document) {
        NodeList nodeList = document.getElementsByTagName("profiler");
        if (nodeList != null && nodeList.getLength() > 0) {
            Node node;
            int n;
            Vector<Node> vector = new Vector<Node>();
            for (n = 0; n < nodeList.getLength(); ++n) {
                node = nodeList.item(n);
                Node node2 = node.getAttributes().getNamedItem(CONST_NAME);
                if (node2 == null || !node2.getNodeValue().equals(NBPROFILERNAME)) continue;
                vector.add(node);
            }
            for (n = 0; n < vector.size(); ++n) {
                node = (Node)vector.get(n);
                node.getParentNode().removeChild(node);
            }
            return true;
        }
        return false;
    }

    public String[] getHttpProxyOptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Document document = this.getDomainDocument();
        NodeList nodeList = document.getElementsByTagName("java-config");
        if (nodeList == null || nodeList.getLength() == 0) {
            return arrayList.toArray(new String[arrayList.size()]);
        }
        NodeList nodeList2 = document.getElementsByTagName(CONST_JVM_OPTIONS);
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Node node;
            String string;
            Node node2 = nodeList2.item(i);
            if (!node2.hasChildNodes() || (string = (node = node2.getFirstChild()).getNodeValue()).indexOf("-Dhttp.proxyHost=") == -1 && string.indexOf("-Dhttp.proxyPort=") == -1 && string.indexOf("-Dhttps.proxyHost=") == -1 && string.indexOf("-Dhttps.proxyPort=") == -1 && string.indexOf("-Dhttp.nonProxyHosts=") == -1) continue;
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public boolean setHttpProxyOptions(String[] stringArray) {
        Document document = this.getDomainDocument();
        NodeList nodeList = document.getElementsByTagName("java-config");
        if (nodeList == null || nodeList.getLength() == 0) {
            return false;
        }
        this.removeProxyOptions(document, nodeList.item(0));
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Element element = document.createElement(CONST_JVM_OPTIONS);
            Text text = document.createTextNode(string);
            element.appendChild(text);
            nodeList.item(0).appendChild(element);
        }
        return this.saveDomainScriptFile(document, this.getDomainLocation(), false);
    }

    private boolean removeProxyOptions(Document document, Node node) {
        int n;
        NodeList nodeList = document.getElementsByTagName(CONST_JVM_OPTIONS);
        Vector<Node> vector = new Vector<Node>();
        for (n = 0; n < nodeList.getLength(); ++n) {
            Node node2;
            String string;
            Node node3 = nodeList.item(n);
            if (!node3.hasChildNodes() || (string = (node2 = node3.getFirstChild()).getNodeValue()).indexOf("-Dhttp.proxyHost=") == -1 && string.indexOf("-Dhttp.proxyPort=") == -1 && string.indexOf("-Dhttps.proxyHost=") == -1 && string.indexOf("-Dhttps.proxyPort=") == -1 && string.indexOf("-Dhttp.nonProxyHosts=") == -1) continue;
            vector.add(node3);
        }
        for (n = 0; n < vector.size(); ++n) {
            node.removeChild((Node)vector.get(n));
        }
        return this.saveDomainScriptFile(document, this.getDomainLocation(), false);
    }

    private Document loadDomainScriptFile(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                    StringReader stringReader = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    InputSource inputSource = new InputSource(stringReader);
                    inputSource.setPublicId(string);
                    inputSource.setSystemId(string2);
                    return inputSource;
                }
            });
            return documentBuilder.parse(new File(string));
        }
        catch (Exception exception) {
            System.err.println("ConfigFilesUtils: unable to parse domain config file " + string);
            return null;
        }
    }

    private boolean saveDomainScriptFile(Document document, String string) {
        return this.saveDomainScriptFile(document, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveDomainScriptFile(Document document, String string, boolean bl) {
        boolean bl2 = false;
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string);
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                if (bl) {
                    transformer.setOutputProperty("indent", "yes");
                }
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("doctype-public", document.getDoctype().getPublicId());
                transformer.setOutputProperty("doctype-system", document.getDoctype().getSystemId());
                transformer.setOutputProperty("omit-xml-declaration", "no");
                DOMSource dOMSource = new DOMSource(document);
                StreamResult streamResult = new StreamResult(fileWriter);
                transformer.transform(dOMSource, streamResult);
                bl2 = true;
            }
            catch (Exception exception) {
                System.err.println("ConfigFilesUtils: Unable to save domain config file " + string);
                bl2 = false;
            }
        }
        catch (IOException iOException) {
            System.err.println("ConfigFilesUtils: cannot create output stream for domain config file " + string);
            bl2 = false;
        }
        finally {
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (IOException iOException) {
                System.err.println("SunAS8IntegrationProvider: cannot close output stream for " + string);
            }
        }
        return bl2;
    }

    private String formatJvmOption(String string, File file) {
        if (string.indexOf("\"") != -1) {
            if (string.indexOf("\\\"") != -1 && string.indexOf("-agentpath") != -1) {
                String string2 = string.replaceAll("\\\\\"", "#");
                string2 = string2.replaceAll("\\\"", "");
                string2 = string2.replaceAll("#", "\"");
                String string3 = System.getProperty("os.name");
                if (string3.startsWith("Mac OS") || ServerLocationManager.isGlassFish((File)file)) {
                    string2 = "\"" + string2.replaceAll("\\\"", "\\\\\"") + "\"";
                }
                return string2;
            }
            return string.replace('\"', ' ');
        }
        return string;
    }

    public HashMap getSunDatasourcesFromXml() {
        HashMap hashMap = new HashMap();
        Document document = this.getDomainDocument();
        HashMap hashMap2 = this.getDataSourcesAttrMap(document);
        HashMap hashMap3 = this.getConnPoolsNodeMap(document);
        hashMap2.keySet().removeAll(Arrays.asList(sysDatasources));
        String[] stringArray = hashMap2.keySet().toArray(new String[hashMap2.size()]);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            HashMap<String, String> hashMap4 = new HashMap<String, String>();
            NamedNodeMap namedNodeMap = (NamedNodeMap)hashMap2.get(string);
            String string2 = namedNodeMap.getNamedItem("pool-name").getNodeValue();
            Node node = (Node)hashMap3.get(string2);
            NamedNodeMap namedNodeMap2 = node.getAttributes();
            String string3 = namedNodeMap2.getNamedItem("datasource-classname").getNodeValue();
            String string4 = namedNodeMap2.getNamedItem("res-type").getNodeValue();
            Element element = (Element)node;
            NodeList nodeList = element.getElementsByTagName("property");
            HashMap<String, String> hashMap5 = new HashMap<String, String>();
            for (int j = 0; j < nodeList.getLength(); ++j) {
                Node node2 = nodeList.item(j);
                NamedNodeMap namedNodeMap3 = node2.getAttributes();
                for (int k = 0; k < namedNodeMap3.getLength(); ++k) {
                    String string5 = namedNodeMap3.getNamedItem(CONST_NAME).getNodeValue();
                    String string6 = namedNodeMap3.getNamedItem("value").getNodeValue();
                    if (string5.equalsIgnoreCase(CONST_USER)) {
                        hashMap4.put(CONST_USER, string6);
                        continue;
                    }
                    if (string5.equalsIgnoreCase(CONST_PASSWORD)) {
                        hashMap4.put(CONST_PASSWORD, string6);
                        continue;
                    }
                    if (string5.equalsIgnoreCase(CONST_URL)) {
                        hashMap4.put(CONST_URL, string6);
                        continue;
                    }
                    if (string5.equalsIgnoreCase(CONST_SERVER_NAME)) {
                        hashMap4.put(CONST_SERVER_NAME, string6);
                        continue;
                    }
                    hashMap5.put(string5, string6);
                }
            }
            hashMap4.put(CONST_LOWER_DATABASE_NAME, (String)hashMap5.get(CONST_LOWER_DATABASE_NAME));
            hashMap4.put(CONST_PORT_NUMBER, (String)hashMap5.get(CONST_PORT_NUMBER));
            hashMap4.put(CONST_LOWER_PORT_NUMBER, (String)hashMap5.get(CONST_LOWER_PORT_NUMBER));
            hashMap4.put(CONST_DATABASE_NAME, (String)hashMap5.get(CONST_DATABASE_NAME));
            hashMap4.put(CONST_SID, (String)hashMap5.get(CONST_SID));
            hashMap4.put(CONST_DRIVER_CLASS, (String)hashMap5.get(CONST_DRIVER_CLASS));
            hashMap4.put(CONST_DERBY_CONN_ATTRS, (String)hashMap5.get(CONST_DERBY_CONN_ATTRS));
            hashMap4.put("dsClassName", string3);
            hashMap4.put("resType", string4);
            hashMap.put(string, hashMap4);
        }
        return hashMap;
    }

    public HashMap getConnPoolsFromXml() {
        HashMap hashMap = new HashMap();
        Document document = this.getDomainDocument();
        HashMap hashMap2 = this.getConnPoolsNodeMap(document);
        String[] stringArray = hashMap2.keySet().toArray(new String[hashMap2.size()]);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            HashMap<String, String> hashMap3 = new HashMap<String, String>();
            Node node = (Node)hashMap2.get(string);
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string2 = namedNodeMap.getNamedItem("datasource-classname").getNodeValue();
            String string3 = namedNodeMap.getNamedItem("res-type").getNodeValue();
            Element element = (Element)node;
            NodeList nodeList = element.getElementsByTagName("property");
            HashMap<String, String> hashMap4 = new HashMap<String, String>();
            for (int j = 0; j < nodeList.getLength(); ++j) {
                Node node2 = nodeList.item(j);
                NamedNodeMap namedNodeMap2 = node2.getAttributes();
                for (int k = 0; k < namedNodeMap2.getLength(); ++k) {
                    String string4 = namedNodeMap2.getNamedItem(CONST_NAME).getNodeValue();
                    String string5 = namedNodeMap2.getNamedItem("value").getNodeValue();
                    if (string4.equalsIgnoreCase(CONST_USER)) {
                        hashMap3.put(CONST_USER, string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase(CONST_PASSWORD)) {
                        hashMap3.put(CONST_PASSWORD, string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase(CONST_URL)) {
                        hashMap3.put(CONST_URL, string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase(CONST_SERVER_NAME)) {
                        hashMap3.put(CONST_SERVER_NAME, string5);
                        continue;
                    }
                    hashMap4.put(string4, string5);
                }
            }
            hashMap3.put(CONST_LOWER_DATABASE_NAME, (String)hashMap4.get(CONST_LOWER_DATABASE_NAME));
            hashMap3.put(CONST_PORT_NUMBER, (String)hashMap4.get(CONST_PORT_NUMBER));
            hashMap3.put(CONST_LOWER_PORT_NUMBER, (String)hashMap4.get(CONST_LOWER_PORT_NUMBER));
            hashMap3.put(CONST_DATABASE_NAME, (String)hashMap4.get(CONST_DATABASE_NAME));
            hashMap3.put(CONST_SID, (String)hashMap4.get(CONST_SID));
            hashMap3.put(CONST_DRIVER_CLASS, (String)hashMap4.get(CONST_DRIVER_CLASS));
            hashMap3.put(CONST_DERBY_CONN_ATTRS, (String)hashMap4.get(CONST_DERBY_CONN_ATTRS));
            hashMap3.put("dsClassName", string2);
            hashMap3.put("resType", string3);
            hashMap.put(string, hashMap3);
        }
        return hashMap;
    }

    public void createSampleDatasource() {
        Document document = this.getDomainDocument();
        this.updateWithSampleDataSource(document);
    }

    private HashMap getDataSourcesAttrMap(Document document) {
        HashMap<String, NamedNodeMap> hashMap = new HashMap<String, NamedNodeMap>();
        this.updateWithSampleDataSource(document);
        NodeList nodeList = document.getElementsByTagName("jdbc-resource");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = namedNodeMap.getNamedItem("jndi-name").getNodeValue();
            hashMap.put(string, namedNodeMap);
        }
        return hashMap;
    }

    private boolean updateWithSampleDataSource(Document document) {
        boolean bl = false;
        NodeList nodeList = document.getElementsByTagName("jdbc-resource");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = namedNodeMap.getNamedItem("jndi-name").getNodeValue();
            if (!string.equals(SAMPLE_DATASOURCE)) continue;
            bl = true;
        }
        if (!bl) {
            return this.createSampleDatasource(document);
        }
        return true;
    }

    private HashMap getConnPoolsNodeMap(Document document) {
        HashMap<String, Node> hashMap = new HashMap<String, Node>();
        NodeList nodeList = document.getElementsByTagName("jdbc-connection-pool");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = namedNodeMap.getNamedItem(CONST_NAME).getNodeValue();
            hashMap.put(string, node);
        }
        return hashMap;
    }

    public boolean createSampleDatasource(Document document) {
        Object object;
        Node node;
        Node node2;
        NodeList nodeList = document.getElementsByTagName("resources");
        NodeList nodeList2 = document.getElementsByTagName("server");
        if (nodeList == null || nodeList.getLength() == 0 || nodeList2 == null || nodeList2.getLength() == 0) {
            return true;
        }
        Node node3 = nodeList.item(0);
        HashMap hashMap = this.getConnPoolsNodeMap(document);
        if (!hashMap.containsKey(SAMPLE_CONNPOOL)) {
            node2 = (Node)hashMap.get("DerbyPool");
            node = node2.cloneNode(false);
            object = node.getAttributes();
            object.getNamedItem(CONST_NAME).setNodeValue(SAMPLE_CONNPOOL);
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put(CONST_SERVER_NAME, "localhost");
            hashMap2.put(CONST_PASSWORD, "app");
            hashMap2.put(CONST_USER, "app");
            hashMap2.put(CONST_DATABASE_NAME, "sample");
            hashMap2.put(CONST_PORT_NUMBER, "1527");
            hashMap2.put(CONST_URL, "jdbc:derby://localhost:1527/sample");
            Object[] objectArray = hashMap2.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                Element element = document.createElement("property");
                element.setAttribute(CONST_NAME, string);
                element.setAttribute("value", (String)hashMap2.get(string));
                node.appendChild(element);
            }
            node3.appendChild(node);
        }
        node2 = document.createElement("jdbc-resource");
        node2.setAttribute("jndi-name", SAMPLE_DATASOURCE);
        node2.setAttribute("pool-name", SAMPLE_CONNPOOL);
        node2.setAttribute("object-type", "user");
        node2.setAttribute("enabled", "true");
        if (node3.getFirstChild() != null) {
            node3.insertBefore(node2, node3.getFirstChild());
        } else {
            node3.appendChild(node2);
        }
        node = document.createElement("resource-ref");
        node.setAttribute("ref", SAMPLE_DATASOURCE);
        node.setAttribute("enabled", "true");
        object = nodeList2.item(0);
        if (object.getLastChild() != null) {
            object.insertBefore(node, object.getLastChild());
        } else {
            object.appendChild(node);
        }
        return this.saveDomainScriptFile(document, this.getDomainLocation());
    }

    public HashMap getAdminObjectResourcesFromXml() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Document document = this.getDomainDocument();
        NodeList nodeList = document.getElementsByTagName("admin-object-resource");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = namedNodeMap.getNamedItem("jndi-name").getNodeValue();
            String string2 = namedNodeMap.getNamedItem("res-type").getNodeValue();
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public DeploymentManager getDeploymentManager() {
        return dm;
    }

    static {
        SAMPLE_DATASOURCE = "jdbc/sample";
        SAMPLE_CONNPOOL = "SamplePool";
        NBPROFILERNAME = "NetBeansProfiler";
        CONST_USER = "User";
        CONST_PASSWORD = "Password";
        CONST_URL = "URL";
        CONST_LOWER_DATABASE_NAME = "databaseName";
        CONST_LOWER_PORT_NUMBER = "portNumber";
        CONST_DATABASE_NAME = "DatabaseName";
        CONST_PORT_NUMBER = "PortNumber";
        CONST_SID = "SID";
        CONST_SERVER_NAME = "serverName";
        CONST_DRIVER_CLASS = "driverClass";
        CONST_NAME = "name";
        CONST_JVM_OPTIONS = "jvm-options";
        CONST_DERBY_CONN_ATTRS = "connectionAttributes";
        sysDatasources = new String[]{"jdbc/__TimerPool", "jdbc/__CallFlowPool"};
    }
}

