/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.ws;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.netbeans.modules.websvc.serverapi.api.WSStackFeature;
import org.netbeans.modules.websvc.serverapi.api.WSUriDescriptor;
import org.netbeans.modules.websvc.serverapi.spi.WSStackSPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatJaxWsStack
implements WSStackSPI {
    private static final String[] WSIT_LIBS = new String[]{"shared/lib/webservices-rt.jar", "shared/lib/webservices-tools.jar"};
    private static final String KEYSTORE_LOCATION = "certs/server-keystore.jks";
    private static final String TRUSTSTORE_LOCATION = "certs/server-truststore.jks";
    private static final String KEYSTORE_CLIENT_LOCATION = "certs/client-keystore.jks";
    private static final String TRUSTSTORE_CLIENT_LOCATION = "certs/client-truststore.jks";
    private File catalinaHome;
    private String version;

    public TomcatJaxWsStack(File file) {
        this.catalinaHome = file;
        try {
            this.version = this.resolveImplementationVersion();
            if (this.version == null) {
                this.version = "2.1.4";
            }
        }
        catch (IOException iOException) {
            this.version = "2.1.4";
        }
    }

    public String getName() {
        return "stack_jax_ws";
    }

    public String getVersion() {
        return this.version;
    }

    public Set<String> getSupportedTools() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.isWsit()) {
            hashSet.add("tool_wsgen");
            hashSet.add("tool_wsimport");
        }
        if (this.isKeystore()) {
            hashSet.add("tool_keystore");
        }
        if (this.isTruststore()) {
            hashSet.add("tool_truststore");
        }
        if (this.isKeystoreClient()) {
            hashSet.add("tool_keystore_client");
        }
        if (this.isTruststoreClient()) {
            hashSet.add("tool_truststore_client");
        }
        return hashSet;
    }

    public File[] getToolClassPathEntries(String string) {
        if ("tool_wsgen".equals(string) || "tool_wsimport".equals(string)) {
            if (this.isWsit()) {
                File[] fileArray = new File[WSIT_LIBS.length];
                for (int i = 0; i < WSIT_LIBS.length; ++i) {
                    fileArray[i] = new File(this.catalinaHome, WSIT_LIBS[i]);
                }
                return fileArray;
            }
        } else {
            if ("tool_keystore".equals(string) && this.isKeystore()) {
                return new File[]{new File(this.catalinaHome, KEYSTORE_LOCATION)};
            }
            if ("tool_truststore".equals(string) && this.isTruststore()) {
                return new File[]{new File(this.catalinaHome, TRUSTSTORE_LOCATION)};
            }
            if ("tool_keystore_client".equals(string) && this.isKeystoreClient()) {
                return new File[]{new File(this.catalinaHome, KEYSTORE_CLIENT_LOCATION)};
            }
            if ("tool_truststore_client".equals(string) && this.isTruststoreClient()) {
                return new File[]{new File(this.catalinaHome, TRUSTSTORE_CLIENT_LOCATION)};
            }
        }
        return new File[0];
    }

    public WSUriDescriptor getServiceUriDescriptor() {
        return new WSUriDescriptor(){

            public String getServiceUri(String string, String string2, String string3, boolean bl) {
                return string + "/" + string2;
            }

            public String getDescriptorUri(String string, String string2, String string3, boolean bl) {
                return this.getServiceUri(string, string2, string3, bl) + "?wsdl";
            }

            public String getTesterPageUri(String string, String string2, String string3, boolean bl) {
                return string + "/" + string2;
            }
        };
    }

    public Set<WSStackFeature> getServiceFeatures() {
        HashSet<WSStackFeature> hashSet = new HashSet<WSStackFeature>();
        hashSet.add(WSStackFeature.TESTER_PAGE);
        if (this.isWsit()) {
            hashSet.add(WSStackFeature.WSIT);
        }
        return hashSet;
    }

    private boolean isWsit() {
        boolean bl = true;
        for (int i = 0; i < WSIT_LIBS.length; ++i) {
            if (new File(this.catalinaHome, WSIT_LIBS[i]).exists()) continue;
            bl = false;
        }
        return bl;
    }

    private boolean isKeystore() {
        return new File(this.catalinaHome, KEYSTORE_LOCATION).exists();
    }

    private boolean isKeystoreClient() {
        return new File(this.catalinaHome, KEYSTORE_CLIENT_LOCATION).exists();
    }

    private boolean isTruststore() {
        return new File(this.catalinaHome, TRUSTSTORE_LOCATION).exists();
    }

    private boolean isTruststoreClient() {
        return new File(this.catalinaHome, TRUSTSTORE_CLIENT_LOCATION).exists();
    }

    private String resolveImplementationVersion() throws IOException {
        JarFile jarFile;
        JarEntry jarEntry;
        File file = new File(this.catalinaHome, "shared/lib/webservices-tools.jar");
        if (file.exists() && (jarEntry = (jarFile = new JarFile(file)).getJarEntry("com/sun/tools/ws/version.properties")) != null) {
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = null;
            String string2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                String string3 = string.trim();
                if (!string3.startsWith("major-version=")) continue;
                string2 = string3.substring(14);
            }
            bufferedReader.close();
            return string2;
        }
        return null;
    }
}

