/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.file;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexpFileFilter
implements FileFilter,
FilenameFilter {
    private String filterText;
    private Pattern pattern;
    private boolean caseSensitive;

    public RegexpFileFilter(String string, boolean bl) {
        this.caseSensitive = bl;
        if (!string.contains("?") && !string.contains("*")) {
            this.filterText = bl ? string : string.toLowerCase();
        } else {
            string = RegexpFileFilter.removeRegexpEscapes(string);
            string = string.replace(".", "\\.");
            string = string.replace("?", ".");
            this.filterText = string = string.replace("*", ".*");
            this.pattern = Pattern.compile(this.filterText, bl ? 0 : 2);
        }
    }

    public boolean accept(File file) {
        return this.accept(null, file.getName());
    }

    public boolean accept(File file, String string) {
        if (this.pattern == null) {
            return this.caseSensitive ? string.startsWith(this.filterText) : string.toLowerCase().startsWith(this.filterText);
        }
        Matcher matcher = this.pattern.matcher(string);
        return matcher.matches();
    }

    public static boolean onlyContainsWildcards(String string) {
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '*': 
                case '.': 
                case '?': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private static String removeRegexpEscapes(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    continue block3;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }
}

