/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.type;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.jumpto.type.TypeBrowser;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.jumpto.file.LazyListModel;
import org.netbeans.modules.jumpto.type.GoToPanel;
import org.netbeans.modules.jumpto.type.Models;
import org.netbeans.modules.jumpto.type.TypeProviderAccessor;
import org.netbeans.modules.jumpto.type.UiOptions;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class GoToTypeAction
extends AbstractAction
implements GoToPanel.ContentProvider,
LazyListModel.Filter {
    static final Logger LOGGER = Logger.getLogger(GoToTypeAction.class.getName());
    private SearchType nameKind;
    private static ListModel EMPTY_LIST_MODEL = new DefaultListModel();
    private static final RequestProcessor rp = new RequestProcessor("GoToTypeAction-RequestProcessor", 1);
    private Worker running;
    private RequestProcessor.Task task;
    private GoToPanel panel;
    private Dialog dialog;
    private JButton okButton;
    private final Collection<? extends TypeProvider> typeProviders;
    private final TypeBrowser.Filter typeFilter;
    private final String title;
    private static Pattern camelCasePattern = Pattern.compile("(?:\\p{javaUpperCase}(?:\\p{javaLowerCase}|\\p{Digit}|\\.|\\$)*){2,}");
    private Dimension initialDimension;

    public GoToTypeAction() {
        this(NbBundle.getMessage(GoToTypeAction.class, (String)"DLG_GoToType"), null, Lookup.getDefault().lookupAll(TypeProvider.class).toArray(new TypeProvider[0]));
    }

    public GoToTypeAction(String string, TypeBrowser.Filter filter, TypeProvider ... typeProviderArray) {
        super(NbBundle.getMessage(GoToTypeAction.class, (String)"TXT_GoToType"));
        this.putValue("PopupMenuText", NbBundle.getBundle(GoToTypeAction.class).getString("editor-popup-TXT_GoToType"));
        this.title = string;
        this.typeFilter = filter;
        this.typeProviders = Arrays.asList(typeProviderArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        TypeDescriptor typeDescriptor = this.getSelectedType();
        if (typeDescriptor != null) {
            typeDescriptor.open();
        }
    }

    public TypeDescriptor getSelectedType() {
        TypeDescriptor typeDescriptor = null;
        try {
            JEditorPane[] jEditorPaneArray;
            EditorCookie editorCookie;
            this.panel = new GoToPanel(this);
            this.dialog = this.createDialog(this.panel);
            Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
            String string = null;
            if (nodeArray.length > 0 && (editorCookie = (EditorCookie)nodeArray[0].getCookie(EditorCookie.class)) != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null && (string = Utilities.getSelectionOrIdentifier((JTextComponent)jEditorPaneArray[0])) != null && org.openide.util.Utilities.isJavaIdentifier((String)string)) {
                this.panel.setInitialText(string);
            }
            this.dialog.setVisible(true);
            typeDescriptor = this.panel.getSelectedType();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        return typeDescriptor;
    }

    public boolean isEnabled() {
        return OpenProjects.getDefault().getOpenProjects().length > 0;
    }

    public boolean accept(Object object) {
        return this.typeFilter == null ? true : this.typeFilter.accept((TypeDescriptor)object);
    }

    public void scheduleUpdate(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    public ListCellRenderer getListCellRenderer(JList jList) {
        return new Renderer(jList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListModel(GoToPanel goToPanel, String string) {
        if (this.okButton != null) {
            this.okButton.setEnabled(false);
        }
        if (this.running != null) {
            this.running.cancel();
            this.task.cancel();
            this.running = null;
        }
        if (string == null) {
            goToPanel.setModel(EMPTY_LIST_MODEL);
            return;
        }
        boolean bl = string.endsWith(" ");
        if ((string = string.trim()).length() == 0) {
            goToPanel.setModel(EMPTY_LIST_MODEL);
            return;
        }
        int n = GoToTypeAction.containsWildCard(string);
        this.nameKind = bl ? (goToPanel.isCaseSensitive() ? SearchType.EXACT_NAME : SearchType.CASE_INSENSITIVE_EXACT_NAME) : (GoToTypeAction.isAllUpper(string) && string.length() > 1 || GoToTypeAction.isCamelCase(string) ? SearchType.CAMEL_CASE : (n != -1 ? (goToPanel.isCaseSensitive() ? SearchType.REGEXP : SearchType.CASE_INSENSITIVE_REGEXP) : (goToPanel.isCaseSensitive() ? SearchType.PREFIX : SearchType.CASE_INSENSITIVE_PREFIX)));
        GoToTypeAction goToTypeAction = this;
        synchronized (goToTypeAction) {
            this.running = new Worker(string);
            this.task = rp.post((Runnable)this.running, 220);
            if (goToPanel.time != -1L) {
                LOGGER.fine("Worker posted after " + (System.currentTimeMillis() - goToPanel.time) + " ms.");
            }
        }
    }

    public void closeDialog() {
        this.dialog.setVisible(false);
        this.cleanup();
    }

    public boolean hasValidContent() {
        return this.okButton != null && this.okButton.isEnabled();
    }

    private static boolean isAllUpper(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isUpperCase(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static int containsWildCard(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '?' && string.charAt(i) != '*') continue;
            return i;
        }
        return -1;
    }

    private static boolean isCamelCase(String string) {
        return camelCasePattern.matcher(string).matches();
    }

    private Dialog createDialog(GoToPanel goToPanel) {
        this.okButton = new JButton(NbBundle.getMessage(GoToTypeAction.class, (String)"CTL_OK"));
        this.okButton.setEnabled(false);
        goToPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GoToTypeAction.class, (String)"AN_GoToType"));
        goToPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GoToTypeAction.class, (String)"AD_GoToType"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)goToPanel, this.title, true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, HelpCtx.DEFAULT_HELP, (ActionListener)new DialogButtonListener(goToPanel));
        dialogDescriptor.setClosingOptions(new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        int n = UiOptions.GoToTypeDialog.getWidth();
        int n2 = UiOptions.GoToTypeDialog.getHeight();
        if (n != -1 && n2 != -1) {
            dialog.setPreferredSize(new Dimension(n, n2));
        }
        Rectangle rectangle = org.openide.util.Utilities.getUsableScreenBounds();
        int n3 = rectangle.width * 9 / 10;
        int n4 = rectangle.height * 9 / 10;
        Dimension dimension = dialog.getPreferredSize();
        dimension.width = Math.min(dimension.width, n3);
        dimension.height = Math.min(dimension.height, n4);
        dialog.setBounds(org.openide.util.Utilities.findCenterBounds((Dimension)dimension));
        this.initialDimension = dimension;
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                GoToTypeAction.this.cleanup();
            }
        });
        return dialog;
    }

    private void cleanup() {
        if (this.dialog != null) {
            int n = this.dialog.getWidth();
            int n2 = this.dialog.getHeight();
            if (this.initialDimension != null && (this.initialDimension.width != n || this.initialDimension.height != n2)) {
                UiOptions.GoToTypeDialog.setHeight(n2);
                UiOptions.GoToTypeDialog.setWidth(n);
            }
            this.initialDimension = null;
            this.dialog.dispose();
            this.dialog = null;
            for (TypeProvider typeProvider : this.typeProviders) {
                typeProvider.cleanup();
            }
        }
    }

    private int compareStrings(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return string.compareTo(string2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeComparator
    implements Comparator<TypeDescriptor> {
        private TypeComparator() {
        }

        @Override
        public int compare(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
            int n = GoToTypeAction.this.compareStrings(typeDescriptor.getTypeName(), typeDescriptor2.getTypeName());
            if (n != 0) {
                return n;
            }
            n = GoToTypeAction.this.compareStrings(typeDescriptor.getOuterName(), typeDescriptor2.getOuterName());
            if (n != 0) {
                return n;
            }
            return GoToTypeAction.this.compareStrings(typeDescriptor.getContextName(), typeDescriptor2.getContextName());
        }
    }

    private class DialogButtonListener
    implements ActionListener {
        private GoToPanel panel;

        public DialogButtonListener(GoToPanel goToPanel) {
            this.panel = goToPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GoToTypeAction.this.okButton) {
                this.panel.setSelectedType();
            }
        }
    }

    private static class Renderer
    extends DefaultListCellRenderer
    implements ChangeListener {
        private MyPanel rendererComponent;
        private JLabel jlName = new JLabel();
        private JLabel jlPkg = new JLabel();
        private JLabel jlPrj = new JLabel();
        private int DARKER_COLOR_COMPONENT = 5;
        private int LIGHTER_COLOR_COMPONENT = 80;
        private Color fgColor;
        private Color fgColorLighter;
        private Color bgColor;
        private Color bgColorDarker;
        private Color bgSelectionColor;
        private Color fgSelectionColor;
        private JList jList;

        public Renderer(JList jList) {
            this.jList = jList;
            Container container = jList.getParent();
            if (container instanceof JViewport) {
                ((JViewport)container).addChangeListener(this);
                this.stateChanged(new ChangeEvent(container));
            }
            this.rendererComponent = new MyPanel();
            this.rendererComponent.setLayout(new BorderLayout());
            this.rendererComponent.add((Component)this.jlName, "West");
            this.rendererComponent.add((Component)this.jlPkg, "Center");
            this.rendererComponent.add((Component)this.jlPrj, "East");
            this.jlName.setOpaque(false);
            this.jlPkg.setOpaque(false);
            this.jlPrj.setOpaque(false);
            this.jlName.setFont(jList.getFont());
            this.jlPkg.setFont(jList.getFont());
            this.jlPrj.setFont(jList.getFont());
            this.jlPrj.setHorizontalAlignment(4);
            this.jlPrj.setHorizontalTextPosition(2);
            this.fgColor = jList.getForeground();
            this.fgColorLighter = new Color(Math.min(255, this.fgColor.getRed() + this.LIGHTER_COLOR_COMPONENT), Math.min(255, this.fgColor.getGreen() + this.LIGHTER_COLOR_COMPONENT), Math.min(255, this.fgColor.getBlue() + this.LIGHTER_COLOR_COMPONENT));
            this.bgColor = jList.getBackground();
            this.bgColorDarker = new Color(Math.abs(this.bgColor.getRed() - this.DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getGreen() - this.DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getBlue() - this.DARKER_COLOR_COMPONENT));
            this.bgSelectionColor = jList.getSelectionBackground();
            this.fgSelectionColor = jList.getSelectionForeground();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            int n2 = jList.getFixedCellHeight();
            int n3 = jList.getFixedCellWidth() - 1;
            n3 = n3 < 200 ? 200 : n3;
            Dimension dimension = new Dimension(n3, n2);
            this.rendererComponent.setMaximumSize(dimension);
            this.rendererComponent.setPreferredSize(dimension);
            if (bl) {
                this.jlName.setForeground(this.fgSelectionColor);
                this.jlPkg.setForeground(this.fgSelectionColor);
                this.jlPrj.setForeground(this.fgSelectionColor);
                this.rendererComponent.setBackground(this.bgSelectionColor);
            } else {
                this.jlName.setForeground(this.fgColor);
                this.jlPkg.setForeground(this.fgColorLighter);
                this.jlPrj.setForeground(this.fgColor);
                this.rendererComponent.setBackground(n % 2 == 0 ? this.bgColor : this.bgColorDarker);
            }
            if (object instanceof TypeDescriptor) {
                long l = System.currentTimeMillis();
                TypeDescriptor typeDescriptor = (TypeDescriptor)object;
                this.jlName.setIcon(typeDescriptor.getIcon());
                this.jlName.setText(typeDescriptor.getTypeName());
                this.jlPkg.setText(typeDescriptor.getContextName());
                this.jlPrj.setText(typeDescriptor.getProjectName());
                this.jlPrj.setIcon(typeDescriptor.getProjectIcon());
                this.rendererComponent.setDescriptor(typeDescriptor);
                LOGGER.fine("  Time in paint " + (System.currentTimeMillis() - l) + " ms.");
            } else {
                this.jlName.setText(object.toString());
            }
            return this.rendererComponent;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            this.jlName.setText("Sample");
            this.jlName.setIcon(new ImageIcon(org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/jumpto/type/sample.png")));
            this.jList.setFixedCellHeight(this.jlName.getPreferredSize().height);
            this.jList.setFixedCellWidth(jViewport.getExtentSize().width);
        }
    }

    private static class MyPanel
    extends JPanel {
        private TypeDescriptor td;

        private MyPanel() {
        }

        void setDescriptor(TypeDescriptor typeDescriptor) {
            this.td = typeDescriptor;
            this.putClientProperty("ToolTipText", null);
        }

        public String getToolTipText() {
            String string = (String)this.getClientProperty("ToolTipText");
            if (string == null) {
                FileObject fileObject;
                if (this.td != null && (fileObject = this.td.getFileObject()) != null) {
                    string = FileUtil.getFileDisplayName((FileObject)fileObject);
                }
                this.putClientProperty("ToolTipText", string);
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Worker
    implements Runnable {
        private volatile boolean isCanceled = false;
        private final String text;
        private final long createTime;

        public Worker(String string) {
            this.text = string;
            this.createTime = System.currentTimeMillis();
            LOGGER.fine("Worker for " + string + " - created after " + (System.currentTimeMillis() - ((GoToTypeAction)GoToTypeAction.this).panel.time) + " ms.");
        }

        @Override
        public void run() {
            LOGGER.fine("Worker for " + this.text + " - started " + (System.currentTimeMillis() - this.createTime) + " ms.");
            final List<? extends TypeDescriptor> list = this.getTypeNames(this.text);
            if (this.isCanceled) {
                LOGGER.fine("Worker for " + this.text + " exited after cancel " + (System.currentTimeMillis() - this.createTime) + " ms.");
                return;
            }
            ListModel listModel = Models.fromList(list);
            if (GoToTypeAction.this.typeFilter != null) {
                listModel = LazyListModel.create(listModel, GoToTypeAction.this, 0.1, "Not computed yet");
            }
            final ListModel listModel2 = listModel;
            if (this.isCanceled) {
                LOGGER.fine("Worker for " + this.text + " exited after cancel " + (System.currentTimeMillis() - this.createTime) + " ms.");
                return;
            }
            if (!this.isCanceled && listModel2 != null) {
                LOGGER.fine("Worker for text " + this.text + " finished after " + (System.currentTimeMillis() - this.createTime) + " ms.");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GoToTypeAction.this.panel.setModel(listModel2);
                        if (GoToTypeAction.this.okButton != null && !list.isEmpty()) {
                            GoToTypeAction.this.okButton.setEnabled(true);
                        }
                    }
                });
            }
        }

        public void cancel() {
            if (((GoToTypeAction)GoToTypeAction.this).panel.time != -1L) {
                LOGGER.fine("Worker for text " + this.text + " canceled after " + (System.currentTimeMillis() - this.createTime) + " ms.");
            }
            this.isCanceled = true;
        }

        private List<? extends TypeDescriptor> getTypeNames(String string) {
            ArrayList arrayList = new ArrayList(128);
            String[] stringArray = new String[1];
            TypeProvider.Context context = TypeProviderAccessor.DEFAULT.createContext(null, string, GoToTypeAction.this.nameKind);
            TypeProvider.Result result = TypeProviderAccessor.DEFAULT.createResult(arrayList, stringArray);
            for (TypeProvider typeProvider : GoToTypeAction.this.typeProviders) {
                if (this.isCanceled) {
                    return null;
                }
                typeProvider.computeTypeNames(context, result);
            }
            if (!this.isCanceled) {
                Collections.sort(arrayList, new TypeComparator());
                GoToTypeAction.this.panel.setWarning(stringArray[0]);
                return arrayList;
            }
            return null;
        }
    }
}

