/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.AddListener;
import com.sun.webui.jsf.component.Button;
import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.ListManager;
import com.sun.webui.jsf.component.RemoveListener;
import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.component.TextField;
import com.sun.webui.jsf.component.WebuiInput;
import com.sun.webui.jsf.model.list.ListItem;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.jsf.validator.StringLengthValidator;
import com.sun.webui.theme.Theme;
import java.lang.reflect.Array;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.event.ActionListener;

public class EditableList
extends WebuiInput
implements ListManager,
NamingContainer {
    public static final String ADD_BUTTON_ID = "_addButton";
    public static final String ADD_BUTTON_FACET = "addButton";
    public static final String ADD_BUTTON_TEXT_KEY = "EditableList.add";
    public static final String REMOVE_BUTTON_ID = "_removeButton";
    public static final String REMOVE_BUTTON_FACET = "removeButton";
    public static final String REMOVE_BUTTON_TEXT_KEY = "EditableList.remove";
    public static final String FIELD_ID = "_field";
    public static final String FIELD_FACET = "field";
    public static final String SLV_TOOLONG_KEY = "EditableList.itemTooLong";
    public static final String SLV_TOOSHORT_KEY = "EditableList.fieldEmpty";
    public static final String LIST_LABEL_ID = "_listLabel";
    public static final String LIST_LABEL_FACET = "listLabel";
    public static final String LIST_LABEL_TEXT_KEY = "EditableList.defaultListLabel";
    public static final String FIELD_LABEL_ID = "_fieldLabel";
    public static final String FIELD_LABEL_FACET = "fieldLabel";
    public static final String FIELD_LABEL_TEXT_KEY = "EditableList.defaultFieldLabel";
    public static final String READ_ONLY_ID = "_readOnly";
    public static final String READ_ONLY_FACET = "readOnly";
    public static final String HEADER_FACET = "header";
    public static final String FOOTER_FACET = "footer";
    public static final String ADD_FUNCTION = ".add(); ";
    public static final String ENABLE_ADD_FUNCTION = ".enableAdd(); ";
    public static final String SET_ADD_DISABLED_FUNCTION = ".setAddDisabled(false);";
    public static final String ENABLE_REMOVE_FUNCTION = ".enableRemove(); ";
    public static final String UPDATE_BUTTONS_FUNCTION = ".updateButtons(); ";
    private static final String READ_ONLY_SEPARATOR = ", ";
    public static final String SEARCH_FACET = "search";
    public static final String SPACER_STRING = "_";
    private static final String KEY_STRING = "a";
    private static final String DUP_STRING = "\t";
    private static final int MIN_LENGTH = 20;
    private static final boolean DEBUG = false;
    private TreeMap listItems = null;
    private Collator collator = null;
    private transient Theme theme = null;
    private String selectedValue = null;
    private String[] valuesToRemove = null;
    private boolean disabled = false;
    private boolean disabled_set = false;
    private String fieldLabel = null;
    private int labelLevel = Integer.MIN_VALUE;
    private boolean labelLevel_set = false;
    private String listLabel = null;
    private boolean listOnTop = false;
    private boolean listOnTop_set = false;
    private int maxLength = Integer.MIN_VALUE;
    private boolean maxLength_set = false;
    private boolean multiple = false;
    private boolean multiple_set = false;
    private boolean readOnly = false;
    private boolean readOnly_set = false;
    private int rows = Integer.MIN_VALUE;
    private boolean rows_set = false;
    private boolean sorted = false;
    private boolean sorted_set = false;
    private String style = null;
    private String styleClass = null;
    private int tabIndex = Integer.MIN_VALUE;
    private boolean tabIndex_set = false;
    private String toolTip = null;
    private boolean visible = false;
    private boolean visible_set = false;
    private String width;
    private MethodExpression fieldValidatorExpression;

    public EditableList() {
        this.setRendererType("com.sun.webui.jsf.EditableList");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.EditableList";
    }

    public int getMaxLength() {
        int length = this._getMaxLength();
        if (length < 1) {
            length = 25;
        }
        return length;
    }

    public UIComponent getAddButtonComponent() {
        return this.getButtonFacet(ADD_BUTTON_FACET, false, this.getTheme().getMessage(ADD_BUTTON_TEXT_KEY), new AddListener());
    }

    public UIComponent getRemoveButtonComponent() {
        return this.getButtonFacet(REMOVE_BUTTON_FACET, false, this.getTheme().getMessage(REMOVE_BUTTON_TEXT_KEY), new RemoveListener());
    }

    private UIComponent getButtonFacet(String facetName, boolean primary, String text, ActionListener actionListener) {
        UIComponent buttonComponent = this.getFacet(facetName);
        if (buttonComponent != null) {
            return buttonComponent;
        }
        Button button = (Button)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (button == null) {
            button = new Button();
            button.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
            button.addActionListener(actionListener);
            ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)button);
        }
        this.initButtonFacet(button, primary, text);
        return button;
    }

    private void initButtonFacet(Button button, boolean primary, String text) {
        button.setText(text);
        int tindex = this.getTabIndex();
        if (tindex > 0) {
            button.setTabIndex(tindex);
        }
        button.setImmediate(true);
        button.setPrimary(primary);
        button.setDisabled(this.isDisabled());
    }

    public UIComponent getListLabelComponent() {
        String labelString = this.getListLabel();
        if (labelString == null || labelString.length() == 0) {
            labelString = this.getTheme().getMessage(LIST_LABEL_TEXT_KEY);
        }
        return this.getLabelFacet(LIST_LABEL_FACET, labelString, false, this.getClientId(FacesContext.getCurrentInstance()).concat("_list"), null, (UIComponent)this);
    }

    public UIComponent getFieldLabelComponent() {
        String labelString = this.getFieldLabel();
        if (labelString == null || labelString.length() == 0) {
            labelString = this.getTheme().getMessage(FIELD_LABEL_TEXT_KEY);
        }
        UIComponent fc = this.getFieldComponent();
        return this.getLabelFacet(FIELD_LABEL_FACET, labelString, false, null, fc, fc);
    }

    private UIComponent getLabelFacet(String facetName, String text, boolean hideIndicators, String forId, UIComponent labeledComponent, UIComponent indicatorComponent) {
        UIComponent labelComponent = this.getFacet(facetName);
        if (labelComponent != null) {
            return labelComponent;
        }
        Label label = (Label)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (label == null) {
            label = new Label();
            label.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
            ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)label);
        }
        if (text == null || text.length() < 1) {
            text = new String();
        }
        label.setText(text);
        label.setFor(forId);
        label.setLabelLevel(this.getLabelLevel());
        label.setHideIndicators(hideIndicators);
        label.setLabeledComponent(labeledComponent);
        label.setIndicatorComponent(indicatorComponent);
        return label;
    }

    private UIComponent getRenderedFieldComponent() {
        UIComponent fieldComponent = this.getFacet(FIELD_FACET);
        if (fieldComponent != null) {
            return fieldComponent;
        }
        fieldComponent = ComponentUtilities.getPrivateFacet((UIComponent)this, FIELD_FACET, false);
        return fieldComponent == null ? this.getFieldComponent() : fieldComponent;
    }

    public UIComponent getFieldComponent() {
        UIComponent fieldComponent = this.getFacet(FIELD_FACET);
        if (fieldComponent != null) {
            return fieldComponent;
        }
        TextField field = (TextField)ComponentUtilities.getPrivateFacet((UIComponent)this, FIELD_FACET, true);
        if (field == null) {
            field = new TextField();
            field.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FIELD_FACET));
            field.setTrim(true);
            ComponentUtilities.putPrivateFacet((UIComponent)this, FIELD_FACET, (UIComponent)field);
            StringLengthValidator strl = new StringLengthValidator(this.getMaxLength(), 1);
            Theme theme = this.getTheme();
            strl.setTooLongMessage(theme.getMessage(SLV_TOOLONG_KEY));
            strl.setTooShortMessage(theme.getMessage(SLV_TOOSHORT_KEY));
            field.addValidator(strl);
        }
        this.initFieldFacet(field);
        return field;
    }

    private void initFieldFacet(TextField field) {
        String jsObjectName = this.getJavaScriptObjectName();
        StringBuffer onkeypressBuffer = new StringBuffer(128);
        onkeypressBuffer.append("if(event && event.keyCode == 13) { ");
        onkeypressBuffer.append(jsObjectName);
        onkeypressBuffer.append(ADD_FUNCTION);
        onkeypressBuffer.append("return false; } ");
        field.setOnKeyPress(onkeypressBuffer.toString());
        StringBuffer onfocusBuffer = new StringBuffer(128);
        onfocusBuffer.append(jsObjectName);
        onfocusBuffer.append(SET_ADD_DISABLED_FUNCTION);
        onfocusBuffer.append("return false;");
        field.setOnFocus(onfocusBuffer.toString());
        StringBuffer onfocuslostBuffer = new StringBuffer(128);
        onfocuslostBuffer.append(jsObjectName);
        onfocuslostBuffer.append(ENABLE_ADD_FUNCTION);
        onfocuslostBuffer.append("return false;");
        field.setOnBlur(onfocuslostBuffer.toString());
        int columns = this.getMaxLength();
        if (columns < 20) {
            columns = 20;
        }
        field.setColumns(columns);
        int tindex = this.getTabIndex();
        if (tindex > 0) {
            field.setTabIndex(tindex);
        }
        field.setDisabled(this.isDisabled());
        field.setValidatorExpression(this.getFieldValidatorExpression());
    }

    public UIComponent getReadOnlyValueComponent() {
        UIComponent textComponent = this.getFacet(READ_ONLY_FACET);
        if (textComponent != null) {
            return textComponent;
        }
        StaticText text = new StaticText();
        text.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, READ_ONLY_FACET));
        text.setParent((UIComponent)this);
        FacesContext context = FacesContext.getCurrentInstance();
        String readOnlyString = this.getValueAsReadOnly(context);
        if (readOnlyString == null || readOnlyString.length() < 1) {
            readOnlyString = new String();
        }
        text.setText(readOnlyString);
        return text;
    }

    protected String getValueAsReadOnly(FacesContext context) throws FacesException {
        StringBuffer valueBuffer = new StringBuffer(200);
        Iterator iterator = this.getListItems(context, false);
        while (iterator.hasNext()) {
            String string = ((ListItem)iterator.next()).getLabel();
            if (string.indexOf("nbsp") > -1) continue;
            valueBuffer.append(string);
            if (!iterator.hasNext()) continue;
            valueBuffer.append(READ_ONLY_SEPARATOR);
        }
        return valueBuffer.toString();
    }

    public void setConverter(Converter converter) {
        String msg = this.getTheme().getMessage("EditableList.noConversion");
        throw new RuntimeException(msg);
    }

    public String getJavaScriptObjectName() {
        return JavaScriptUtilities.getDomNode(this.getFacesContext(), (UIComponent)this);
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    public String getOnChange() {
        StringBuffer onchangeBuffer = new StringBuffer(128);
        onchangeBuffer.append(this.getJavaScriptObjectName());
        onchangeBuffer.append(ENABLE_REMOVE_FUNCTION);
        return onchangeBuffer.toString();
    }

    public String getLabeledElementId(FacesContext context) {
        if (this.isReadOnly()) {
            UIComponent readOnlyComponent = this.getReadOnlyValueComponent();
            if (readOnlyComponent instanceof ComplexComponent) {
                return ((ComplexComponent)readOnlyComponent).getLabeledElementId(context);
            }
            return readOnlyComponent != null ? readOnlyComponent.getClientId(context) : null;
        }
        UIComponent fc = this.getFieldComponent();
        if (fc instanceof ComplexComponent) {
            return ((ComplexComponent)fc).getLabeledElementId(context);
        }
        return fc != null ? fc.getClientId(context) : null;
    }

    public String getFocusElementId(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    public UIComponent getIndicatorComponent(FacesContext context, Label label) {
        return this;
    }

    public String getPrimaryElementID(FacesContext context) {
        return this.getClientId(context).concat("_list");
    }

    public String[] getValuesToRemove() {
        if (this.valuesToRemove == null) {
            return new String[0];
        }
        return this.valuesToRemove;
    }

    public void setValuesToRemove(String[] valuesToRemove) {
        this.valuesToRemove = valuesToRemove;
    }

    public Iterator getListItems(FacesContext context, boolean rulerAtEnd) throws FacesException {
        Locale locale = context.getViewRoot().getLocale();
        this.collator = Collator.getInstance(locale);
        this.listItems = new TreeMap(this.collator);
        boolean sorted = this.isSorted();
        HashMap<String, String> keysSeen = sorted ? new HashMap<String, String>() : null;
        String lastKey = "";
        String[] currentValues = this.getCurrentValueAsStringArray();
        String currentString = null;
        ListItem listItem = null;
        ListItem selectedItem = null;
        StringBuffer unsortedKeyBuffer = sorted ? null : new StringBuffer(KEY_STRING);
        for (int counter = 0; counter < currentValues.length; ++counter) {
            currentString = currentValues[counter];
            if (currentString == null) {
                String msg = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "EditableList.badValue", new Object[]{this.getClientId(context)});
                throw new FacesException(msg);
            }
            listItem = new ListItem(currentString);
            listItem.setValue(currentString);
            if (currentString.equals(this.selectedValue)) {
                selectedItem = listItem;
            }
            if (sorted) {
                String key = currentString;
                if (keysSeen.containsKey(key)) {
                    String dup_string = (String)keysSeen.get(key);
                    dup_string = dup_string.concat(DUP_STRING);
                    key = key.concat(dup_string);
                    keysSeen.put(currentString, dup_string);
                } else {
                    keysSeen.put(key, DUP_STRING);
                }
                if (this.collator.compare(key, lastKey) > 0) {
                    lastKey = key;
                }
                this.listItems.put(key, listItem);
                continue;
            }
            this.listItems.put(unsortedKeyBuffer.toString(), listItem);
            unsortedKeyBuffer.append(KEY_STRING);
        }
        if (selectedItem != null) {
            selectedItem.setSelected(true);
        }
        if (!sorted) {
            lastKey = unsortedKeyBuffer.toString();
        }
        if (rulerAtEnd) {
            int length = this.getMaxLength();
            if (length < 20) {
                length = 20;
            }
            StringBuffer labelBuffer = new StringBuffer(length);
            for (int counter = 0; counter < length; ++counter) {
                labelBuffer.append(SPACER_STRING);
            }
            ListItem item = new ListItem(labelBuffer.toString());
            item.setDisabled(true);
            this.listItems.put(lastKey.concat(KEY_STRING), item);
        }
        return this.listItems.values().iterator();
    }

    private String[] getCurrentValueAsStringArray() {
        Object value = this.getSubmittedValue();
        if (value == null) {
            value = this.getValue();
        }
        if (value == null) {
            return new String[0];
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        String msg = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "EditableList.badValue", new Object[]{this.getClientId(FacesContext.getCurrentInstance())});
        throw new FacesException(msg);
    }

    private void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }

    public Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        if (!(submittedValue instanceof String[])) {
            throw new ConverterException("Submitted value must be a String array");
        }
        String[] rawValues = (String[])submittedValue;
        if (rawValues.length == 0 && ConversionUtilities.renderedNull((UIComponent)this)) {
            return null;
        }
        return submittedValue;
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        UIComponent field = this.getRenderedFieldComponent();
        String fieldId = field.getId();
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (fieldId != null && fieldId.equals(kid.getId())) continue;
            kid.processValidators(context);
        }
        this.checkValid(context);
    }

    public void processAddAction() {
        if (FacesContext.getCurrentInstance().getRenderResponse()) {
            return;
        }
        this.selectedValue = null;
        String[] values = this.getCurrentValueAsStringArray();
        Object value = this.getAddedObject();
        if (value == null) {
            return;
        }
        this.selectedValue = value.toString();
        int numValues = values.length;
        String[] newValues = new String[numValues + 1];
        for (int counter = 0; counter < numValues; ++counter) {
            newValues[counter] = values[counter];
        }
        newValues[counter] = this.selectedValue;
        this.setSubmittedValue(newValues);
    }

    public void processRemoveAction() {
        int counter;
        if (FacesContext.getCurrentInstance().getRenderResponse()) {
            return;
        }
        this.selectedValue = null;
        ArrayList<String> items = new ArrayList<String>();
        if (this.getValue() != null) {
            String[] strings = this.getCurrentValueAsStringArray();
            int length = strings.length;
            for (counter = 0; counter < length; ++counter) {
                items.add(strings[counter]);
            }
        }
        String[] valuesToRemove = this.getValuesToRemove();
        for (counter = 0; counter < valuesToRemove.length; ++counter) {
            items.remove(valuesToRemove[counter]);
        }
        String[] newValues = new String[items.size()];
        for (counter = 0; counter < items.size(); ++counter) {
            newValues[counter] = (String)items.get(counter);
        }
        this.setValuesToRemove(null);
        this.setSubmittedValue(newValues);
    }

    private void checkValid(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    private Object getAddedObject() {
        FacesContext context = FacesContext.getCurrentInstance();
        EditableValueHolder field = (EditableValueHolder)this.getRenderedFieldComponent();
        ((UIComponent)field).processValidators(context);
        if (!field.isValid()) {
            return null;
        }
        Object value = field.getValue();
        if (value == null || value instanceof String && value.toString().length() == 0) {
            field.setValid(false);
            context.renderResponse();
            String message = ThemeUtilities.getTheme(context).getMessage(SLV_TOOSHORT_KEY);
            context.addMessage(this.getClientId(context), new FacesMessage(message));
            return null;
        }
        field.setValue(null);
        return value;
    }

    private boolean _isImmediate() {
        return false;
    }

    protected boolean compareValues(Object previous, Object value) {
        if (previous == null || value == null) {
            return super.compareValues(previous, value);
        }
        if (value instanceof Object[]) {
            int length = Array.getLength(value);
            if (Array.getLength(previous) != length) {
                return true;
            }
            for (int i = 0; i < length; ++i) {
                Object newValue = Array.get(value, i);
                Object prevValue = Array.get(previous, i);
                if (newValue == null) {
                    if (prevValue == null) continue;
                    return true;
                }
                if (prevValue == null) {
                    return true;
                }
                if (prevValue.equals(newValue)) continue;
                return true;
            }
            return false;
        }
        return super.compareValues(previous, value);
    }

    public String[] getValueAsStringArray(FacesContext context) {
        Iterator iterator = this.getListItems(context, false);
        int numItems = this.listItems.size();
        String[] values = new String[numItems];
        for (int counter = 0; counter < numItems; ++counter) {
            values[counter] = ((ListItem)iterator.next()).getValue();
        }
        return values;
    }

    public boolean mainListSubmits() {
        return true;
    }

    public ValueExpression getValueExpression(String name) {
        if (name.equals("list")) {
            return super.getValueExpression("value");
        }
        return super.getValueExpression(name);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (name.equals("list")) {
            super.setValueExpression("value", binding);
            return;
        }
        super.setValueExpression(name, binding);
    }

    public Converter getConverter() {
        return super.getConverter();
    }

    public boolean isImmediate() {
        return this._isImmediate();
    }

    public Object getValue() {
        return super.getValue();
    }

    public boolean isDisabled() {
        if (this.disabled_set) {
            return this.disabled;
        }
        ValueExpression _vb = this.getValueExpression("disabled");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        this.disabled_set = true;
    }

    public String getFieldLabel() {
        if (this.fieldLabel != null) {
            return this.fieldLabel;
        }
        ValueExpression _vb = this.getValueExpression(FIELD_LABEL_FACET);
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setFieldLabel(String fieldLabel) {
        this.fieldLabel = fieldLabel;
    }

    public int getLabelLevel() {
        if (this.labelLevel_set) {
            return this.labelLevel;
        }
        ValueExpression _vb = this.getValueExpression("labelLevel");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)_result;
        }
        return 2;
    }

    public void setLabelLevel(int labelLevel) {
        this.labelLevel = labelLevel;
        this.labelLevel_set = true;
    }

    public Object getList() {
        return this.getValue();
    }

    public void setList(Object list) {
        this.setValue(list);
    }

    public String getListLabel() {
        if (this.listLabel != null) {
            return this.listLabel;
        }
        ValueExpression _vb = this.getValueExpression(LIST_LABEL_FACET);
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setListLabel(String listLabel) {
        this.listLabel = listLabel;
    }

    public boolean isListOnTop() {
        if (this.listOnTop_set) {
            return this.listOnTop;
        }
        ValueExpression _vb = this.getValueExpression("listOnTop");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setListOnTop(boolean listOnTop) {
        this.listOnTop = listOnTop;
        this.listOnTop_set = true;
    }

    private int _getMaxLength() {
        if (this.maxLength_set) {
            return this.maxLength;
        }
        ValueExpression _vb = this.getValueExpression("maxLength");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)_result;
        }
        return 25;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        this.maxLength_set = true;
    }

    public boolean isMultiple() {
        if (this.multiple_set) {
            return this.multiple;
        }
        ValueExpression _vb = this.getValueExpression("multiple");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
        this.multiple_set = true;
    }

    public boolean isReadOnly() {
        if (this.readOnly_set) {
            return this.readOnly;
        }
        ValueExpression _vb = this.getValueExpression(READ_ONLY_FACET);
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.readOnly_set = true;
    }

    public int getRows() {
        Object _result;
        if (this.rows_set) {
            return this.rows;
        }
        ValueExpression _vb = this.getValueExpression("rows");
        if (_vb != null && (_result = _vb.getValue(this.getFacesContext().getELContext())) != null) {
            try {
                return (Integer)_result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getTheme().getMessageInt("editableList.rows", 6);
    }

    public void setRows(int rows) {
        this.rows = rows;
        this.rows_set = true;
    }

    public boolean isSorted() {
        if (this.sorted_set) {
            return this.sorted;
        }
        ValueExpression _vb = this.getValueExpression("sorted");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
        this.sorted_set = true;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression _vb = this.getValueExpression("style");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression _vb = this.getValueExpression("styleClass");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public int getTabIndex() {
        if (this.tabIndex_set) {
            return this.tabIndex;
        }
        ValueExpression _vb = this.getValueExpression("tabIndex");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)_result;
        }
        return Integer.MIN_VALUE;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
        this.tabIndex_set = true;
    }

    public String getToolTip() {
        if (this.toolTip != null) {
            return this.toolTip;
        }
        ValueExpression _vb = this.getValueExpression("toolTip");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    public boolean isVisible() {
        if (this.visible_set) {
            return this.visible;
        }
        ValueExpression _vb = this.getValueExpression("visible");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return true;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.visible_set = true;
    }

    public String getWidth() {
        String _width;
        if (this.width != null) {
            return this.width;
        }
        ValueExpression _vb = this.getValueExpression("style");
        if (_vb != null && (_width = (String)_vb.getValue(this.getFacesContext().getELContext())) != null && _width.trim().length() != 0) {
            return _width;
        }
        _width = this.getTheme().getMessage("editableList.width");
        if (_width != null && _width.trim().length() != 0) {
            return _width.trim();
        }
        return null;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public MethodExpression getFieldValidatorExpression() {
        return this.fieldValidatorExpression;
    }

    public void setFieldValidatorExpression(MethodExpression me) {
        this.fieldValidatorExpression = me;
    }

    public MethodExpression getListValidatorExpression() {
        return this.getValidatorExpression();
    }

    public void setListValidatorExpression(MethodExpression listValidator) {
        this.setValidatorExpression(listValidator);
    }

    public MethodExpression getValidatorExpression() {
        return super.getValidatorExpression();
    }

    public void restoreState(FacesContext _context, Object _state) {
        Object[] _values = (Object[])_state;
        super.restoreState(_context, _values[0]);
        this.disabled = (Boolean)_values[1];
        this.disabled_set = (Boolean)_values[2];
        this.fieldLabel = (String)_values[3];
        this.labelLevel = (Integer)_values[4];
        this.labelLevel_set = (Boolean)_values[5];
        this.listLabel = (String)_values[6];
        this.listOnTop = (Boolean)_values[7];
        this.listOnTop_set = (Boolean)_values[8];
        this.maxLength = (Integer)_values[9];
        this.maxLength_set = (Boolean)_values[10];
        this.multiple = (Boolean)_values[11];
        this.multiple_set = (Boolean)_values[12];
        this.readOnly = (Boolean)_values[13];
        this.readOnly_set = (Boolean)_values[14];
        this.rows = (Integer)_values[15];
        this.rows_set = (Boolean)_values[16];
        this.sorted = (Boolean)_values[17];
        this.sorted_set = (Boolean)_values[18];
        this.style = (String)_values[19];
        this.styleClass = (String)_values[20];
        this.tabIndex = (Integer)_values[21];
        this.tabIndex_set = (Boolean)_values[22];
        this.toolTip = (String)_values[23];
        this.visible = (Boolean)_values[24];
        this.visible_set = (Boolean)_values[25];
        this.fieldValidatorExpression = (MethodExpression)EditableList.restoreAttachedState((FacesContext)_context, (Object)_values[26]);
        this.width = (String)_values[27];
    }

    public Object saveState(FacesContext _context) {
        Object[] _values = new Object[]{super.saveState(_context), this.disabled ? Boolean.TRUE : Boolean.FALSE, this.disabled_set ? Boolean.TRUE : Boolean.FALSE, this.fieldLabel, new Integer(this.labelLevel), this.labelLevel_set ? Boolean.TRUE : Boolean.FALSE, this.listLabel, this.listOnTop ? Boolean.TRUE : Boolean.FALSE, this.listOnTop_set ? Boolean.TRUE : Boolean.FALSE, new Integer(this.maxLength), this.maxLength_set ? Boolean.TRUE : Boolean.FALSE, this.multiple ? Boolean.TRUE : Boolean.FALSE, this.multiple_set ? Boolean.TRUE : Boolean.FALSE, this.readOnly ? Boolean.TRUE : Boolean.FALSE, this.readOnly_set ? Boolean.TRUE : Boolean.FALSE, new Integer(this.rows), this.rows_set ? Boolean.TRUE : Boolean.FALSE, this.sorted ? Boolean.TRUE : Boolean.FALSE, this.sorted_set ? Boolean.TRUE : Boolean.FALSE, this.style, this.styleClass, new Integer(this.tabIndex), this.tabIndex_set ? Boolean.TRUE : Boolean.FALSE, this.toolTip, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visible_set ? Boolean.TRUE : Boolean.FALSE, EditableList.saveAttachedState((FacesContext)_context, (Object)this.fieldValidatorExpression), this.width};
        return _values;
    }
}

