/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.data.provider.FieldKey;
import com.sun.data.provider.FilterCriteria;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.SortCriteria;
import com.sun.data.provider.TableDataFilter;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.TableDataSorter;
import com.sun.data.provider.impl.BasicTableDataFilter;
import com.sun.data.provider.impl.BasicTableDataSorter;
import com.sun.data.provider.impl.ObjectArrayDataProvider;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.data.provider.impl.TableRowDataProvider;
import com.sun.webui.jsf.component.SavedState;
import com.sun.webui.jsf.component.TableColumnBase;
import com.sun.webui.jsf.component.WebuiComponent;
import com.sun.webui.jsf.component.WrapperEvent;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.LogUtil;
import java.beans.Beans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.ContextCallback;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;

public abstract class TableRowGroupBase
extends WebuiComponent
implements NamingContainer {
    private Map saved = new HashMap();
    private transient TableDataFilter filter = null;
    private transient TableDataSorter sorter = null;
    private TableRowDataProvider provider = null;
    private List tableColumnChildren = null;
    private RowKey[] filteredRowKeys = null;
    private RowKey[] sortedRowKeys = null;
    private String align = null;
    private String bgColor = null;
    private String _char = null;
    private String charOff = null;
    private boolean collapsed = false;
    private boolean collapsed_set = false;
    private String emptyDataMsg = null;
    private int first = Integer.MIN_VALUE;
    private boolean first_set = false;
    private boolean groupToggleButton = false;
    private boolean groupToggleButton_set = false;
    private String headerText = null;
    private String onClick = null;
    private String onDblClick = null;
    private String onKeyDown = null;
    private String onKeyPress = null;
    private String onKeyUp = null;
    private String onMouseDown = null;
    private String onMouseMove = null;
    private String onMouseOut = null;
    private String onMouseOver = null;
    private String onMouseUp = null;
    private int rows = Integer.MIN_VALUE;
    private boolean rows_set = false;
    private boolean selectMultipleToggleButton = false;
    private boolean selectMultipleToggleButton_set = false;
    private boolean selected = false;
    private boolean selected_set = false;
    private Object sourceData = null;
    private String sourceVar = null;
    private String styleClasses = null;
    private TableDataFilter tableDataFilter = null;
    private TableDataSorter tableDataSorter = null;
    private String toolTip = null;
    private String valign = null;
    private boolean visible = false;
    private boolean visible_set = false;

    public void clear() {
        this.provider = null;
        this.filteredRowKeys = null;
        this.sortedRowKeys = null;
        this.tableColumnChildren = null;
        Iterator kids = this.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumnBase kid = (TableColumnBase)((Object)kids.next());
            kid.clear();
        }
    }

    public Iterator getTableColumnChildren() {
        if (this.tableColumnChildren == null) {
            this.tableColumnChildren = new ArrayList();
            for (UIComponent kid : this.getChildren()) {
                if (!(kid instanceof TableColumnBase)) continue;
                this.tableColumnChildren.add(kid);
            }
        }
        return this.tableColumnChildren.iterator();
    }

    public void clearFilter() {
        this.getTableDataFilter().setFilterCriteria(null);
        this.setPage(1);
        this.filteredRowKeys = null;
        this.sortedRowKeys = null;
    }

    public RowKey[] getFilteredRowKeys() {
        if (this.filteredRowKeys != null) {
            return this.filteredRowKeys;
        }
        this.filteredRowKeys = this.getRowKeys();
        TableDataProvider provider = this.getTableRowDataProvider().getTableDataProvider();
        if (provider == null) {
            this.log("getFilteredRowKeys", "Cannot obtain filtered row keys, TableDataProvider is null");
            return this.filteredRowKeys;
        }
        TableDataFilter filter = this.getTableDataFilter();
        if (provider != filter) {
            this.filteredRowKeys = filter.filter(provider, this.filteredRowKeys);
        } else {
            this.log("getFilteredRowKeys", "Row keys already filtered, TableDataFilter and TableDataProvider are the same instance");
        }
        return this.filteredRowKeys;
    }

    public TableDataFilter getTableDataFilter() {
        TableDataFilter tdf = this._getTableDataFilter();
        if (tdf != null) {
            return tdf;
        }
        if (this.filter == null) {
            this.filter = new BasicTableDataFilter();
        }
        return this.filter;
    }

    public void setFilterCriteria(FilterCriteria[] filterCriteria) {
        this.clearFilter();
        this.getTableDataFilter().setFilterCriteria(filterCriteria);
    }

    public void setTableDataFilter(TableDataFilter filter) {
        this.filter = filter;
    }

    public int getFirst() {
        int last = this.getLast();
        int first = Math.max(0, this._getFirst());
        return first < last ? first : last;
    }

    public void setFirst(int first) {
        if (first < 0) {
            this.log("setFirst", "First row cannot be < 0");
            throw new IllegalArgumentException(Integer.toString(first));
        }
        this._setFirst(first);
    }

    public int getLast() {
        return Math.max(0, this.getPages() - 1) * this.getRows();
    }

    public int getPage() {
        return this.getFirst() / this.getRows() + 1;
    }

    public int getPages() {
        int rowCount = this.getRowCount();
        int rows = this.getRows();
        int modulus = rows > 0 ? rowCount % rows : 0;
        int result = rows > 0 ? rowCount / rows : 1;
        return modulus > 0 ? ++result : result;
    }

    public void setPage(int page) {
        int row = (page - 1) * this.getRows();
        int result = Math.min(row, this.getLast());
        this.setFirst(Math.min(Math.max(result, 0), this.getRowCount()));
    }

    public int getRows() {
        return Math.max(1, this._getRows());
    }

    public void setRows(int rows) {
        if (rows < 0) {
            this.log("setRows", "Paginated rows cannot be < 0");
            throw new IllegalArgumentException(Integer.toString(rows));
        }
        this._setRows(rows);
    }

    public boolean isRowAvailable() {
        boolean result = false;
        TableDataProvider provider = this.getTableRowDataProvider().getTableDataProvider();
        if (provider != null) {
            result = provider.isRowAvailable(this.getRowKey());
        } else {
            this.log("isRowAvailable", "Cannot determine if row is available, TableDataProvider is null");
        }
        return result;
    }

    public RowKey[] getHiddenRowKeys() {
        RowKey[] rowKeys = this.getSortedRowKeys();
        if (rowKeys == null) {
            return rowKeys;
        }
        ArrayList<RowKey> list = new ArrayList<RowKey>();
        int first = this.getFirst();
        int rows = this.getRows();
        for (int i = 0; i < rowKeys.length; ++i) {
            if (i >= first && i < first + rows) continue;
            list.add(rowKeys[i]);
        }
        rowKeys = new RowKey[list.size()];
        return list.toArray(rowKeys);
    }

    public FieldKey getFieldKey(String fieldId) {
        return this.getTableRowDataProvider().getFieldKey(fieldId);
    }

    public int getRowCount() {
        RowKey[] rowKeys = this.getFilteredRowKeys();
        return rowKeys != null ? rowKeys.length : 0;
    }

    public RowKey getRowKey() {
        return this.getTableRowDataProvider().getTableRow();
    }

    public RowKey[] getRowKeys() {
        RowKey[] rowKeys = null;
        TableDataProvider provider = this.getTableRowDataProvider().getTableDataProvider();
        if (provider == null) {
            this.log("getRowKeys", "Cannot obtain row keys, TableDataProvider is null");
            return rowKeys;
        }
        if (Beans.isDesignTime()) {
            this.log("getRowKeys", "Creating dummy data for design-time behavior");
            rowKeys = provider.getRowKeys(provider.getRowCount(), null);
            if (this.getRows() == 0 || rowKeys == null || rowKeys.length == 0) {
                this.log("getRowKeys", "Cannot create dummy data, DataProvider has no rows");
                return rowKeys;
            }
            ArrayList<RowKey> list = new ArrayList<RowKey>();
            for (int i = 0; i < this.getRows() + 1; ++i) {
                list.add(rowKeys[i % rowKeys.length]);
            }
            rowKeys = new RowKey[list.size()];
            return list.toArray(rowKeys);
        }
        int rowCount = provider.getRowCount();
        if (rowCount == -1) {
            this.log("getRowKeys", "Manually calculating row count, DataProvider.getRowCount() is -1");
            int index = 0;
            while ((rowKeys = provider.getRowKeys(rowCount = 1000000 * ++index, null)) != null && rowKeys.length - 1 == rowCount) {
            }
        } else {
            rowKeys = provider.getRowKeys(rowCount, null);
        }
        return rowKeys;
    }

    protected TableRowDataProvider getTableRowDataProvider() {
        if (this.provider == null) {
            TableDataProvider tdp;
            this.log("getTableRowDataProvider", "Re-evaluating sourceData, TableRowDataProvider is null");
            Object obj = this.getSourceData();
            if (obj == null) {
                tdp = null;
            } else if (obj instanceof TableDataProvider) {
                tdp = (TableDataProvider)obj;
            } else if (obj instanceof List) {
                tdp = new ObjectListDataProvider((List)obj);
            } else if (Object[].class.isAssignableFrom(obj.getClass())) {
                tdp = new ObjectArrayDataProvider((Object[])obj);
            } else {
                ArrayList<Object> list = new ArrayList<Object>(1);
                list.add(obj);
                tdp = new ObjectListDataProvider(list);
            }
            this.provider = new TableRowDataProvider(tdp);
        }
        return this.provider;
    }

    public Class getType(FieldKey fieldKey) {
        return this.getTableRowDataProvider().getType(fieldKey);
    }

    public RowKey[] getRenderedRowKeys() {
        RowKey[] rowKeys = this.getSortedRowKeys();
        if (rowKeys == null) {
            return rowKeys;
        }
        ArrayList<RowKey> list = new ArrayList<RowKey>();
        int first = this.getFirst();
        int rows = this.getRows();
        for (int i = first; i < rowKeys.length && i < first + rows; ++i) {
            list.add(rowKeys[i]);
        }
        rowKeys = new RowKey[list.size()];
        return list.toArray(rowKeys);
    }

    public void setRowKey(RowKey rowKey) {
        this.saveDescendantState();
        this.getTableRowDataProvider().setTableRow(rowKey);
        String sourceVar = this.getSourceVar();
        if (sourceVar != null) {
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            if (rowKey == null) {
                requestMap.remove(sourceVar);
            } else if (this.isRowAvailable()) {
                requestMap.put(sourceVar, this.getTableRowDataProvider());
            } else {
                requestMap.remove(sourceVar);
            }
        } else {
            this.log("setRowKey", "Cannot set row key, sourceVar property is null");
        }
        this.restoreDescendantState();
    }

    public void setSourceData(Object sourceData) {
        this._setSourceData(sourceData);
        this.first_set = false;
        this.clear();
    }

    public int getHiddenSelectedRowsCount() {
        RowKey[] rowKeys = this.getHiddenSelectedRowKeys();
        return rowKeys != null ? rowKeys.length : 0;
    }

    public RowKey[] getHiddenSelectedRowKeys() {
        RowKey[] rowKeys = this.getHiddenRowKeys();
        if (rowKeys == null) {
            return rowKeys;
        }
        RowKey rowKey = this.getRowKey();
        ArrayList<RowKey> list = new ArrayList<RowKey>();
        for (int i = 0; i < rowKeys.length; ++i) {
            this.setRowKey(rowKeys[i]);
            if (!this.isRowAvailable() || !this.isSelected()) continue;
            list.add(rowKeys[i]);
        }
        this.setRowKey(rowKey);
        rowKeys = new RowKey[list.size()];
        return list.toArray(rowKeys);
    }

    public int getSelectedRowsCount() {
        RowKey[] rowKeys = this.getSelectedRowKeys();
        return rowKeys != null ? rowKeys.length : 0;
    }

    public RowKey[] getSelectedRowKeys() {
        RowKey[] rowKeys = this.getFilteredRowKeys();
        if (rowKeys == null) {
            return rowKeys;
        }
        RowKey rowKey = this.getRowKey();
        ArrayList<RowKey> list = new ArrayList<RowKey>();
        for (int i = 0; i < rowKeys.length; ++i) {
            this.setRowKey(rowKeys[i]);
            if (!this.isRowAvailable() || !this.isSelected()) continue;
            list.add(rowKeys[i]);
        }
        this.setRowKey(rowKey);
        rowKeys = new RowKey[list.size()];
        return list.toArray(rowKeys);
    }

    public int getRenderedSelectedRowsCount() {
        RowKey[] rowKeys = this.getRenderedSelectedRowKeys();
        return rowKeys != null ? rowKeys.length : 0;
    }

    public RowKey[] getRenderedSelectedRowKeys() {
        RowKey[] rowKeys = this.getRenderedRowKeys();
        if (rowKeys == null) {
            return rowKeys;
        }
        RowKey rowKey = this.getRowKey();
        ArrayList<RowKey> list = new ArrayList<RowKey>();
        for (int i = 0; i < rowKeys.length; ++i) {
            this.setRowKey(rowKeys[i]);
            if (!this.isRowAvailable() || !this.isSelected()) continue;
            list.add(rowKeys[i]);
        }
        this.setRowKey(rowKey);
        rowKeys = new RowKey[list.size()];
        return list.toArray(rowKeys);
    }

    public void addSort(SortCriteria criteria) {
        if (criteria == null) {
            return;
        }
        TableDataSorter sorter = this.getTableDataSorter();
        SortCriteria[] oldCriteria = sorter.getSortCriteria();
        if (oldCriteria != null) {
            for (int i = 0; i < oldCriteria.length; ++i) {
                String key;
                if (oldCriteria[i] == null || (key = oldCriteria[i].getCriteriaKey()) == null || !key.equals(criteria.getCriteriaKey())) continue;
                oldCriteria[i] = criteria;
                sorter.setSortCriteria(oldCriteria);
                this.sortedRowKeys = null;
                return;
            }
        }
        int oldLength = oldCriteria != null ? oldCriteria.length : 0;
        SortCriteria[] newCriteria = new SortCriteria[oldLength + 1];
        for (int i = 0; i < oldLength; ++i) {
            newCriteria[i] = oldCriteria[i];
        }
        newCriteria[oldLength] = criteria;
        sorter.setSortCriteria(newCriteria);
        this.sortedRowKeys = null;
        this.setPage(1);
    }

    public void clearSort() {
        this.getTableDataSorter().setSortCriteria(null);
        this.sortedRowKeys = null;
        this.setPage(1);
    }

    public int getSortCount() {
        int result = 0;
        SortCriteria[] sortCriteria = this.getTableDataSorter().getSortCriteria();
        if (sortCriteria != null) {
            result = sortCriteria.length;
        }
        return result;
    }

    public int getSortLevel(SortCriteria criteria) {
        int result = -1;
        if (criteria == null) {
            return result;
        }
        SortCriteria[] sortCriteria = this.getTableDataSorter().getSortCriteria();
        if (sortCriteria != null) {
            for (int i = 0; i < sortCriteria.length; ++i) {
                String key;
                if (sortCriteria[i] == null || (key = sortCriteria[i].getCriteriaKey()) == null || !key.equals(criteria.getCriteriaKey())) continue;
                result = i + 1;
                break;
            }
        }
        return result;
    }

    public boolean isDescendingSort(SortCriteria criteria) {
        boolean result = false;
        if (criteria == null) {
            return result;
        }
        SortCriteria[] sortCriteria = this.getTableDataSorter().getSortCriteria();
        if (sortCriteria != null) {
            for (int i = 0; i < sortCriteria.length; ++i) {
                String key;
                if (sortCriteria[i] == null || (key = sortCriteria[i].getCriteriaKey()) == null || !key.equals(criteria.getCriteriaKey())) continue;
                result = !sortCriteria[i].isAscending();
                break;
            }
        }
        return result;
    }

    public RowKey[] getSortedRowKeys() {
        if (this.sortedRowKeys != null) {
            return this.sortedRowKeys;
        }
        this.sortedRowKeys = this.getFilteredRowKeys();
        TableDataProvider provider = this.getTableRowDataProvider().getTableDataProvider();
        if (provider == null) {
            this.log("getSortedRowKeys", "Cannot obtain sorted row keys, TableDataProvider is null");
            return this.sortedRowKeys;
        }
        TableDataSorter sorter = this.getTableDataSorter();
        if (provider != sorter) {
            this.sortedRowKeys = sorter.sort(provider, this.sortedRowKeys);
        }
        return this.sortedRowKeys;
    }

    public TableDataSorter getTableDataSorter() {
        TableDataSorter tds = this._getTableDataSorter();
        if (tds != null) {
            return tds;
        }
        if (this.sorter == null) {
            this.sorter = new BasicTableDataSorter();
        }
        return this.sorter;
    }

    public void setTableDataSorter(TableDataSorter sorter) {
        this.sorter = sorter;
    }

    public void setSortCriteria(SortCriteria[] sortCriteria) {
        this.clearSort();
        this.getTableDataSorter().setSortCriteria(sortCriteria);
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this._restoreState(context, values[0]);
        this.saved = (Map)values[1];
        TableDataSorter sorter = this.getTableDataSorter();
        sorter.setSortCriteria((SortCriteria[])values[2]);
        TableDataFilter filter = this.getTableDataFilter();
        filter.setFilterCriteria((FilterCriteria[])values[3]);
        this.filteredRowKeys = (RowKey[])values[4];
        this.sortedRowKeys = (RowKey[])values[5];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this._saveState(context), this.saved, this.getTableDataSorter().getSortCriteria(), this.getTableDataFilter().getFilterCriteria(), this.getFilteredRowKeys(), this.getSortedRowKeys()};
        return values;
    }

    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        if (null == context || null == clientId) {
            throw new NullPointerException();
        }
        String baseClientId = super.getClientId(context);
        if (clientId.equals(baseClientId)) {
            return super.invokeOnComponent(context, clientId, callback);
        }
        boolean found = false;
        if (clientId.startsWith(baseClientId)) {
            RowKey oldRowKey = this.getRowKey();
            try {
                int first = clientId.indexOf(58, baseClientId.length());
                int last = clientId.indexOf(58, ++first + 1);
                String rowId = clientId.substring(first, last);
                TableDataProvider provider = this.getTableRowDataProvider().getTableDataProvider();
                if (provider != null) {
                    this.setRowKey(provider.getRowKey(rowId));
                    if (this.isRowAvailable()) {
                        found = super.invokeOnComponent(context, clientId, callback);
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            this.setRowKey(oldRowKey);
        }
        return found;
    }

    public void setValueExpression(String name, ValueExpression valueExpression) {
        if ("sourceData".equals(name)) {
            this.first_set = false;
            this.clear();
        } else if ("sourceVar".equals(name) && !valueExpression.isLiteralText()) {
            this.log("setValueExpression", "sourceVar cannot equal given name");
            throw new IllegalArgumentException();
        }
        super.setValueExpression(name, valueExpression);
    }

    public String getClientId(FacesContext context) {
        if (context == null) {
            this.log("getClientId", "Cannot obtain client Id, FacesContext is null");
            throw new NullPointerException();
        }
        String baseClientId = super.getClientId(context);
        if (this.getRowKey() != null) {
            return baseClientId + ':' + this.getRowKey().getRowId();
        }
        return baseClientId;
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent((FacesEvent)new WrapperEvent((UIComponent)this, event, this.getRowKey()));
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (!(event instanceof WrapperEvent)) {
            super.broadcast(event);
            return;
        }
        WrapperEvent revent = (WrapperEvent)event;
        RowKey oldRowKey = this.getRowKey();
        this.setRowKey(revent.getRowKey());
        FacesEvent rowEvent = revent.getFacesEvent();
        rowEvent.getComponent().broadcast(rowEvent);
        this.setRowKey(oldRowKey);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (this.isNestedWithinTableRowGroup()) {
            this.clear();
        }
        if (!this.keepSaved(context)) {
            this.saved = new HashMap();
        }
        super.encodeBegin(context);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            this.log("processDecodes", "Cannot decode, FacesContext is null");
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            this.log("processDecodes", "Component not rendered, nothing to decode");
            return;
        }
        if (this.saved == null || !this.keepSaved(context)) {
            this.saved = new HashMap();
        }
        this.iterate(context, PhaseId.APPLY_REQUEST_VALUES);
        this.decode(context);
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            this.log("processValidators", "Cannot validate, FacesContext is null");
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            this.log("processValidators", "Component not rendered, nothing to validate");
            return;
        }
        this.iterate(context, PhaseId.PROCESS_VALIDATIONS);
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            this.log("processUpdates", "Cannot update, FacesContext is null");
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            this.log("processUpdates", "Component not rendered, nothing to update");
            return;
        }
        this.iterate(context, PhaseId.UPDATE_MODEL_VALUES);
    }

    private boolean isNestedWithinTableRowGroup() {
        TableRowGroupBase parent = this;
        while (null != (parent = parent.getParent())) {
            if (!(parent instanceof TableRowGroupBase)) continue;
            return true;
        }
        return false;
    }

    private void iterate(FacesContext context, PhaseId phaseId) {
        if (this.isNestedWithinTableRowGroup()) {
            this.clear();
        }
        this.setRowKey(null);
        Iterator facets = this.getFacets().keySet().iterator();
        while (facets.hasNext()) {
            UIComponent facet = (UIComponent)this.getFacets().get(facets.next());
            if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                facet.processDecodes(context);
                continue;
            }
            if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                facet.processValidators(context);
                continue;
            }
            if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                facet.processUpdates(context);
                continue;
            }
            this.log("iterate", "Cannot process component facets, Invalid phase ID");
            throw new IllegalArgumentException();
        }
        this.setRowKey(null);
        Iterator kids = this.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumnBase kid = (TableColumnBase)((Object)kids.next());
            if (!kid.isRendered()) {
                this.log("iterate", "Cannot process TableColumnBase facets, TableColumnBase not rendered");
                continue;
            }
            this.iterateTableColumnFacets(context, kid, phaseId);
        }
        RowKey[] rowKeys = this.getRenderedRowKeys();
        if (rowKeys == null) {
            this.log("iterate", "Cannot iterate over TableColumnBase children, RowKey array is null");
            return;
        }
        for (int i = 0; i < rowKeys.length; ++i) {
            this.setRowKey(rowKeys[i]);
            if (!this.isRowAvailable()) {
                this.log("iterate", "Cannot iterate over TableColumnBase children, row not available");
                break;
            }
            kids = this.getTableColumnChildren();
            while (kids.hasNext()) {
                TableColumnBase kid = (TableColumnBase)((Object)kids.next());
                if (!kid.isRendered()) {
                    this.log("iterate", "Cannot process TableColumnBase, not rendered");
                    continue;
                }
                for (UIComponent grandkid : kid.getChildren()) {
                    if (!grandkid.isRendered()) {
                        this.log("iterate", "Cannot process TableColumnBase child, not rendered");
                        continue;
                    }
                    this.iterateTableColumnChildren(context, grandkid, phaseId);
                }
            }
        }
        this.setRowKey(null);
    }

    private void iterateTableColumnFacets(FacesContext context, TableColumnBase component, PhaseId phaseId) {
        if (component == null) {
            this.log("iterateTableColumnFacets", "Cannot iterate over TableColumnBase facets, TableColumnBase is null");
            return;
        }
        Iterator kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumnBase col = (TableColumnBase)((Object)kids.next());
                this.iterateTableColumnFacets(context, col, phaseId);
            }
        } else {
            Iterator facets = component.getFacets().keySet().iterator();
            while (facets.hasNext()) {
                UIComponent facet = (UIComponent)component.getFacets().get(facets.next());
                if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                    facet.processDecodes(context);
                    continue;
                }
                if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                    facet.processValidators(context);
                    continue;
                }
                if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                    facet.processUpdates(context);
                    continue;
                }
                this.log("iterateTableColumnFacets", "Cannot iterate over TableColumnBase facets, Invalid phase ID");
                throw new IllegalArgumentException();
            }
        }
    }

    private void iterateTableColumnChildren(FacesContext context, UIComponent component, PhaseId phaseId) {
        if (component == null) {
            this.log("iterateTableColumnChildren", "Cannot iterate over TableColumnBase children, UIComponent is null");
            return;
        }
        if (component instanceof TableColumnBase) {
            Iterator kids = component.getChildren().iterator();
            if (kids.hasNext()) {
                while (kids.hasNext()) {
                    UIComponent kid = (UIComponent)kids.next();
                    this.iterateTableColumnChildren(context, kid, phaseId);
                }
            }
        } else if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
            component.processDecodes(context);
        } else if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
            component.processValidators(context);
        } else if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            component.processUpdates(context);
        } else {
            this.log("iterateTableColumnBaseChildren", "Cannot iterate over TableColumnBase children, Invalid phase ID");
            throw new IllegalArgumentException();
        }
    }

    private boolean keepSaved(FacesContext context) {
        for (String clientId : this.saved.keySet()) {
            SavedState state = (SavedState)this.saved.get(clientId);
            if (state == null || state.getSubmittedValue() == null) continue;
            return true;
        }
        Iterator messages = context.getMessages();
        while (messages.hasNext()) {
            FacesMessage message = (FacesMessage)messages.next();
            if (message.getSeverity().compareTo((Object)FacesMessage.SEVERITY_ERROR) < 0) continue;
            return true;
        }
        return this.isNestedWithinTableRowGroup();
    }

    private void log(String method, String message) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }

    private void restoreDescendantState() {
        FacesContext context = this.getFacesContext();
        Iterator kids = this.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumnBase kid = (TableColumnBase)((Object)kids.next());
            if (!kid.isRendered()) continue;
            this.restoreDescendantState((UIComponent)kid, context);
        }
    }

    private void restoreDescendantState(UIComponent component, FacesContext context) {
        String id = component.getId();
        component.setId(id);
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            String clientId = component.getClientId(context);
            SavedState state = (SavedState)this.saved.get(clientId);
            if (state == null) {
                state = new SavedState();
            }
            input.setValue(state.getValue());
            input.setValid(state.isValid());
            input.setSubmittedValue(state.getSubmittedValue());
            input.setLocalValueSet(state.isLocalValueSet());
            ConversionUtilities.restoreRenderedValueState(context, component);
        }
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            this.restoreDescendantState((UIComponent)kids.next(), context);
        }
    }

    private void saveDescendantState() {
        FacesContext context = this.getFacesContext();
        Iterator kids = this.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumnBase kid = (TableColumnBase)((Object)kids.next());
            if (!kid.isRendered()) {
                this.log("saveDescendantState", "Cannot save descendant state, TableColumnBase not rendered");
                continue;
            }
            this.saveDescendantState((UIComponent)kid, context);
        }
    }

    private void saveDescendantState(UIComponent component, FacesContext context) {
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            String clientId = component.getClientId(context);
            SavedState state = (SavedState)this.saved.get(clientId);
            if (state == null) {
                state = new SavedState();
                this.saved.put(clientId, state);
            }
            state.setValue(input.getLocalValue());
            state.setValid(input.isValid());
            state.setSubmittedValue(input.getSubmittedValue());
            state.setLocalValueSet(input.isLocalValueSet());
            ConversionUtilities.saveRenderedValueState(context, component);
        }
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            this.saveDescendantState((UIComponent)kids.next(), context);
        }
    }

    public String getAlign() {
        if (this.align != null) {
            return this.align;
        }
        ValueExpression _vb = this.getValueExpression("align");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public String getBgColor() {
        if (this.bgColor != null) {
            return this.bgColor;
        }
        ValueExpression _vb = this.getValueExpression("bgColor");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setBgColor(String bgColor) {
        this.bgColor = bgColor;
    }

    public String getChar() {
        if (this._char != null) {
            return this._char;
        }
        ValueExpression _vb = this.getValueExpression("char");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setChar(String _char) {
        this._char = _char;
    }

    public String getCharOff() {
        if (this.charOff != null) {
            return this.charOff;
        }
        ValueExpression _vb = this.getValueExpression("charOff");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setCharOff(String charOff) {
        this.charOff = charOff;
    }

    public boolean isCollapsed() {
        if (this.collapsed_set) {
            return this.collapsed;
        }
        ValueExpression _vb = this.getValueExpression("collapsed");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
        this.collapsed_set = true;
    }

    public String getEmptyDataMsg() {
        if (this.emptyDataMsg != null) {
            return this.emptyDataMsg;
        }
        ValueExpression _vb = this.getValueExpression("emptyDataMsg");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setEmptyDataMsg(String emptyDataMsg) {
        this.emptyDataMsg = emptyDataMsg;
    }

    private int _getFirst() {
        if (this.first_set) {
            return this.first;
        }
        ValueExpression _vb = this.getValueExpression("first");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)_result;
        }
        return 0;
    }

    private void _setFirst(int first) {
        this.first = first;
        this.first_set = true;
    }

    public boolean isGroupToggleButton() {
        if (this.groupToggleButton_set) {
            return this.groupToggleButton;
        }
        ValueExpression _vb = this.getValueExpression("groupToggleButton");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setGroupToggleButton(boolean groupToggleButton) {
        this.groupToggleButton = groupToggleButton;
        this.groupToggleButton_set = true;
    }

    public String getHeaderText() {
        if (this.headerText != null) {
            return this.headerText;
        }
        ValueExpression _vb = this.getValueExpression("headerText");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setHeaderText(String headerText) {
        this.headerText = headerText;
    }

    public String getOnClick() {
        if (this.onClick != null) {
            return this.onClick;
        }
        ValueExpression _vb = this.getValueExpression("onClick");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnClick(String onClick) {
        this.onClick = onClick;
    }

    public String getOnDblClick() {
        if (this.onDblClick != null) {
            return this.onDblClick;
        }
        ValueExpression _vb = this.getValueExpression("onDblClick");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnDblClick(String onDblClick) {
        this.onDblClick = onDblClick;
    }

    public String getOnKeyDown() {
        if (this.onKeyDown != null) {
            return this.onKeyDown;
        }
        ValueExpression _vb = this.getValueExpression("onKeyDown");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyDown(String onKeyDown) {
        this.onKeyDown = onKeyDown;
    }

    public String getOnKeyPress() {
        if (this.onKeyPress != null) {
            return this.onKeyPress;
        }
        ValueExpression _vb = this.getValueExpression("onKeyPress");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyPress(String onKeyPress) {
        this.onKeyPress = onKeyPress;
    }

    public String getOnKeyUp() {
        if (this.onKeyUp != null) {
            return this.onKeyUp;
        }
        ValueExpression _vb = this.getValueExpression("onKeyUp");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyUp(String onKeyUp) {
        this.onKeyUp = onKeyUp;
    }

    public String getOnMouseDown() {
        if (this.onMouseDown != null) {
            return this.onMouseDown;
        }
        ValueExpression _vb = this.getValueExpression("onMouseDown");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseDown(String onMouseDown) {
        this.onMouseDown = onMouseDown;
    }

    public String getOnMouseMove() {
        if (this.onMouseMove != null) {
            return this.onMouseMove;
        }
        ValueExpression _vb = this.getValueExpression("onMouseMove");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseMove(String onMouseMove) {
        this.onMouseMove = onMouseMove;
    }

    public String getOnMouseOut() {
        if (this.onMouseOut != null) {
            return this.onMouseOut;
        }
        ValueExpression _vb = this.getValueExpression("onMouseOut");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseOut(String onMouseOut) {
        this.onMouseOut = onMouseOut;
    }

    public String getOnMouseOver() {
        if (this.onMouseOver != null) {
            return this.onMouseOver;
        }
        ValueExpression _vb = this.getValueExpression("onMouseOver");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseOver(String onMouseOver) {
        this.onMouseOver = onMouseOver;
    }

    public String getOnMouseUp() {
        if (this.onMouseUp != null) {
            return this.onMouseUp;
        }
        ValueExpression _vb = this.getValueExpression("onMouseUp");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseUp(String onMouseUp) {
        this.onMouseUp = onMouseUp;
    }

    private int _getRows() {
        if (this.rows_set) {
            return this.rows;
        }
        ValueExpression _vb = this.getValueExpression("rows");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)_result;
        }
        return 25;
    }

    private void _setRows(int rows) {
        this.rows = rows;
        this.rows_set = true;
    }

    public boolean isSelectMultipleToggleButton() {
        if (this.selectMultipleToggleButton_set) {
            return this.selectMultipleToggleButton;
        }
        ValueExpression _vb = this.getValueExpression("selectMultipleToggleButton");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setSelectMultipleToggleButton(boolean selectMultipleToggleButton) {
        this.selectMultipleToggleButton = selectMultipleToggleButton;
        this.selectMultipleToggleButton_set = true;
    }

    public boolean isSelected() {
        if (this.selected_set) {
            return this.selected;
        }
        ValueExpression _vb = this.getValueExpression("selected");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.selected_set = true;
    }

    public Object getSourceData() {
        if (this.sourceData != null) {
            return this.sourceData;
        }
        ValueExpression _vb = this.getValueExpression("sourceData");
        if (_vb != null) {
            return _vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    private void _setSourceData(Object sourceData) {
        this.sourceData = sourceData;
    }

    public String getSourceVar() {
        if (this.sourceVar != null) {
            return this.sourceVar;
        }
        ValueExpression _vb = this.getValueExpression("sourceVar");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setSourceVar(String sourceVar) {
        this.sourceVar = sourceVar;
    }

    public String getStyleClasses() {
        if (this.styleClasses != null) {
            return this.styleClasses;
        }
        ValueExpression _vb = this.getValueExpression("styleClasses");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClasses(String styleClasses) {
        this.styleClasses = styleClasses;
    }

    private TableDataFilter _getTableDataFilter() {
        if (this.tableDataFilter != null) {
            return this.tableDataFilter;
        }
        ValueExpression _vb = this.getValueExpression("tableDataFilter");
        if (_vb != null) {
            return (TableDataFilter)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    private void _setTableDataFilter(TableDataFilter tableDataFilter) {
        this.tableDataFilter = tableDataFilter;
    }

    private TableDataSorter _getTableDataSorter() {
        if (this.tableDataSorter != null) {
            return this.tableDataSorter;
        }
        ValueExpression _vb = this.getValueExpression("tableDataSorter");
        if (_vb != null) {
            return (TableDataSorter)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    private void _setTableDataSorter(TableDataSorter tableDataSorter) {
        this.tableDataSorter = tableDataSorter;
    }

    public String getToolTip() {
        if (this.toolTip != null) {
            return this.toolTip;
        }
        ValueExpression _vb = this.getValueExpression("toolTip");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    public String getValign() {
        if (this.valign != null) {
            return this.valign;
        }
        ValueExpression _vb = this.getValueExpression("valign");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setValign(String valign) {
        this.valign = valign;
    }

    public boolean isVisible() {
        if (this.visible_set) {
            return this.visible;
        }
        ValueExpression _vb = this.getValueExpression("visible");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return true;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.visible_set = true;
    }

    private void _restoreState(FacesContext _context, Object _state) {
        Object[] _values = (Object[])_state;
        super.restoreState(_context, _values[0]);
        this.align = (String)_values[1];
        this.bgColor = (String)_values[2];
        this._char = (String)_values[3];
        this.charOff = (String)_values[4];
        this.collapsed = (Boolean)_values[5];
        this.collapsed_set = (Boolean)_values[6];
        this.emptyDataMsg = (String)_values[7];
        this.first = (Integer)_values[8];
        this.first_set = (Boolean)_values[9];
        this.groupToggleButton = (Boolean)_values[10];
        this.groupToggleButton_set = (Boolean)_values[11];
        this.headerText = (String)_values[12];
        this.onClick = (String)_values[13];
        this.onDblClick = (String)_values[14];
        this.onKeyDown = (String)_values[15];
        this.onKeyPress = (String)_values[16];
        this.onKeyUp = (String)_values[17];
        this.onMouseDown = (String)_values[18];
        this.onMouseMove = (String)_values[19];
        this.onMouseOut = (String)_values[20];
        this.onMouseOver = (String)_values[21];
        this.onMouseUp = (String)_values[22];
        this.rows = (Integer)_values[23];
        this.rows_set = (Boolean)_values[24];
        this.selectMultipleToggleButton = (Boolean)_values[25];
        this.selectMultipleToggleButton_set = (Boolean)_values[26];
        this.selected = (Boolean)_values[27];
        this.selected_set = (Boolean)_values[28];
        this.sourceData = (TableDataProvider)_values[29];
        this.sourceVar = (String)_values[30];
        this.styleClasses = (String)_values[31];
        this.tableDataFilter = (TableDataFilter)_values[32];
        this.tableDataSorter = (TableDataSorter)_values[33];
        this.toolTip = (String)_values[34];
        this.valign = (String)_values[35];
        this.visible = (Boolean)_values[36];
        this.visible_set = (Boolean)_values[37];
    }

    private Object _saveState(FacesContext _context) {
        Object[] _values = new Object[]{super.saveState(_context), this.align, this.bgColor, this._char, this.charOff, this.collapsed ? Boolean.TRUE : Boolean.FALSE, this.collapsed_set ? Boolean.TRUE : Boolean.FALSE, this.emptyDataMsg, new Integer(this.first), this.first_set ? Boolean.TRUE : Boolean.FALSE, this.groupToggleButton ? Boolean.TRUE : Boolean.FALSE, this.groupToggleButton_set ? Boolean.TRUE : Boolean.FALSE, this.headerText, this.onClick, this.onDblClick, this.onKeyDown, this.onKeyPress, this.onKeyUp, this.onMouseDown, this.onMouseMove, this.onMouseOut, this.onMouseOver, this.onMouseUp, new Integer(this.rows), this.rows_set ? Boolean.TRUE : Boolean.FALSE, this.selectMultipleToggleButton ? Boolean.TRUE : Boolean.FALSE, this.selectMultipleToggleButton_set ? Boolean.TRUE : Boolean.FALSE, this.selected ? Boolean.TRUE : Boolean.FALSE, this.selected_set ? Boolean.TRUE : Boolean.FALSE, this.sourceData, this.sourceVar, this.styleClasses, this.tableDataFilter, this.tableDataSorter, this.toolTip, this.valign, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visible_set ? Boolean.TRUE : Boolean.FALSE};
        return _values;
    }
}

