/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.ContentPageTitle;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class ContentPageTitleRenderer
extends Renderer {
    public static final String BOTTOM_ID = "_bottom";

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        String styleClass;
        ContentPageTitle pagetitle = (ContentPageTitle)component;
        Theme theme = ThemeUtilities.getTheme(context);
        ResponseWriter writer = context.getResponseWriter();
        String style = pagetitle.getStyle();
        writer.startElement("div", (UIComponent)pagetitle);
        writer.writeAttribute("id", (Object)pagetitle.getClientId(context), "id");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if ((styleClass = RenderingUtilities.getStyleClasses(context, component, null)) != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        this.startLayoutTable(writer, pagetitle, "bottom", true, null, "bottom");
        this.renderPageTitle(context, pagetitle, writer, theme);
        UIComponent facet = pagetitle.getFacet("pageButtonsTop");
        if (facet != null && facet.isRendered()) {
            this.renderPageButtons(context, pagetitle, writer, theme.getStyleClass("TITLE_BUTTON_DIV"), facet);
        }
        this.endLayoutTable(writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        boolean showViews;
        ContentPageTitle pagetitle = (ContentPageTitle)component;
        ResponseWriter writer = context.getResponseWriter();
        Theme theme = ThemeUtilities.getTheme(context);
        if (pagetitle.getHelpText() != null || pagetitle.getFacet("pageHelp") != null) {
            this.renderPageHelp(context, pagetitle, theme, writer);
        }
        boolean showActions = pagetitle.getFacet("pageActions") != null;
        boolean bl = showViews = pagetitle.getFacet("pageViews") != null;
        if (showActions || showViews) {
            String tdAlign = null;
            if (!showActions) {
                tdAlign = "right";
            }
            this.startLayoutTable(writer, pagetitle, "bottom", true, tdAlign, "bottom");
            if (showActions) {
                this.renderPageActions(context, pagetitle, theme, writer);
            }
            if (showViews) {
                if (showActions) {
                    writer.startElement("td", (UIComponent)pagetitle);
                    writer.writeAttribute("align", (Object)"right", null);
                    writer.writeAttribute("valign", (Object)"bottom", null);
                    writer.writeAttribute("nowrap", (Object)"nowrap", null);
                }
                this.renderPageViews(context, pagetitle, theme, writer);
            }
            writer.endElement("td");
            this.endLayoutTable(writer);
        }
        super.encodeChildren(context, component);
    }

    protected void renderPageActions(FacesContext context, ContentPageTitle pagetitle, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent pageActions = pagetitle.getFacet("pageActions");
        if (pageActions == null) {
            return;
        }
        writer.startElement("div", (UIComponent)pagetitle);
        writer.writeAttribute("class", (Object)theme.getStyleClass("TITLE_ACTION_DIV"), null);
        RenderingUtilities.renderComponent(pageActions, context);
        writer.endElement("div");
    }

    protected void renderPageViews(FacesContext context, ContentPageTitle pagetitle, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent pageViews = pagetitle.getFacet("pageViews");
        if (pageViews == null) {
            return;
        }
        writer.startElement("div", (UIComponent)pagetitle);
        writer.writeAttribute("class", (Object)theme.getStyleClass("TITLE_VIEW_DIV"), null);
        RenderingUtilities.renderComponent(pageViews, context);
        writer.endElement("div");
    }

    private void startLayoutTable(ResponseWriter writer, ContentPageTitle pagetitle, String firstRowValign, boolean noWrapTd, String firstTdAlign, String firstTdValign) throws IOException {
        writer.startElement("table", (UIComponent)pagetitle);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("width", (Object)"100%", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.startElement("tr", (UIComponent)pagetitle);
        if (firstRowValign != null) {
            writer.writeAttribute("valign", (Object)firstRowValign, null);
        }
        writer.startElement("td", (UIComponent)pagetitle);
        if (noWrapTd) {
            writer.writeAttribute("nowrap", (Object)"nowrap", null);
        }
        if (firstTdAlign != null) {
            writer.writeAttribute("align", (Object)firstTdAlign, null);
        }
        if (firstTdValign != null) {
            writer.writeAttribute("valign", (Object)firstTdValign, null);
        }
    }

    private void endLayoutTable(ResponseWriter writer) throws IOException {
        writer.endElement("tr");
        writer.endElement("table");
    }

    protected void renderPageTitle(FacesContext context, ContentPageTitle pagetitle, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("div", (UIComponent)pagetitle);
        String style = theme.getStyleClass("TITLE_TEXT_DIV");
        writer.writeAttribute("class", (Object)style, null);
        if (pagetitle.getFacet("pageTitle") != null) {
            RenderingUtilities.renderComponent(pagetitle.getFacet("pageTitle"), context);
        } else {
            writer.startElement("h1", (UIComponent)pagetitle);
            style = theme.getStyleClass("TITLE_TEXT");
            writer.writeAttribute("class", (Object)style, null);
            String title = pagetitle.getTitle();
            writer.write(title != null ? title : "");
            writer.endElement("h1");
        }
        writer.endElement("div");
        writer.endElement("td");
    }

    protected void renderPageHelp(FacesContext context, ContentPageTitle pagetitle, Theme theme, ResponseWriter writer) throws IOException {
        this.startLayoutTable(writer, pagetitle, null, false, null, null);
        writer.startElement("div", (UIComponent)pagetitle);
        String style = theme.getStyleClass("TITLE_HELP_DIV");
        writer.writeAttribute("class", (Object)style, null);
        UIComponent helpFacet = pagetitle.getFacet("pageHelp");
        if (helpFacet != null) {
            RenderingUtilities.renderComponent(helpFacet, context);
        } else {
            writer.startElement("div", (UIComponent)pagetitle);
            style = theme.getStyleClass("HELP_PAGE_TEXT");
            writer.writeAttribute("class", (Object)style, null);
            writer.write(pagetitle.getHelpText());
            writer.endElement("div");
        }
        writer.endElement("div");
        writer.endElement("td");
        this.endLayoutTable(writer);
    }

    protected void renderPageButtons(FacesContext context, ContentPageTitle pagetitle, ResponseWriter writer, String divStyle, UIComponent buttonFacet) throws IOException {
        if (buttonFacet == null) {
            return;
        }
        writer.startElement("td", (UIComponent)pagetitle);
        writer.writeAttribute("align", (Object)"right", null);
        writer.writeAttribute("nowrap", (Object)"nowrap", null);
        writer.writeAttribute("valign", (Object)"bottom", null);
        writer.startElement("div", (UIComponent)pagetitle);
        writer.writeAttribute("class", (Object)divStyle, null);
        RenderingUtilities.renderComponent(buttonFacet, context);
        writer.endElement("div");
        writer.endElement("td");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ContentPageTitle pagetitle = (ContentPageTitle)component;
        Theme theme = ThemeUtilities.getTheme(context);
        ResponseWriter writer = context.getResponseWriter();
        UIComponent facet = pagetitle.getFacet("pageButtonsBottom");
        if (facet != null && facet.isRendered()) {
            if (pagetitle.isSeparator()) {
                this.renderPageSeparator(context, pagetitle, theme, writer);
            }
            writer.startElement("table", (UIComponent)pagetitle);
            writer.writeAttribute("border", (Object)"0", null);
            writer.writeAttribute("width", (Object)"100%", null);
            writer.writeAttribute("cellpadding", (Object)"0", null);
            writer.writeAttribute("cellspacing", (Object)"0", null);
            writer.startElement("tr", (UIComponent)pagetitle);
            String style = theme.getStyleClass("TITLE_BUTTON_BOTTOM_DIV");
            this.renderPageButtons(context, pagetitle, writer, style, facet);
            this.endLayoutTable(writer);
        }
        writer.endElement("div");
    }

    protected void renderPageSeparator(FacesContext context, ContentPageTitle pagetitle, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent separatorFacet = pagetitle.getBottomPageSeparator();
        if (separatorFacet != null) {
            RenderingUtilities.renderComponent(separatorFacet, context);
        }
    }

    private void writeDotImage(ResponseWriter writer, ContentPageTitle pagetitle, String src, int height, int width) throws IOException {
        writer.startElement("img", (UIComponent)pagetitle);
        writer.writeAttribute("src", (Object)src, null);
        writer.writeAttribute("alt", (Object)"", null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("height", (Object)new Integer(height), null);
        writer.writeAttribute("width", (Object)new Integer(width), null);
        writer.endElement("img");
    }
}

