/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.Calendar;
import com.sun.webui.jsf.component.CalendarMonth;
import com.sun.webui.jsf.component.ImageHyperlink;
import com.sun.webui.jsf.renderkit.widget.TextFieldRenderer;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.WidgetUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.json.JSONException;
import org.json.JSONObject;

public class CalendarRenderer
extends TextFieldRenderer {
    protected JSONObject getProperties(FacesContext context, UIComponent component) throws IOException, JSONException {
        if (!(component instanceof Calendar)) {
            throw new IllegalArgumentException("CalendarRenderer can only render Calendar components.");
        }
        Calendar calendar = (Calendar)component;
        Theme theme = this.getTheme();
        JSONObject json = super.getProperties(context, component);
        String patternHelp = calendar.getDateFormatPatternHelp();
        if (patternHelp != null) {
            json.put("patternHelp", (Object)patternHelp);
        }
        CalendarMonth calendarMonth = calendar.getDatePicker();
        Object value = calendar.getSubmittedValue();
        if (value != null) {
            try {
                Object dO = ConversionUtilities.convertValueToObject((UIComponent)calendar, (String)value, context);
                calendarMonth.setValue(dO);
            }
            catch (Exception ex) {}
        } else if (calendar.getValue() != null) {
            calendarMonth.setValue(calendar.getValue());
        }
        calendarMonth.initCalendarControls(calendar.getJavaScriptObjectName(context));
        JSONObject jsonCal = WidgetUtilities.renderComponent(context, (UIComponent)calendarMonth);
        json.put("calendar", (Object)jsonCal);
        UIComponent comp = calendar.getFacet("datePickerLink");
        if (comp instanceof ImageHyperlink) {
            jsonCal.put("toggleLink", (Object)WidgetUtilities.renderComponent(context, comp));
        }
        return json;
    }

    protected String getWidgetType(FacesContext context, UIComponent component) {
        return JavaScriptUtilities.getModuleName("widget.calendarField");
    }
}

