/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.Checkbox;
import com.sun.webui.jsf.component.CheckboxGroup;
import com.sun.webui.jsf.component.RbCbSelector;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.renderkit.widget.SelectorGroupRenderer;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.json.JSONException;
import org.json.JSONObject;

public class CheckboxGroupRenderer
extends SelectorGroupRenderer {
    protected JSONObject getProperties(FacesContext context, UIComponent component) throws JSONException, IOException {
        if (!(component instanceof CheckboxGroup)) {
            throw new IllegalArgumentException("CheckboxGroupRenderer can only render CheckboxGroup components.");
        }
        CheckboxGroup cbGroup = (CheckboxGroup)component;
        JSONObject json = super.getProperties(context, cbGroup);
        json.put("columns", cbGroup.getColumns());
        return json;
    }

    protected String getWidgetType(FacesContext context, UIComponent component) {
        return JavaScriptUtilities.getModuleName("widget.checkboxGroup");
    }

    protected RbCbSelector createSelectorComponent() {
        return new Checkbox();
    }

    protected boolean isSelected(Option item, Object currentValue) {
        Object value = item.getValue();
        if (value == null || currentValue == null) {
            return false;
        }
        if (currentValue instanceof Map) {
            return ((Map)currentValue).containsValue(value);
        }
        if (currentValue instanceof Collection) {
            return ((Collection)currentValue).contains(value);
        }
        if (currentValue instanceof Object[]) {
            Object[] selectedValues = (Object[])currentValue;
            for (int i = 0; i < selectedValues.length; ++i) {
                if (!value.equals(selectedValues[i])) continue;
                return true;
            }
        }
        return false;
    }
}

