/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.ProgressBar;
import com.sun.webui.jsf.component.TextArea;
import com.sun.webui.jsf.renderkit.widget.RendererBase;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.WidgetUtilities;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.json.JSONException;
import org.json.JSONObject;

public class ProgressBarRenderer
extends RendererBase {
    private static final String[] stringAttributes = new String[]{"style"};
    private static final String[] intAttributes = new String[]{"progress", "width", "height", "refreshRate"};

    protected JSONObject getProperties(FacesContext context, UIComponent component) throws IOException, JSONException {
        if (!(component instanceof ProgressBar)) {
            throw new IllegalArgumentException("ProgressBarRenderer can only render ProgressBar components.");
        }
        ProgressBar progressBar = (ProgressBar)component;
        JSONObject json = new JSONObject();
        String prefix = context.getExternalContext().getRequestContextPath();
        json.put("failedStateText", (Object)progressBar.getFailedStateText()).put("logMessage", (Object)progressBar.getLogMessage()).put("overlayAnimation", progressBar.isOverlayAnimation()).put("percentChar", (Object)this.getTheme().getMessage("ProgressBar.percentChar")).put("progressImageUrl", (Object)progressBar.getProgressImageUrl()).put("taskState", (Object)progressBar.getTaskState()).put("toolTip", (Object)(progressBar.getToolTip() != null ? progressBar.getToolTip() : this.getTheme().getMessage("ProgressBar.toolTip"))).put("type", (Object)progressBar.getType()).put("className", (Object)progressBar.getStyleClass()).put("prefix", (Object)prefix).put("refreshRate", progressBar.getRefreshRate()).put("visible", progressBar.isVisible());
        JSONUtilities.addStringProperties(stringAttributes, component, json);
        JSONUtilities.addIntegerProperties(intAttributes, component, json);
        this.setFacetProperties(context, progressBar, json);
        return json;
    }

    protected String getWidgetType(FacesContext context, UIComponent component) {
        return JavaScriptUtilities.getModuleName("widget.progressBar");
    }

    private void setFacetProperties(FacesContext context, ProgressBar component, JSONObject json) throws IOException, JSONException {
        UIComponent bottomTextFacet;
        ProgressBar pb;
        UIComponent rightButtonCon = component.getFacet("progressControlRight");
        UIComponent bottomButtonCon = component.getFacet("progressControlBottom");
        if (rightButtonCon != null) {
            json.put("progressControlRight", (Object)WidgetUtilities.renderComponent(context, rightButtonCon));
        }
        if (bottomButtonCon != null) {
            json.put("progressControlBottom", (Object)WidgetUtilities.renderComponent(context, bottomButtonCon));
        }
        if ((pb = component).getLogMessage() != null) {
            TextArea textArea = (TextArea)pb.getLogMsgComponent(component);
            json.put("log", (Object)WidgetUtilities.renderComponent(context, (UIComponent)textArea));
            json.put("logId", (Object)textArea.getClientId(context));
        }
        if ((bottomTextFacet = component.getFacet("progressTextBottom")) != null) {
            json.put("bottomText", (Object)WidgetUtilities.renderComponent(context, bottomTextFacet));
        } else {
            json.put("bottomText", (Object)pb.getStatus());
        }
        UIComponent topTextFacet = component.getFacet("progressTextTop");
        if (topTextFacet != null) {
            json.put("topText", (Object)WidgetUtilities.renderComponent(context, topTextFacet));
        } else {
            json.put("topText", (Object)pb.getDescription());
        }
    }
}

