/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.TextField;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.renderkit.widget.FieldRendererBase;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.WidgetUtilities;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TextFieldRenderer
extends FieldRendererBase {
    private static final String[] stringAttributes = new String[]{"align", "dir", "lang", "style", "accessKey", "onMouseDown", "onMouseOut", "onMouseOver", "onMouseUp", "onMouseMove", "onClick", "onChange", "onSelect", "onFocus", "onBlur", "onDblClick", "onKeyDown", "onKeyPress", "onKeyUp"};
    private static final String[] intAttributes = new String[]{"maxLength", "tabIndex"};

    protected JSONObject getProperties(FacesContext context, UIComponent component) throws IOException, JSONException {
        UIComponent labelFacet;
        if (!(component instanceof TextField)) {
            throw new IllegalArgumentException("TextFieldRenderer can only render TextField components.");
        }
        TextField field = (TextField)component;
        if (field.getSubmittedValue() == null) {
            ConversionUtilities.setRenderedValue(component, field.getText());
        }
        String className = field.getStyleClass();
        JSONObject json = new JSONObject();
        json.put("disabled", field.isDisabled()).put("value", (Object)field.getValueAsString(context)).put("required", field.isRequired()).put("readOnly", field.isReadOnly()).put("valid", field.isValid()).put("className", (Object)className).put("size", field.getColumns()).put("visible", field.isVisible()).put("title", (Object)field.getToolTip()).put("autoComplete", field.isAutoComplete()).put("autoValidate", field.isAutoValidate());
        if (field.isSubmitFormSet()) {
            json.put("submitForm", field.isSubmitForm());
        }
        if ((labelFacet = field.getFacet("label")) != null) {
            json.put("label", (Object)WidgetUtilities.renderComponent(context, labelFacet));
        } else if (field.getLabel() != null) {
            json.put("label", (Object)this.getLabel(context, field));
        }
        JSONUtilities.addStringProperties(stringAttributes, component, json);
        JSONUtilities.addIntegerProperties(intAttributes, component, json);
        this.setNotifyProperties(context, component, json);
        return json;
    }

    protected String getWidgetType(FacesContext context, UIComponent component) {
        return JavaScriptUtilities.getModuleName("widget.textField");
    }

    protected Option[] getListItems(TextField field, String value, FacesContext context) {
        if (field == null || context == null) {
            return null;
        }
        Object optionsObject = null;
        MethodExpression filterMethod = field.getAutoCompleteExpression();
        if (filterMethod == null) {
            throw new RuntimeException("autoCompleteExpression must not be null");
        }
        optionsObject = filterMethod.invoke(context.getELContext(), new Object[]{value});
        if (optionsObject == null) {
            return null;
        }
        if (optionsObject instanceof Option[]) {
            return (Option[])optionsObject;
        }
        if (optionsObject instanceof Collection) {
            try {
                return ((Collection)optionsObject).toArray(new Option[0]);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (optionsObject instanceof Map) {
            try {
                return ((Map)optionsObject).values().toArray(new Option[0]);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    protected void setNotifyProperties(FacesContext context, UIComponent component, JSONObject json) throws IOException, JSONException {
        TextField field = (TextField)component;
        String notify = field.getNotify();
        if (notify == null) {
            return;
        }
        JSONArray jArray = new JSONArray();
        json.put("notify", (Object)jArray);
        StringTokenizer st = new StringTokenizer(notify, ",");
        while (st.hasMoreTokens()) {
            jArray.put((Object)st.nextToken());
        }
    }
}

