/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.theme;

import com.sun.webui.theme.ResourceBundleTheme;
import com.sun.webui.theme.Theme;
import com.sun.webui.theme.ThemeConfigurationException;
import com.sun.webui.theme.ThemeContext;
import com.sun.webui.theme.ThemeFactory;
import com.sun.webui.theme.ThemeLogger;
import com.sun.webui.theme.ThemeReference;
import com.sun.webui.theme.ThemeResourceBundle;
import com.sun.webui.theme.ThemeResources;
import com.sun.webui.theme.ThemeService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import sun.misc.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPIThemeFactory
implements ThemeFactory {
    private String defaultThemeName;
    private String defaultThemeVersion;
    private static final String DEFAULT_THEME_KEY = "APPLICATION_THEME";
    private Map<String, ArrayList<ThemeReference>> themeReferencesMap = new HashMap<String, ArrayList<ThemeReference>>();

    @Override
    public String getDefaultThemeName(ThemeContext themeContext) {
        return themeContext.getDefaultTheme() == null ? this.defaultThemeName : themeContext.getDefaultTheme();
    }

    @Override
    public Theme getTheme(Locale locale, ThemeContext themeContext) {
        return this.getTheme(locale, null, themeContext);
    }

    @Override
    public Theme getTheme(Locale locale, String version, ThemeContext themeContext) {
        return this.getTheme(null, version, locale, themeContext);
    }

    @Override
    public Theme getTheme(String themeName, Locale locale, ThemeContext themeContext) {
        return this.getTheme(themeName, null, locale, themeContext);
    }

    @Override
    public Theme getTheme(String themeName, String version, Locale locale, ThemeContext themeContext) {
        ThemeResources themeResources = this.getThemeResources(themeName, version, locale, themeContext);
        return ResourceBundleTheme.getInstance(themeResources);
    }

    protected ThemeReference[] getThemeReferences(String themeName, String version, ThemeContext themeContext) {
        if (this.themeReferencesMap.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        String[] keys = new String[4];
        String USCORE = "_";
        sb.append(DEFAULT_THEME_KEY).append(USCORE).append(DEFAULT_THEME_KEY);
        keys[i++] = sb.toString();
        sb.setLength(0);
        if (themeName != null) {
            sb.append(themeName).append(USCORE).append(DEFAULT_THEME_KEY);
            keys[i++] = sb.toString();
            sb.setLength(0);
        }
        if (version != null) {
            sb.append(DEFAULT_THEME_KEY).append(USCORE).append(version);
            keys[i++] = sb.toString();
            sb.setLength(0);
        }
        if (themeName != null && version != null) {
            sb.append(themeName).append(USCORE).append(version);
            keys[i++] = sb.toString();
            sb.setLength(0);
        } else if (version == null) {
            keys[i++] = themeName;
        } else if (themeName == null) {
            keys[i++] = version;
        }
        ArrayList<ThemeReference> allrefs = new ArrayList<ThemeReference>();
        for (String key : keys) {
            ArrayList<ThemeReference> trefs;
            if (key == null || (trefs = this.themeReferencesMap.get(key)) == null) continue;
            allrefs.addAll(trefs);
        }
        if (allrefs.size() == 0) {
            ThemeLogger.log(Level.SEVERE, "NO_THEME_NAME_VERSION_OR_DEFAULT", null, null);
            ThemeConfigurationException tfe = new ThemeConfigurationException("No theme name or version specified and no default theme resource available.");
            throw tfe;
        }
        ThemeReference[] refs = allrefs.toArray(new ThemeReference[allrefs.size()]);
        return refs;
    }

    protected void putThemeReferences(String key, ArrayList<ThemeReference> themeReferences) {
        this.themeReferencesMap.put(key, themeReferences);
    }

    protected ThemeResources getThemeResources(String themeName, String version, Locale locale, ThemeContext themeContext) {
        if (themeName == null && (themeName = themeContext.getDefaultTheme()) == null) {
            themeName = this.defaultThemeName;
        }
        if (version == null && (version = themeContext.getDefaultThemeVersion()) == null) {
            version = this.defaultThemeVersion;
        }
        ThemeReference[] themeReferences = null;
        try {
            themeReferences = this.getThemeReferences(themeName, version, themeContext);
        }
        catch (Exception e) {
            ThemeLogger.log(Level.FINEST, "Loading themes for the first time.", null, null);
        }
        if (themeReferences != null) {
            return new ThemeResources(themeReferences, themeName, version, locale, themeContext);
        }
        try {
            this.findThemeReferences(themeContext);
        }
        catch (Exception e) {
            this.findJarThemeResources(themeContext);
        }
        if (themeName == null) {
            themeName = this.defaultThemeName;
        }
        if (version == null) {
            version = this.defaultThemeVersion;
        }
        if ((themeReferences = this.getThemeReferences(themeName, version, themeContext)) == null) {
            ThemeLogger.log(Level.SEVERE, "NO_THEMES_FOUND", null, null);
            ThemeConfigurationException e = new ThemeConfigurationException("No themes found.");
            throw e;
        }
        return new ThemeResources(themeReferences, themeName, version, locale, themeContext);
    }

    protected void findThemeReferences(ThemeContext themeContext) {
        String[] basenames = themeContext.getThemeResources();
        if (basenames != null) {
            this.getThemes(basenames, themeContext.getDefaultClassLoader(), DEFAULT_THEME_KEY);
        }
        try {
            this.findThemeServiceReferences(themeContext.getDefaultClassLoader());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.themeReferencesMap.size() == 0) {
            ThemeLogger.log(Level.SEVERE, "NO_THEMES_FOUND", null, null);
            ThemeConfigurationException e = new ThemeConfigurationException("No themes found.");
            throw e;
        }
    }

    private void findThemeServiceReferences(ClassLoader classLoader) throws Exception {
        Class<?> themeService;
        try {
            themeService = classLoader.loadClass("com.sun.webui.theme.ThemeService");
        }
        catch (ClassNotFoundException cnfe) {
            ThemeLogger.log(Level.WARNING, "NO_SUCH_SERVICE", new Object[]{"com.sun.webui.theme.ThemeService"}, cnfe);
            throw cnfe;
        }
        catch (Exception e) {
            ThemeLogger.log(Level.WARNING, "NO_SUCH_SERVICE", new Object[]{"com.sun.webui.theme.ThemeService"}, e);
            throw e;
        }
        Iterator iterator = null;
        try {
            iterator = Service.providers(themeService);
        }
        catch (Exception e) {
            ThemeLogger.log(Level.SEVERE, e.getMessage(), null, e);
            throw e;
        }
        while (iterator.hasNext()) {
            ThemeService spi = (ThemeService)iterator.next();
            String[] basenames = spi.getThemeBundles();
            this.getThemes(basenames, classLoader, null);
        }
    }

    private void getThemes(String[] basenames, ClassLoader classLoader, String defaultThemeKey) {
        StringBuilder sb = new StringBuilder();
        for (String basename : basenames) {
            String version;
            String name;
            block16: {
                ResourceBundle bundle;
                block15: {
                    try {
                        bundle = ResourceBundle.getBundle(basename, Locale.getDefault(), classLoader);
                    }
                    catch (MissingResourceException mre) {
                        ThemeLogger.log(Level.WARNING, "NO_SUCH_THEME", new Object[]{basename}, mre);
                        continue;
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                    name = null;
                    try {
                        name = bundle.getString(ThemeResourceBundle.ThemeProperty.NAME.getKey());
                    }
                    catch (MissingResourceException mre) {
                        if (defaultThemeKey == null) break block15;
                        name = defaultThemeKey;
                    }
                }
                if (name == null || (name = name.trim()).length() == 0) {
                    ThemeLogger.log(Level.WARNING, "NO_THEME_PROPERTY", new Object[]{basename, ThemeResourceBundle.ThemeProperty.NAME.getKey()}, null);
                    continue;
                }
                version = null;
                try {
                    version = bundle.getString(ThemeResourceBundle.ThemeProperty.VERSION.getKey());
                    version = version.trim();
                }
                catch (MissingResourceException mre) {
                    if (defaultThemeKey == null) break block16;
                    version = defaultThemeKey;
                }
            }
            if (version == null || (version = version.trim()).length() == 0) {
                ThemeLogger.log(Level.WARNING, "NO_THEME_PROPERTY", new Object[]{basename, ThemeResourceBundle.ThemeProperty.VERSION.getKey()}, null);
                continue;
            }
            if (defaultThemeKey == null && this.defaultThemeName == null) {
                this.defaultThemeName = name;
                this.defaultThemeVersion = version;
            }
            sb.setLength(0);
            sb.append(name).append("_").append(version);
            ArrayList<ThemeReference> trefs = this.themeReferencesMap.get(sb.toString());
            if (trefs == null) {
                trefs = new ArrayList();
                this.putThemeReferences(sb.toString(), trefs);
                if (defaultThemeKey == null) {
                    if (name != null) {
                        this.putThemeReferences(name, trefs);
                    }
                    if (version != null) {
                        this.putThemeReferences(version, trefs);
                    }
                }
            }
            trefs.add(new ThemeReference(basename, classLoader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findJarThemeResources(ThemeContext themeContext) {
        ClassLoader classLoader = themeContext.getDefaultClassLoader();
        Enumeration<URL> manifests = null;
        try {
            manifests = classLoader.getResources("META-INF/MANIFEST.MF");
        }
        catch (IOException ioex) {
            return;
        }
        if (!manifests.hasMoreElements()) {
            return;
        }
        InputStream in = null;
        StringBuilder sb = new StringBuilder(32);
        String SLASH = "/";
        String USCORE = "_";
        while (manifests.hasMoreElements()) {
            URL url = manifests.nextElement();
            try {
                String prefix;
                in = url.openConnection().getInputStream();
                Manifest manifest = new Manifest(in);
                Attributes themeAttributes = manifest.getAttributes("com/sun/webui/jsf/theme/");
                if (themeAttributes == null) continue;
                String themeName = this.readAttribute(themeAttributes, "X-SJWUIC-Theme-Name");
                String version = this.readAttribute(themeAttributes, "X-SJWUIC-Theme-Version");
                if (themeName == null || version == null) continue;
                if (this.defaultThemeName == null) {
                    this.defaultThemeName = themeName;
                    this.defaultThemeVersion = version;
                }
                if (themeContext.getThemeServletContext() == null && (prefix = this.readAttribute(themeAttributes, "X-SJWUIC-Theme-Prefix")) != null) {
                    if (!prefix.startsWith(SLASH)) {
                        prefix = sb.append(SLASH).append(prefix).toString();
                        sb.setLength(0);
                    }
                    themeContext.setThemeServletContext(prefix);
                }
                sb.append(themeName).append(USCORE).append(version);
                ArrayList<ThemeReference> trefs = this.themeReferencesMap.get(sb.toString());
                if (trefs == null) {
                    trefs = new ArrayList();
                    this.putThemeReferences(sb.toString(), trefs);
                    this.putThemeReferences(themeName, trefs);
                    this.putThemeReferences(version, trefs);
                }
                sb.setLength(0);
                this.addThemeReference(trefs, themeAttributes, "X-SJWUIC-Theme-Messages", classLoader);
                this.addThemeReference(trefs, themeAttributes, "X-SJWUIC-Theme-Images", classLoader);
                this.addThemeReference(trefs, themeAttributes, "X-SJWUIC-Theme-JavaScript", classLoader);
                this.addThemeReference(trefs, themeAttributes, "X-SJWUIC-Theme-Stylesheets", classLoader);
                this.addThemeReference(trefs, themeAttributes, "X-SJWUIC-Theme-Templates", classLoader);
                this.addThemeReference(trefs, themeAttributes, "X-SJWUIC-Theme-ClassMapper", classLoader);
            }
            catch (Exception e) {}
            continue;
            finally {
                try {
                    in.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    private void addThemeReference(ArrayList<ThemeReference> trefs, Attributes themeAttributes, String reference, ClassLoader classLoader) {
        String basename = this.readAttribute(themeAttributes, reference);
        if (basename != null) {
            trefs.add(new ThemeReference(basename, classLoader));
        }
    }

    private String readAttribute(Attributes themeAttributes, String propName) {
        String name = themeAttributes.getValue(propName);
        if (name == null || (name = name.trim()).length() == 0) {
            return null;
        }
        return name;
    }
}

