/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util.buf;

import com.sun.grizzly.util.buf.ByteChunk;
import java.io.IOException;
import java.io.InputStream;

final class IntermediateInputStream
extends InputStream {
    byte[] buf;
    int pos;
    int len;
    int end;

    public final void close() throws IOException {
        throw new IOException("close() called - shouldn't happen ");
    }

    public final int read(byte[] cbuf, int off, int len) throws IOException {
        if (this.pos >= this.end) {
            return -1;
        }
        if (this.pos + len > this.end) {
            len = this.end - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, cbuf, off, len);
        this.pos += len;
        return len;
    }

    public final int read() throws IOException {
        return this.pos < this.end ? this.buf[this.pos++] & 0xFF : -1;
    }

    void setBuffer(byte[] b, int p, int l) {
        this.buf = b;
        this.pos = p;
        this.len = l;
        this.end = this.pos + this.len;
    }

    void setByteChunk(ByteChunk mb) {
        this.buf = mb.getBytes();
        this.pos = mb.getStart();
        this.len = mb.getLength();
        this.end = this.pos + this.len;
    }
}

