/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.panels.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DirectorySelector
extends JPanel {
    public static final String LAYOUT_CHANGED_PROPERTY = DirectorySelector.class.getName() + "#LAYOUT_CHANGED";
    public static final String PATH_PROPERTY = "path";
    private DocumentListener pathListener = new DocumentListener(){
        private String oldValue = "";

        public void changedUpdate(DocumentEvent documentEvent) {
            this.firePathChange(DirectorySelector.this.textPath.getText());
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.firePathChange(DirectorySelector.this.textPath.getText());
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.firePathChange(DirectorySelector.this.textPath.getText());
        }

        private void firePathChange(String string) {
            DirectorySelector.this.firePropertyChange(DirectorySelector.PATH_PROPERTY, this.oldValue, string);
            this.oldValue = string;
        }
    };
    private String label = NbBundle.getMessage(DirectorySelector.class, (String)"DirectorySelector.caption.text");
    private String initPath = "";
    private JPanel browsePanel;
    private JButton buttonBrowse;
    private JScrollPane hintScroller;
    private JTextPane labelHint;
    private JTextField textPath;

    public DirectorySelector() {
        this.initComponents();
    }

    private void initComponents() {
        this.browsePanel = new JPanel();
        this.textPath = new JTextField();
        this.buttonBrowse = new JButton();
        this.hintScroller = new JScrollPane();
        this.labelHint = new JTextPane();
        this.textPath.setText("null");
        this.textPath.getDocument().addDocumentListener(this.pathListener);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonBrowse, (String)"null");
        this.buttonBrowse.setMaximumSize(new Dimension(43, 23));
        this.buttonBrowse.setMinimumSize(new Dimension(43, 23));
        this.buttonBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectorySelector.this.buttonBrowseActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.browsePanel);
        this.browsePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.textPath, -1, 283, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.buttonBrowse, -2, 25, -2)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.buttonBrowse, -2, 18, -2).add((Component)this.textPath, -2, -1, -2)));
        this.textPath.getAccessibleContext().setAccessibleName("null");
        this.textPath.getAccessibleContext().setAccessibleDescription("null");
        this.buttonBrowse.getAccessibleContext().setAccessibleDescription("null");
        this.hintScroller.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.labelHint.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.labelHint.setContentType(NbBundle.getMessage(DirectorySelector.class, (String)"DirectorySelector.labelHint.contentType"));
        this.labelHint.setForeground(UIManager.getDefaults().getColor("EditorPane.inactiveForeground"));
        this.hintScroller.setViewportView(this.labelHint);
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.browsePanel, -1, -1, Short.MAX_VALUE).add(2, (Component)this.hintScroller, -1, 314, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.browsePanel, -2, -1, -2).addPreferredGap(0).add((Component)this.hintScroller, -1, 45, Short.MAX_VALUE)));
    }

    private void buttonBrowseActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        String string = this.getPath();
        if (string == null || string.length() == 0) {
            string = this.initPath;
        }
        File file = new File(string);
        jFileChooser.setCurrentDirectory(file);
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle(this.label);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            this.setPath(file2.getAbsolutePath());
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getPath() {
        return this.textPath.getText();
    }

    public void setPath(String string) {
        this.textPath.setText(string);
    }

    public void setInitialDir(String string) {
        this.initPath = string;
    }

    public String getInitialDir() {
        return this.initPath;
    }

    public String getHint() {
        return this.labelHint.getText();
    }

    public void setHint(String string) {
        this.labelHint.setText(string);
        if (string == null || string.length() == 0) {
            this.hintScroller.setVisible(false);
        } else {
            this.hintScroller.setVisible(true);
        }
        this.firePropertyChange(LAYOUT_CHANGED_PROPERTY, null, null);
    }

    public Color getHintForeground() {
        return this.labelHint.getDisabledTextColor();
    }

    public void setHintForeground(Color color) {
        this.labelHint.setDisabledTextColor(color);
    }

    public Color getHintBackground() {
        return this.labelHint.getBackground();
    }

    public void setHintBackground(Color color) {
        this.labelHint.setBackground(color);
    }
}

