/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.editors.StringArrayCustomizable;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class StringArrayCustomEditor
extends JPanel {
    private static String EMPTY_STRING = "";
    private static String SPACER = " ";
    private static String LINE_SEP = "\n";
    static final long serialVersionUID = -4347656479280614636L;
    private StringArrayCustomizable editor;
    private JLabel label;
    private JScrollPane scrollPane;
    private JTextArea textArea;

    public StringArrayCustomEditor(StringArrayCustomizable stringArrayCustomizable, String string) {
        this(stringArrayCustomizable);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)string);
    }

    public StringArrayCustomEditor(StringArrayCustomizable stringArrayCustomizable) {
        this.initComponents();
        this.editor = stringArrayCustomizable;
        String[] stringArray = this.editor.getStringArray();
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl;
                String string = stringArray[i];
                boolean bl2 = bl = i == stringArray.length - 1;
                if (string != null && string.trim().length() == 0) {
                    string = EMPTY_STRING;
                }
                stringBuffer.append(string);
                if (bl) continue;
                stringBuffer.append(LINE_SEP);
            }
        }
        this.textArea.setText(stringBuffer.toString());
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                StringArrayCustomEditor.this.updateValue();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                StringArrayCustomEditor.this.updateValue();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                StringArrayCustomEditor.this.updateValue();
            }
        });
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.label = new JLabel();
        this.textArea.setColumns(20);
        this.textArea.setRows(5);
        this.scrollPane.setViewportView(this.textArea);
        this.textArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(StringArrayCustomEditor.class, (String)"StringArrayCustomEditor.textArea.AccessibleContext.accessibleName"));
        this.textArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StringArrayCustomEditor.class, (String)"StringArrayCustomEditor.textArea.AccessibleContext.accessibleDescription"));
        this.label.setLabelFor(this.textArea);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)NbBundle.getMessage(StringArrayCustomEditor.class, (String)"StringArrayCustomEditor.label.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.label, -1, 386, Short.MAX_VALUE).add(1, (Component)this.scrollPane, -1, 386, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.label, -2, 32, -2).addPreferredGap(1).add((Component)this.scrollPane, -1, 171, Short.MAX_VALUE).addContainerGap()));
        this.label.getAccessibleContext().setAccessibleName(NbBundle.getMessage(StringArrayCustomEditor.class, (String)"StringArrayCustomEditor.label.AccessibleContext.accessibleName"));
        this.label.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StringArrayCustomEditor.class, (String)"StringArrayCustomEditor.label.AccessibleContext.accessibleDescription"));
    }

    public void updateValue() {
        String string = EMPTY_STRING;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.textArea.getText();
        if (string2.endsWith(LINE_SEP)) {
            string2 = string2 + SPACER;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, LINE_SEP, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.equals(LINE_SEP)) {
                arrayList.add(string3);
            } else if (string.equals(LINE_SEP)) {
                arrayList.add(SPACER);
            }
            string = string3;
        }
        this.editor.setStringArray(arrayList.toArray(new String[arrayList.size()]));
    }
}

