/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.form.CreationDescriptor;
import org.netbeans.modules.form.CreationFactory;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeExpressionOrigin;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.codestructure.CodeVariable;
import org.netbeans.modules.form.codestructure.FormCodeSupport;

final class BeanCodeManager {
    private Class beanClass;
    private FormProperty[] properties;
    private CodeExpression[] propertyExpressions;
    private int creationStyle;
    private boolean forceEmptyConstructor;
    private CreationDescriptor creationDesc;
    private CreationDescriptor.Creator currentCreator;
    private CodeStructure codeStructure;
    private CodeExpression beanExpression;
    private CodeGroup beanCode;
    private boolean isVariableSet;
    private int variableType;
    private boolean readingDone;

    public BeanCodeManager(Class clazz, FormProperty[] formPropertyArray, int n, boolean bl, CodeStructure codeStructure, int n2, CodeGroup codeGroup) {
        this.beanClass = clazz;
        this.properties = formPropertyArray;
        this.creationStyle = n | 1;
        this.forceEmptyConstructor = bl;
        this.codeStructure = codeStructure;
        this.variableType = n2;
        this.beanCode = codeGroup;
        this.isVariableSet = false;
        this.creationDesc = CreationFactory.getDescriptor(clazz);
        this.beanExpression = codeStructure.createDefaultExpression();
        this.readingDone = true;
        this.updateCode();
    }

    public BeanCodeManager(Class clazz, FormProperty[] formPropertyArray, int n, boolean bl, boolean bl2, CodeExpression codeExpression, CodeGroup codeGroup) {
        Object object;
        int n2;
        Class[] classArray;
        CodeExpression[] codeExpressionArray;
        this.beanClass = clazz;
        this.properties = formPropertyArray;
        this.creationStyle = n | 1;
        this.forceEmptyConstructor = bl;
        this.beanExpression = codeExpression;
        this.codeStructure = codeExpression.getCodeStructure();
        this.beanCode = codeGroup;
        this.readingDone = false;
        CodeVariable codeVariable = codeExpression.getVariable();
        CodeStatement codeStatement = codeVariable != null ? codeVariable.getAssignment(codeExpression) : null;
        this.isVariableSet = codeStatement != null;
        this.variableType = codeVariable != null ? codeVariable.getType() : 4096;
        this.creationDesc = CreationFactory.getDescriptor(clazz);
        if (this.creationDesc != null) {
            codeExpressionArray = codeExpression.getOrigin().getCreationParameters();
            classArray = new Class[codeExpressionArray.length];
            for (n2 = 0; n2 < codeExpressionArray.length; ++n2) {
                classArray[n2] = codeExpressionArray[n2].getOrigin().getType();
            }
            this.currentCreator = CreationFactory.findCreator(this.creationDesc, classArray);
            if (this.currentCreator != null) {
                String[] stringArray = this.currentCreator.getPropertyNames();
                block1: for (int i = 0; i < stringArray.length; ++i) {
                    object = stringArray[i];
                    for (int j = 0; j < this.properties.length; ++j) {
                        if (!this.properties[j].getName().equals(object)) continue;
                        FormCodeSupport.readPropertyExpression(codeExpressionArray[i], this.properties[j], bl2);
                        this.setPropertyExpression(j, codeExpressionArray[i]);
                        continue block1;
                    }
                }
                codeExpression.setOrigin(this.currentCreator.getCodeOrigin(codeExpressionArray));
            }
        }
        codeExpressionArray = CodeStructure.getDefinedStatementsIterator(codeExpression);
        block3: while (codeExpressionArray.hasNext()) {
            classArray = (CodeStatement)codeExpressionArray.next();
            for (n2 = 0; n2 < this.properties.length; ++n2) {
                FormProperty formProperty = this.properties[n2];
                if (!(formProperty instanceof RADProperty) || (object = ((RADProperty)formProperty).getPropertyDescriptor().getWriteMethod()) == null || !((Method)object).equals(classArray.getMetaObject())) continue;
                CodeExpression codeExpression2 = classArray.getStatementParameters()[0];
                FormCodeSupport.readPropertyExpression(codeExpression2, formProperty, bl2);
                this.setPropertyExpression(n2, codeExpression2);
                if (codeGroup == null) continue block3;
                codeGroup.addStatement((CodeStatement)classArray);
                continue block3;
            }
        }
        if (codeGroup != null && codeStatement != null) {
            codeGroup.addStatement(0, codeStatement);
        }
        this.readingDone = true;
    }

    public CodeExpression getCodeExpression() {
        return this.beanExpression;
    }

    public void updateCode() {
        Object object;
        CodeExpression[] codeExpressionArray;
        String[] stringArray;
        CreationDescriptor.Creator creator;
        if (!this.readingDone) {
            return;
        }
        CreationDescriptor.Creator creator2 = creator = this.creationDesc != null && !this.forceEmptyConstructor ? this.creationDesc.findBestCreator(this.properties, this.creationStyle) : null;
        if (creator != null) {
            stringArray = creator.getPropertyNames();
            codeExpressionArray = new CodeExpression[creator.getParameterCount()];
        } else {
            stringArray = null;
            codeExpressionArray = CodeStructure.EMPTY_PARAMS;
        }
        boolean bl = false;
        for (int i = 0; i < this.properties.length; ++i) {
            Object object2;
            boolean bl2;
            object = this.properties[i];
            boolean bl3 = bl2 = !object.isChanged();
            if (creator != null) {
                object2 = object.getName();
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!stringArray[j].equals(object2)) continue;
                    codeExpressionArray[j] = this.getPropertyExpression(i);
                    bl2 = true;
                    break;
                }
            }
            if (!(object instanceof RADProperty) || (object2 = ((RADProperty)((Object)object)).getPropertyDescriptor().getWriteMethod()) == null) continue;
            Iterator iterator = CodeStructure.getDefinedStatementsIterator(this.beanExpression);
            CodeStatement[] codeStatementArray = CodeStructure.filterStatements(iterator, object2);
            if (bl2) {
                for (int j = 0; j < codeStatementArray.length; ++j) {
                    CodeStatement codeStatement = codeStatementArray[j];
                    CodeStructure.removeStatement(codeStatement);
                    if (this.beanCode == null) continue;
                    this.beanCode.remove(codeStatement);
                }
                continue;
            }
            bl = true;
            if (codeStatementArray.length != 0) continue;
            CodeStatement codeStatement = CodeStructure.createStatement(this.beanExpression, (Method)object2, new CodeExpression[]{this.getPropertyExpression(i)});
            if (this.beanCode == null) continue;
            this.beanCode.addStatement(codeStatement);
        }
        if (creator != null) {
            if (creator != this.currentCreator) {
                this.currentCreator = creator;
                this.beanExpression.setOrigin(creator.getCodeOrigin(codeExpressionArray));
            }
        } else if (creator != this.currentCreator || this.beanExpression.getOrigin() == null) {
            this.currentCreator = null;
            CodeExpressionOrigin codeExpressionOrigin = null;
            try {
                object = this.beanClass.getConstructor(new Class[0]);
                codeExpressionOrigin = CodeStructure.createOrigin((Constructor)object, new CodeExpression[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Logger.getLogger(BeanCodeManager.class.getName()).log(Level.INFO, "[WARNING] No default constructor for " + this.beanClass.getName(), noSuchMethodException);
                return;
            }
            this.beanExpression.setOrigin(codeExpressionOrigin);
        }
        if (bl) {
            if (!this.isVariableSet) {
                CodeVariable codeVariable = this.codeStructure.createVariableForExpression(this.beanExpression, this.variableType, null);
                if (this.beanCode != null) {
                    this.beanCode.addStatement(0, codeVariable.getAssignment(this.beanExpression));
                }
                this.isVariableSet = true;
            }
        } else if (this.isVariableSet) {
            CodeVariable codeVariable = this.beanExpression.getVariable();
            if (codeVariable != null) {
                if (this.beanCode != null) {
                    this.beanCode.remove(codeVariable.getAssignment(this.beanExpression));
                }
                this.variableType = codeVariable.getType();
                this.codeStructure.removeExpressionFromVariable(this.beanExpression);
            }
            this.isVariableSet = false;
        }
    }

    private CodeExpression getPropertyExpression(int n) {
        CodeExpression codeExpression;
        if (this.propertyExpressions == null) {
            this.propertyExpressions = new CodeExpression[this.properties.length];
        }
        if ((codeExpression = this.propertyExpressions[n]) == null) {
            FormProperty formProperty = this.properties[n];
            this.propertyExpressions[n] = codeExpression = this.codeStructure.createExpression(FormCodeSupport.createOrigin(formProperty));
        }
        return codeExpression;
    }

    private void setPropertyExpression(int n, CodeExpression codeExpression) {
        if (this.propertyExpressions == null) {
            this.propertyExpressions = new CodeExpression[this.properties.length];
        }
        this.propertyExpressions[n] = codeExpression;
    }
}

